/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <aknviewappui.h>
#include <aknnotewrappers.h> 
#include <CalendarAPIexample.rsg> 
//#include <Testapp.rsg>

#include "CalendarAPIexampleEntryView.h"
#include "CalendarAPIexampleEntryContainer.h"
#include "CalendarAPIexampleEntriesView.h"
#include "CalendarAPIexampleSearchView.h"

#include "CalendarAPIexampleEngine.h"

// CONSTANTS
_LIT(KDeleteConfirmation, "Delete this anniversary?");

// ================= MEMBER FUNCTIONS =======================

// Two-phased constructor.
CCalendarAPIexampleEntryView* CCalendarAPIexampleEntryView::NewL(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleEntryView* self = CCalendarAPIexampleEntryView::NewLC(aEngine);
    CleanupStack::Pop(self);
    return self;
    }

// Two-phased constructor.
CCalendarAPIexampleEntryView* CCalendarAPIexampleEntryView::NewLC(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleEntryView* self = new (ELeave) CCalendarAPIexampleEntryView(aEngine);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }


CCalendarAPIexampleEntryView::CCalendarAPIexampleEntryView(
    MCalendarEngineCommandsInterface& aEngine) : iEngine(aEngine)
    {
    
    }

// destructor
CCalendarAPIexampleEntryView::~CCalendarAPIexampleEntryView()
    {
    delete iContainer;
    iContainer = NULL;
    }
    
// Symbian OS default constructor can leave.
void CCalendarAPIexampleEntryView::ConstructL()
    {
    BaseConstructL(R_CALENDARAPIEXAMPLE_ENTRY_VIEW);
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryView::Id()
// Returns ID of View
// ----------------------------------------------------
//  
TUid CCalendarAPIexampleEntryView::Id() const
    {
    return KEntryViewId;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryView::HandleCommandL()
// Takes care of command handling
// ----------------------------------------------------
//          
void CCalendarAPIexampleEntryView::HandleCommandL( TInt aCommand )
    {
    //If the command handling wouuld be given to AppUi:
    //AppUi()->ProcessCommandL(aCommandL);
    
    switch (aCommand)
        {
        case ECalendarAPIexampleCmdDelete:
            DoDeleteL();
            break;
        case EAknSoftkeyDone:
            DoSaveL();
            break;
        default:
            break;
        }
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntryView::DoActivateL()
// Gets called when the view is activated. Creates 
// the entry container, adds it to view control stack
// and sets it visible.
// ----------------------------------------------------
//      
void CCalendarAPIexampleEntryView::DoActivateL(
                                    const TVwsViewId& /*aPrevViewId*/,
                                    TUid /*aCustomMessageId*/,
                                    const TDesC8& /*aCustomMessage*/ )
    {
    if ( !iContainer )
        {
        
        TBuf<KMaxNameLength> name;
        TTime date;
        TBool alarm;
        TTime alarmTime;
        TInt synchronizationMethod;
        
        iEngine.CreateEntryForModificationL(iModify);
        
        iEngine.GetValuesToSet(name,date,alarm,alarmTime,
                               synchronizationMethod);
        
        iContainer = CCalendarAPIexampleEntryContainer::NewL(
            ClientRect(),name,date.DateTime(),alarm,alarmTime.DateTime(),
            synchronizationMethod);
                                
        iContainer->SetMopParent(this);

        // Adds Container to View control stack.
        AppUi()->AddToStackL( *this, iContainer );

        // Requires to display the default screen.
        iContainer->MakeVisible( ETrue );        
        }       
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntryView::DoDeactivate()
// Gets called when the view is deactivated. Removes
// the entry container from view control stack and
// deletes it.
// ----------------------------------------------------
//      
void CCalendarAPIexampleEntryView::DoDeactivate()
    {
    if ( iContainer )
        {
        // Removes Container from View control stack.
        AppUi()->RemoveFromStack(iContainer );
        }

    delete iContainer;
    iContainer = NULL;
    
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntryView::DoSaveL()
// Requests the model to save the current entry. If user
// input is invalid, an information note about it is 
// shown. Otherwise a proper view is activated.
// ----------------------------------------------------
//      
void CCalendarAPIexampleEntryView::DoSaveL()
    {
    TBuf<KMaxNameLength> name;
    TTime date;
    TBool alarm;
    TTime alarmTime;
    TInt sync;

    iContainer->SaveL();

    //Get the values which user has set to these variables
    iContainer->GetValues( name, date, alarm,
                                alarmTime, sync );

    
    TDateTime dateTime = date.DateTime();
    TDateTime alarmDateTime = alarmTime.DateTime();
    
    TBool valuesOk = iEngine.SetValuesToNewEntry(name,dateTime,alarm,
                                                alarmDateTime,sync);

    // User input invalid, show an information note about it.
    if ( !valuesOk )
        {
        CAknInformationNote* note = new (ELeave) CAknInformationNote;
        HBufC* errorMsg = CCoeEnv::Static()->AllocReadResourceLC(
                          R_CALENDARAPIEXAMPLE_INVALID_DATA);
        note->ExecuteLD(*errorMsg);
        CleanupStack::PopAndDestroy(errorMsg);
        }
    // User input valid.
    else
        {
        iEngine.DoSaveL();

        // We were modifying entry, activate entries view or search view
        if (iModify)
            {
            // After modification, entries still exist in the 
            // given search range, activate entries view.
            if (iEngine.EntryCount() > 0)
                {
                AppUi()->ActivateLocalViewL(KEntriesViewId);
                }
            // After modification, no entries exist anymore in the 
            // given search range, activate search view.
            else
                {
                AppUi()->ActivateLocalViewL(KSearchViewId);                 
                }
            }
        // We were adding an entry, activate search view.
        else
            {
            AppUi()->ActivateLocalViewL(KSearchViewId);
            }
        }
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntryView::DoDeleteL()
// Deletes the entry and activates a proper view.
// ----------------------------------------------------
//      
void CCalendarAPIexampleEntryView::DoDeleteL()
    {
    
    CAknQueryDialog* query = CAknQueryDialog::NewL();
    CleanupStack::PushL(query);
    query->SetPromptL(KDeleteConfirmation);
    CleanupStack::Pop(query);
    if (query->ExecuteLD(R_CALENDARAPIEXAMPLE_CONFIRMATION_QUERY))
        {
        // if we are modifying an entry, delete it and open a proper view
        if (iModify)
            {
            iEngine.ExecuteDeletionL();
            }
        // no need for deletion, because the new entry is not yet saved.
        else
            {
            AppUi()->ActivateLocalViewL(KSearchViewId);
            }
        }
    }


// End of File
