/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <barsread.h> //TResourceReader
#include <CalendarAPIexample.rsg>
#include "CalendarAPIexampleSearchContainer.h"
#include "CalendarAPIexample.pan"
#include "CalendarAPIexampleAppUi.h"
#include "CalendarAPIexampleSearchView.h"

// CONSTANTS
const TInt KPoint = 5;

// ================= MEMBER FUNCTIONS =======================

// constructor
CCalendarAPIexampleSearchContainer::CCalendarAPIexampleSearchContainer(CCalendarAPIexampleSearchView& aView)
    :   iSearchView(aView)
        {
        }
        
// destructor
CCalendarAPIexampleSearchContainer::~CCalendarAPIexampleSearchContainer()
    {
    }
    
// Two-phased constructor.  
CCalendarAPIexampleSearchContainer* CCalendarAPIexampleSearchContainer::NewL(const TRect& aRect,
                                                                            CCalendarAPIexampleSearchView& aView)
    {
    CCalendarAPIexampleSearchContainer* self = new (ELeave) CCalendarAPIexampleSearchContainer(aView);
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }

// Symbian OS default constructor can leave.    
void CCalendarAPIexampleSearchContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();    

    // Initialize component array
    InitComponentArrayL();
    
    iSearchListBox = new (ELeave) CAknSingleStyleListBox;
    iSearchListBox->SetContainerWindowL(*this); 

    TResourceReader reader; 
    CEikonEnv::Static()->CreateResourceReaderLC(reader, R_CALENDARAPIEXAMPLE_SEARCH_LIST); 
    iSearchListBox->ConstructFromResourceL(reader); 
    CleanupStack::PopAndDestroy(); //reader

    iSearchListBox->SetListBoxObserver(this);
    iSearchListBox->CreateScrollBarFrameL(ETrue);
    iSearchListBox->ScrollBarFrame()->SetScrollBarVisibilityL(  CEikScrollBarFrame::EOff,
                                                                CEikScrollBarFrame::EAuto);
    
    Components().AppendLC(iSearchListBox,1);
    CleanupStack::Pop( iSearchListBox );
    
    SetRect(aRect);
    ActivateL();
    }

// ----------------------------------------------------
// CCalendarAPIexampleSearchContainer::SizeChanged()
// Responds to size changes to set the size and 
// position of the contents of this control. 
// ----------------------------------------------------
//      
void CCalendarAPIexampleSearchContainer::SizeChanged()
    {
    if (iSearchListBox)
        {
        iSearchListBox->SetRect(Rect());
        }
    }

void CCalendarAPIexampleSearchContainer::HandleResourceChange(TInt aType)
    {
    CCoeControl::HandleResourceChange(aType);
    if ( aType==KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        }
    }

    
// ----------------------------------------------------
// CCalendarAPIexampleSearchContainer::OfferKeyEventL()
// When a key event occurs, the control framework calls 
// this function for each control on the control stack, 
// until one of them can process the key event 
// (and returns EKeyWasConsumed).
// ----------------------------------------------------
//      
TKeyResponse CCalendarAPIexampleSearchContainer::OfferKeyEventL(
                                  const TKeyEvent& aKeyEvent,TEventCode aType)
    {
    if(aType != EEventKey)
        {
        return EKeyWasNotConsumed;
        }    
    else if(iSearchListBox)
        {
        return iSearchListBox->OfferKeyEventL( aKeyEvent, aType );
        }
    else
        {
        return EKeyWasNotConsumed;
        }
    }


// ----------------------------------------------------
// CCalendarAPIexampleSearchContainer::Draw()
// This function is used for window server-initiated 
// redrawing of controls, and for some 
// application-initiated drawing.
// ----------------------------------------------------
//              
void CCalendarAPIexampleSearchContainer::Draw(const TRect& aRect) const
    {
    
    CWindowGc& gc = SystemGc();
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( KRgbWhite );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );
    gc.DrawRect( aRect );
    
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleSearchContainer::SearchType()
// Returns the selected search range (week, month,...)
// ----------------------------------------------------
//          
TSearchType CCalendarAPIexampleSearchContainer::SearchType() const
    {
    switch (iSearchListBox->CurrentItemIndex())
        {
        case 0:
            return EWeek;
        case 1:
            return EMonth;
        case 2:
            return ESixMonths;
        case 3:
            return EYear;
        default:
            Panic(EUnSupportedSearchType);
            break;
        }
    return EWeek;
    }    

// ----------------------------------------------------
// CCalendarAPIexampleSearchContainer::HandleListBoxEventL()
// Handles listbox events.
// ----------------------------------------------------
//  

void CCalendarAPIexampleSearchContainer::HandleListBoxEventL(CEikListBox* /*aListBox*/, TListBoxEvent aEventType)
    {
    if (aEventType == EEventEnterKeyPressed  || aEventType == EEventItemSingleClicked)
        {
        iSearchView.HandleCommandL(ECalendarAPIexampleCmdSearch);
        }   
    }


// end of file
