/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES
#include <avkon.hrh>
#include <aknviewappui.h>
#include <aknnotewrappers.h> //CAknInformationNote
#include <CalendarAPIexample.rsg>
#include "CalendarAPIexampleSearchView.h"
#include "CalendarAPIexampleSearchContainer.h"
#include "CalendarAPIexample.hrh"
#include "CalendarAPIexampleEntryView.h"
#include "CalendarAPIexampleEntriesView.h"
#include "CalendarAPIexampleDocument.h"

// ================= MEMBER FUNCTIONS =======================

// Two-phased constructor.
CCalendarAPIexampleSearchView* CCalendarAPIexampleSearchView::NewL(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleSearchView* self = CCalendarAPIexampleSearchView::NewLC(aEngine);
    CleanupStack::Pop(self);
    return self;
    }

// Two-phased constructor.
CCalendarAPIexampleSearchView* CCalendarAPIexampleSearchView::NewLC(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleSearchView* self = new (ELeave) CCalendarAPIexampleSearchView(aEngine);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }
    
// destructor
CCalendarAPIexampleSearchView::~CCalendarAPIexampleSearchView()
    {
    delete iContainer;
    iContainer = NULL;
    }


CCalendarAPIexampleSearchView::CCalendarAPIexampleSearchView(
    MCalendarEngineCommandsInterface& aEngine) : iEngine(aEngine)
    {
    }


// Symbian OS default constructor can leave.    
void CCalendarAPIexampleSearchView::ConstructL()
    {
    BaseConstructL(R_CALENDARAPIEXAMPLE_SEARCH_VIEW);
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleSearchView::Id()
// Returns ID of View
// ----------------------------------------------------
//  
TUid CCalendarAPIexampleSearchView::Id() const
    {
    return KSearchViewId;
    }

// ----------------------------------------------------
// CCalendarAPIexampleSearchView::HandleCommandL()
// Takes care of command handling
// ----------------------------------------------------
//      
void CCalendarAPIexampleSearchView::HandleCommandL( TInt aCommand )
    {
    switch (aCommand)
        {
        case EAknSoftkeyExit:
            AppUi()->ProcessCommandL(EAknCmdExit);
            break;
            
        case ECalendarAPIexampleCmdAdd:
            DoAddL();
            break;
        case ECalendarAPIexampleCmdSearch:
            DoSearchL();            
            break;
            
        default:
            break;
        }
    }
 
// ----------------------------------------------------
// CCalendarAPIexampleSearchView::DoActivateL()
// Gets called when the view is activated. Creates 
// the search container, adds it to view control stack
// and sets it visible.
// ----------------------------------------------------
//  
void CCalendarAPIexampleSearchView::DoActivateL(
                                        const TVwsViewId& /*aPrevViewId*/,
                                        TUid /*aCustomMessageId*/,
                                        const TDesC8& /*aCustomMessage*/ )
    {
    if ( !iContainer )
        {
        iContainer = CCalendarAPIexampleSearchContainer::NewL(
                                                    ClientRect(),*this);
        iContainer->SetMopParent(this);

        // Adds Container to View control stack.
        AppUi()->AddToStackL( *this, iContainer );

        // Requires to display the default screen.
        iContainer->MakeVisible( ETrue );        
        }       
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleSearchView::DoDeactivate()
// Gets called when the view is deactivated. Removes
// the search container from view control stack and
// deletes it.
// ----------------------------------------------------
//      
void CCalendarAPIexampleSearchView::DoDeactivate()
    {
    if ( iContainer )
        {
        // Removes Container from View control stack.
        AppUi()->RemoveFromStack( iContainer );
        }

    delete iContainer;
    iContainer = NULL;
    
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleSearchView::DoSearchL()
// Requests the model to do an entry search. If no 
// entries were found, an information note about it is
// displayed. If entries were found, entries view is
// activated.
// ----------------------------------------------------
//      
void CCalendarAPIexampleSearchView::DoSearchL()
    {
    TSearchType type = iContainer->SearchType();
    
    iEngine.DoSearchL(type);
    
    // No entries found, display information note.
    if (0 >= iEngine.EntryCount())
        {
        CAknInformationNote* note = new (ELeave) CAknInformationNote;
        HBufC* errorMsg = CCoeEnv::Static()->AllocReadResourceLC(
                                    R_CALENDARAPIEXAMPLE_NO_ENTRIES_FOUND);
                                    
        note->ExecuteLD(*errorMsg);
        CleanupStack::PopAndDestroy(errorMsg);
        }
    // Entries found, activate entries view
    else
        {
        AppUi()->ActivateLocalViewL(KEntriesViewId);        
        }
    }

// ----------------------------------------------------
// CCalendarAPIexampleSearchView::DoAddL()
// Resets models modify index, so that next call to 
// models EntryForModifycation will create a new entry.
// Activates the entry view.
// ----------------------------------------------------
//      
void CCalendarAPIexampleSearchView::DoAddL()
    {
    iEngine.DoAddL();
    }
    
// End of file
