/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef SMSEXAMPLEAPP_H
#define SMSEXAMPLEAPP_H

// INCLUDES
#include <aknapp.h>

// CONSTANTS
// UID of the application
const TUid KUidSMSExample = { 0xE01FF1e5 };

// CLASS DECLARATION

/**
* CSMSExampleApp application class.
* Provides factory to create concrete document object.
*
*/
class CSMSExampleApp : public CAknApplication
    {

    public: // Functions from base classes
    private:

        /**
        * From CApaApplication, creates CSMSExampleDocument document object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();

        /**
        * From CApaApplication, returns application's UID (KUidSMSExample).
        * @return The value of KUidSMSExample.
        */
        TUid AppDllUid() const;
    };

#endif

// End of File

