/*
 * Copyright (c) 2009 Nokia Corporation.
 */

#include <avkon.hrh>
#include <hlplch.h>
#include <eikmenup.h>

#include <HTTPClientExample.rsg>
#include "Client.pan"
#include "ClientAppUi.h"
#include "ClientAppView.h"
#include "ClientApplication.h"
#include "Client.hrh"
#include "HTTPClientExample_sc.hlp.hrh"

// Schemes for given uris
_LIT(KHttpPrefix, "http://");
_LIT8(KHttpPrefix8, "http://");

// HTTPS schemes
_LIT(KHttpsPrefix, "https://");
_LIT8(KHttpsPrefix8, "https://");

_LIT8(KMimeType, "text/plain");

// ----------------------------------------------------------------------------
// CClientAppUi::ConstructL()
//
// Second phase construction.
// ----------------------------------------------------------------------------
void CClientAppUi::ConstructL()
  {
    BaseConstructL(EAknEnableSkin);

    iAppView = CClientAppView::NewL(ClientRect());
    AddToStackL(iAppView);

    iEngine = CClientEngine::NewL(*iAppView);
  }

// ----------------------------------------------------------------------------
// CClientAppUi::CClientAppUi()
//
// First phase construction.
// ----------------------------------------------------------------------------
CClientAppUi::CClientAppUi()
  {
  }

// ----------------------------------------------------------------------------
// CClientAppUi::~CClientAppUi()
//
// Destructor.
// ----------------------------------------------------------------------------
CClientAppUi::~CClientAppUi()
  {
  delete iEngine;
  if (iAppView)
    {
    iEikonEnv->RemoveFromStack(iAppView);
    delete iAppView;
    }
  }

// ----------------------------------------------------------------------------
// CClientAppUi::HandleCommandL()
//
// Handles user commands.
// ----------------------------------------------------------------------------
void CClientAppUi::HandleCommandL(TInt aCommand)
  {
  switch(aCommand)
    {
    case EEikCmdExit:
    case EAknSoftkeyExit:
      Exit();
      break;

    case EClientGet:
      {
      // Issue HTTP get to engine; first cancel possible existing transaction
      iEngine->CancelTransaction();

      // Query uri
      TBuf<KDefaultBufferSize> uri;
      CAknTextQueryDialog* dlg = new (ELeave) CAknTextQueryDialog(uri,
        CAknQueryDialog::ENoTone);

      if (! dlg->ExecuteLD(R_DIALOG_URI_QUERY))
        break;

      iAppView->ResetL();

      // Insert prefix to uri (it must begin with "http://" or "https://")
      TBuf8<KDefaultBufferSize> uri8;
      uri.LowerCase();
      if(uri.Find(KHttpPrefix) == KErrNotFound
        && uri.Find(KHttpsPrefix) == KErrNotFound)
        {
        // If the uri does not contain http or https,
        // use the default, "http://"
        uri8.Append(KHttpPrefix8);
        uri8.Append(uri);
        }
      else
        {
        uri8.Copy(uri);
        }

      // Start transaction
        // TODO:
      TRAPD(err, iEngine->IssueHTTPGetL(uri8));
      }
      break;

    case EClientPost:
      {
      // Issue HTTP post to engine; first cancel possible existing transaction
      iEngine->CancelTransaction();

      // Query uri and data to post
      TBuf<KDefaultBufferSize> uri;
      TBuf<KDefaultBufferSize> postData;
      CAknMultiLineDataQueryDialog* dlg =
        CAknMultiLineDataQueryDialog::NewL(uri, postData);

      if (!dlg->ExecuteLD(R_DIALOG_URI_POST_QUERY))
        break;

      iAppView->ResetL();

      // Insert prefix to uri (it must begin with "http://" or "https://")
      TBuf8<KDefaultBufferSize> uri8;
      uri.LowerCase();
      if(uri.Find(KHttpPrefix) == KErrNotFound
        && uri.Find(KHttpsPrefix) == KErrNotFound)
        {
        // If uri does not contain http or https,
        // use the default, "http://"
        uri8.Append(KHttpPrefix8);
        uri8.Append(uri);
        }
      else
        {
        uri8.Copy(uri);
        }

      TBuf8<KDefaultBufferSize> postData8;
      postData8.Copy(postData);

      // Start transaction
      TRAPD(err, iEngine->IssueHTTPPostL(uri8, KMimeType, postData8));
      // TODO: Error handling
      if (err)
          {
          }
      }
      break;

    case EClientCancel:
      {
      // Cancel current transaction
      iEngine->CancelTransaction();
      }
      break;

    // Switch focus to the other rich text editor
    case EClientSwitchFocus:
      {
      iAppView->SwitchFocus();
      }
      break;
      
    case EClientHelp:
      {
      CArrayFix <TCoeHelpContext>* buf = CCoeAppUi::AppHelpContextL();
      HlpLauncher::LaunchHelpApplicationL( iEikonEnv->WsSession(), buf );
      }
      break;

    case EClientAbout:
      {
      HBufC* title = iEikonEnv->AllocReadResourceLC(R_ABOUT_DIALOG_TITLE);
      HBufC* msg = iEikonEnv->AllocReadResourceLC(R_ABOUT_DIALOG_TEXT);

      // Note: CodeScanner gives a false positive of "Neglected to put
      // variable on cleanup stack (Id: 35)" on dlg.
      CAknMessageQueryDialog* dlg = CAknMessageQueryDialog::NewL(*msg);  // CSI: 35 #
      dlg->PrepareLC(R_DIALOG_ABOUT);
      dlg->SetHeaderTextL(*title);
      dlg->RunLD();

      CleanupStack::PopAndDestroy(msg);
      CleanupStack::PopAndDestroy(title);
      }
      break;

    default:
      {
      Panic(EClientUi);
      }
      break;
    }
  }

// -----------------------------------------------------------------------------
// CClientAppUi::HelpContextL()
//
// Return the help context for this application.
// -----------------------------------------------------------------------------
CArrayFix <TCoeHelpContext>* CClientAppUi::HelpContextL() const
    {
    CArrayFixFlat <TCoeHelpContext>* array = new (ELeave)CArrayFixFlat <TCoeHelpContext>(1);
    CleanupStack::PushL(array);
    array->AppendL(TCoeHelpContext(KUidHelpFile, KContextApplication));
    CleanupStack::Pop(array);
    return array;
    }

// ----------------------------------------------------------------------------
// CClientAppUi::DynInitMenuPaneL()
//
// Initializes the menu pane when it's activated.
// ----------------------------------------------------------------------------
void CClientAppUi::DynInitMenuPaneL(TInt aMenuId, CEikMenuPane* aMenuPane)
  {
  // "Cancel" selection is only available when trasaction running in engine
  if (aMenuId == R_EXAMPLECLIENT_MENU)
    aMenuPane->SetItemDimmed(EClientCancel, !iEngine->IsRunning());
  }

// end of file
