% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_up_functs.R
\name{create_and_store_dictionaries}
\alias{create_and_store_dictionaries}
\title{Create and store dictionaries}
\usage{
create_and_store_dictionaries(
  gene_gRNA_group_pairs,
  gene_precomp_dir,
  gRNA_precomp_dir,
  results_dir,
  pod_sizes
)
}
\arguments{
\item{gene_gRNA_group_pairs}{a data frame specifying the gene-gRNA group pairs to test for association; the data frame should contain columns named \code{gene_id} and \code{gRNA_group}.}

\item{gene_precomp_dir}{the directory in which to store the gene precomputations}

\item{gRNA_precomp_dir}{the directory in which to store the gRNA precomputations}

\item{results_dir}{the directory in which to store the results}

\item{pod_sizes}{an integer vector with three named elements: gRNA, gene, and pair. These elements give the sizes of the respective "pods."}
}
\value{
an integer vector containing the number of pods in the gene, gRNA, and pairs dictionaries.
}
\description{
We require a few bookkeeping files (that we call "dictionaries") for the gRNA and gene precomputation steps.
This file creates those dictionaries and stores them in the appropriate locations on disk.
}
