% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_up_functs.R
\name{run_gRNA_precomputation_at_scale}
\alias{run_gRNA_precomputation_at_scale}
\title{Run gRNA precomputation at scale}
\usage{
run_gRNA_precomputation_at_scale(
  pod_id,
  gRNA_precomp_dir,
  combined_perturbation_matrix,
  covariate_matrix,
  log_dir,
  B,
  seed
)
}
\arguments{
\item{pod_id}{ID of the pod for which to do the precomputation}

\item{gRNA_precomp_dir}{file path to the gRNA precomputation directory}

\item{combined_perturbation_matrix}{a binary matrix of perturbations (i.e., gRNA group-to-cell assignments); the rows (i.e., gRNA groups) and columns (i.e., cell barcodes) should be named.}

\item{covariate_matrix}{the cell-specific matrix of technical factors, ideally containing the following covariates: log-transformed gene library size (numeric), log-transformed gRNA library size (numeric), percent mitochondrial reads (numeric), and batch (factor). The rows (i.e., cell barcodes) should be named}

\item{log_dir}{file path to the log directory}

\item{B}{number of resamples to draw for the conditional randomization test. (default 1000)}

\item{seed}{seed to the random number generator (default 4)}
}
\description{
This function runs the gRNA precomputation on a selected "pod" of gRNAs (as identified by the pod_id).
It stores the result in the gRNA precomputation directory.
}
