% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covariate_matrix}
\alias{covariate_matrix}
\title{Covariate matrix}
\format{
An object of class \code{data.frame} with 40000 rows and 4 columns.
}
\usage{
data(covariate_matrix)
}
\description{
A matrix of cell-specific technical factors:
\describe{
\item{\code{lg_gRNA_lib_size}}{(numeric) log-transformed gRNA library size}
\item{\code{lg_gene_lib_size}}{(numeric) log-transformed gene library size}
\item{\code{p_mito}}{(numeric) fraction of sequenced gene transcripts that map to mitochondrial genes}
\item{\code{batch}}{(factor) sequencing batch (\code{batch_1}, \code{batch_2})}
}
}
\section{Overview}{

This object is part of the example data. The data are taken from the paper "A genome-wide framework for mapping gene regulation via cellular genetic screens" by Gasperini et al., 2019. The authors used a CRISPRi-based assay to target 5,000+ putative enhancers in a population of K562 cells. The authors additionally targeted 200+ gene transcription start sites (TSSs) and designed a library of 50 non-targeting gRNAs to serve as negative controls. Genes, gRNAs, and cells are all down-sampled to reduce the size of the data.
}

\keyword{datasets}
