% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functs.R
\name{combine_perturbations}
\alias{combine_perturbations}
\title{Combine perturbations}
\usage{
combine_perturbations(perturbation_matrix, gRNA_groups_table)
}
\arguments{
\item{perturbation_matrix}{a perturbation matrix (i.e., a binary matrix of gRNA-to-cell assignments) stored as a sparse matrix (as implemented by the Matrix package) or a dense matrix (as implemented by base R); the row names should be the gRNA IDs.}

\item{gRNA_groups_table}{a data frame with columns \code{gRNA_id} and \code{gRNA_group}, mapping each gRNA to its gRNA group}
}
\value{
a "combined" perturbation matrix, where gRNAs within the same gRNA group have been collapsed into a single row
}
\description{
Combines perturbations by collapsing gRNAs within the same group into a single "combined" gRNA.
}
\details{
The function combines binary (i.e., 0/1) perturbation vectors via a "max" operation. In other words, if \code{x1}, \code{x2}, ..., \code{xp} are binary perturbation vectors, then the "combined" perturbation vector \code{v} is \code{v = pmax(x1, x2, ..., xp)}, where \code{pmax} is the element-wise maximum function.
}
\examples{
library(Matrix)
data("gRNA_matrix")
data("gRNA_groups_table")
perturbation_matrix <- threshold_gRNA_matrix(gRNA_matrix)
combined_perturbation_matrix <- combine_perturbations(perturbation_matrix, gRNA_groups_table)
}
