% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functs.R
\name{threshold_gRNA_matrix}
\alias{threshold_gRNA_matrix}
\title{Threshold gRNA count matrix}
\usage{
threshold_gRNA_matrix(gRNA_matrix, threshold = 3)
}
\arguments{
\item{gRNA_matrix}{a gRNA-by-cell expression matrix; the matrix can be represented as a sparse matrix (as implemented by the Matrix package) or a dense matrix (as implemented by base R)}

\item{threshold}{the threshold used to assign perturbation indicators to cells; counts above the threshold are set to 1 (indicating "perturbed"), and counts below the threshold are set to 0 (indicating "unperturbed")}
}
\value{
a binary matrix of perturbation assignments
}
\description{
Thresholds a gRNA count matrix, producing a perturbation matrix.
}
\examples{
data(gRNA_matrix)
perturbation_matrix <- threshold_gRNA_matrix(gRNA_matrix)
}
