//
//  ViewController.m
//  CoreImageFun
//
//  Created by chenjiang on 15/11/28.
//  Copyright © 2015年 chenjiang. All rights reserved.
//

#import "ViewController.h"
#import "UIView+Addition.h"
#import <CoreImage/CoreImage.h>

@interface ViewController ()<UIImagePickerControllerDelegate, UINavigationControllerDelegate>
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, strong) UISlider *amountSlider;
@property (nonatomic, strong) UIButton *loadPhotoBtn;
@end

@implementation ViewController{
    CIContext *context;
    CIFilter *filter;
    CIImage *beginImage;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    self.view.backgroundColor = [UIColor whiteColor];
    
    _imageView = [[UIImageView alloc] init];
    [self.view addSubview:_imageView];
    _imageView.bounds = CGRectMake(0, 0, self.view.width, 300);
    _imageView.centerX = self.view.width / 2.0f;
    _imageView.top = 0;
    _imageView.borderColor = [UIColor redColor];
    
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"image" ofType:@"png"];
    NSURL *fileNameAndPath = [NSURL fileURLWithPath:filePath];
    
    beginImage = [CIImage imageWithContentsOfURL:fileNameAndPath];
    context = [CIContext contextWithOptions:nil];
    
    filter = [CIFilter filterWithName:@"CISepiaTone" keysAndValues:kCIInputImageKey, beginImage, @"inputIntensity", @(0.8), nil];
    CIImage *outImage = [filter outputImage];
    CGImageRef cgimg = [context createCGImage:outImage fromRect:[outImage extent]];
    UIImage *newImage = [UIImage imageWithCGImage:cgimg];
    self.imageView.image = newImage;
    CGImageRelease(cgimg);
    
    [_imageView sizeToFit];
    _imageView.top = 0 ;
    _imageView.centerX = self.view.width / 2.0f;
    
    _amountSlider = [[UISlider alloc] init];
    [self.view addSubview:_amountSlider];
    _amountSlider.bounds = CGRectMake(0, 0, self.view.width - 40, 44);
    _amountSlider.top = _imageView.bottom + 20.0f;
    _amountSlider.centerX = self.view.width / 2.0f;
    [_amountSlider addTarget:self action:@selector(amountSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
    
    _loadPhotoBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.view addSubview:_loadPhotoBtn];
    _loadPhotoBtn.bounds = CGRectMake(0, 0, 150, 40);
    _loadPhotoBtn.right = _amountSlider.right;
    _loadPhotoBtn.top = _amountSlider.bottom + 14.0f;
    [_loadPhotoBtn setTitle:@"Photo Album" forState:UIControlStateNormal];
    [_loadPhotoBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
    _loadPhotoBtn.borderColor = [UIColor blueColor];
    _loadPhotoBtn.layer.cornerRadius = 5.0f;
    _loadPhotoBtn.layer.masksToBounds = YES;
    [_loadPhotoBtn addTarget:self action:@selector(loadPhoto:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)loadPhoto:(UIButton *)sender {
    UIImagePickerController *pickerVC = [[UIImagePickerController alloc] init];
    pickerVC.delegate = self;
    [self presentViewController:pickerVC animated:YES completion:nil];
}

- (void)amountSliderValueChanged:(UISlider *)slider {
    NSLog(@"amountSliderValueChanged...");
    float slideValue = slider.value;
    [filter setValue:@(slideValue) forKey:@"inputIntensity"];
    CIImage *outputImage = [filter outputImage];
    CGImageRef cgimg = [context createCGImage:outputImage fromRect:[outputImage extent]];
    UIImage *newImage = [UIImage imageWithCGImage:cgimg];
    _imageView.image = newImage;
    CGImageRelease(cgimg);
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info {
    [self dismissViewControllerAnimated:YES completion:nil];
    NSLog(@"%@", info);
    UIImage *gotImage = [info objectForKey:UIImagePickerControllerOriginalImage];
    beginImage = [CIImage imageWithCGImage:gotImage.CGImage];
    [filter setValue:beginImage forKey:kCIInputImageKey];
    [self amountSliderValueChanged:self.amountSlider];
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end


























