#!/usr/bin/python

# -*- coding: utf-8 -*-
"""
Created on 05/03/2021

"""

import sys
import csv
import time

sourceDataFile = "OnlineRetail.csv"
lastRecordState = "LastRecord.txt"

"""
This function generates purchase order records using the 
OnlineRetail.csv file. Each batch of records is saved in a 
separate .log file. 
AWS Kinesis Agent reads these records, and 
pushes them into Kinesis Data Streams.
Parameters:
- 'startRecord' - record from which to start reading
- 'numRecordsToGenerate' - number of records to generate
"""
def GenerateOrderRecords(startRecord, numRecordsToGenerate):   
    destLogFile = time.strftime("/var/log/varietygifts/%Y%m%d-%H%M%S.log")
   # Note if you are on Windows, and want to test the code locally, uncomment the
   # line below, and comment out the line above.
   # destLogFile = time.strftime("var\\log\\varietygifts\\%Y%m%d-%H%M%S.log")
    with open(sourceDataFile, 'r') as sourceCsvfile:
        with open(destLogFile, 'w') as dstCsvfile:
            reader = csv.reader(sourceCsvfile)
            writer = csv.writer(dstCsvfile)
            #Ignore header in the source .csv file
            next (reader) 
            inputRow = 0
            numOfRecordsWritten = 0
            for row in reader:
                inputRow += 1
                if (inputRow > startRecord):
                    writer.writerow(row)
                    numOfRecordsWritten += 1
                    if (numOfRecordsWritten >= numRecordsToGenerate):
                        break
            return numOfRecordsWritten


#Get the total count of records in OnlineRetail.csv file
def GetRecordCount():
    with open(sourceDataFile) as srcFile:
        for recordCount, l in enumerate(srcFile):
            pass
    return recordCount
    
numOfRecordsToGenerate = 200
startRecord = 0            
if (len(sys.argv) > 1):
    numOfRecordsToGenerate = int(sys.argv[1])


#Check the current state of generated records:
try:
    with open(lastRecordState, 'r') as f:
        for line in f:
             startRecord = int(line)
except IOError:
    startRecord = 0

print("Writing " + str(numOfRecordsToGenerate) + " records starting at record " + str(startRecord) + "\n")

totalRecordsWritten = 0
recordsInFile = GetRecordCount()

while (totalRecordsWritten < numOfRecordsToGenerate):
    recordsWritten = GenerateOrderRecords(startRecord, numOfRecordsToGenerate - totalRecordsWritten)
    totalRecordsWritten += recordsWritten
    startRecord += recordsWritten
    # Check if we reached the end of the file, reset the current state:
    if (startRecord >= recordsInFile):
        startRecord = 0
        
print("Generated " + str(totalRecordsWritten) + " records.\n")
    
with open(lastRecordState, 'w') as f:
    f.write(str(startRecord))