# -*- coding: utf-8 -*-

'''
Descent
'''

import os,sys,re,json,urllib,urlparse,datetime,base64,xbmc

from resources.lib.modules import trakt
from resources.lib.modules import cleangenre
from resources.lib.modules import cleantitle
from resources.lib.modules import control
from resources.lib.modules import client
from resources.lib.modules import cache
from resources.lib.modules import metacache
from resources.lib.modules import playcount
from resources.lib.modules import workers
from resources.lib.modules import views
from resources.lib.modules import utils
from resources.lib.indexers import navigator

sysaddon = sys.argv[0] ; syshandle = int(sys.argv[1])
artPath = control.artPath() ; addonFanart = control.addonFanart()

params = dict(urlparse.parse_qsl(sys.argv[2].replace('?',''))) if len(sys.argv) > 1 else dict()
action = params.get('action')


class collections:
    def __init__(self):
        self.list = []

        self.datetime = (datetime.datetime.utcnow() - datetime.timedelta(hours = 5))
        self.systime = (self.datetime).strftime('%Y%m%d%H%M%S%f')
        self.today_date = (self.datetime).strftime('%Y-%m-%d')
        self.month_date = (self.datetime - datetime.timedelta(days = 30)).strftime('%Y-%m-%d')
        self.year_date = (self.datetime - datetime.timedelta(days = 365)).strftime('%Y-%m-%d')

        self.imdb_link = 'https://www.imdb.com'
        self.imdb_user = control.setting('imdb.user').replace('ur', '')
        self.imdbinfo = 'https://www.omdbapi.com/?i=%s&plot=short&r=json'

        self.lang = control.apiLanguage()['trakt']

        self.tmdb_key = control.setting('tm.user')
        if self.tmdb_key == '' or self.tmdb_key == None:
            self.tmdb_key = '3320855e65a9758297fec4f7c9717698'
        self.tm_user = self.tmdb_key

        self.tmdb_lang = 'en'
        self.tmdb_link = 'https://api.themoviedb.org'
        self.tmdb_image = 'https://image.tmdb.org/t/p/original'
        self.tmdb_poster = 'https://image.tmdb.org/t/p/w500'
        self.tmdb_api_link = 'https://api.themoviedb.org/3/list/%s?api_key=%s' % ('%s', '%s')
        self.tmdb_info_link = 'https://api.themoviedb.org/3/movie/%s?api_key=%s&language=%s&append_to_response=credits,releases,external_ids' % ('%s', self.tmdb_key, self.tmdb_lang)
        self.tm_art_link = 'https://api.themoviedb.org/3/movie/%s/images?api_key=%s&language=en-US&include_image_language=en,%s,null' % ('%s', self.tmdb_key, self.lang)
        self.tm_img_link = 'https://image.tmdb.org/t/p/w%s%s'

        self.fanart_tv_user = control.setting('fanart.tv.user')
        if self.fanart_tv_user == '' or self.fanart_tv_user == None:
            self.fanart_tv_user = 'cf0ebcc2f7b824bd04cf3a318f15c17d'
        self.user = str('self.fanart_tv_user') + str(control.setting('tm.user'))
        self.fanart_tv_art_link = 'http://webservice.fanart.tv/v3/movies/%s'
        self.fanart_tv_level_link = 'http://webservice.fanart.tv/v3/level'



        self.imdblists_link = 'https://www.imdb.com/user/ur%s/lists?tab=all&sort=mdfd&order=desc&filter=titles' % self.imdb_user
        self.imdblist_link = 'https://www.imdb.com/list/%s/?view=detail&sort=alpha,asc&title_type=movie,short,tvMovie,tvSpecial,video&start=1'
        self.imdblist2_link = 'https://www.imdb.com/list/%s/?view=detail&sort=date_added,desc&title_type=movie,short,tvMovie,tvSpecial,video&start=1'
        self.imdbwatchlist_link = 'https://www.imdb.com/user/ur%s/watchlist?sort=alpha,asc' % self.imdb_user
        self.imdbwatchlist2_link = 'https://www.imdb.com/user/ur%s/watchlist?sort=date_added,desc' % self.imdb_user

# My collection
        self.moviemy_link = 'https://api.themoviedb.org/3/list/119265?api_key=%s' % (self.tmdb_key) 


# Christmas Movies
        self.xmasmovies_link = 'https://api.themoviedb.org/3/list/32770?api_key=%s' % (self.tmdb_key)

# DC Comics Movies
        self.dcmovies_link = 'https://api.themoviedb.org/3/list/32799?api_key=%s' % (self.tmdb_key)

# Disney Movies
        self.disneymovies_link = 'https://api.themoviedb.org/3/list/32800?api_key=%s' % (self.tmdb_key)

# Kids Movies
        self.kidsmovies_link = 'https://api.themoviedb.org/3/list/32802?api_key=%s' % (self.tmdb_key)
	self.kidsmovies2_link ='https://api.themoviedb.org/3/list/119707?api_key=%s' % (self.tmdb_key) #

# Marvel Movies
        self.marvelmovies_link = 'https://api.themoviedb.org/3/list/32793?api_key=%s' % (self.tmdb_key)

# Boxset Collection

        self.tmdb300_link = self.tmdb_api_link % ('13132', self.tmdb_key)
        self.fortyeighthours_link = self.tmdb_api_link % ('33259', self.tmdb_key)
        self.aceventura_link = self.tmdb_api_link % ('33260', self.tmdb_key)
        self.aceventura_link = self.tmdb_api_link % ('33260', self.tmdb_key)
        self.airplane_link = self.tmdb_api_link % ('33261', self.tmdb_key)
        self.airport_link = self.tmdb_api_link % ('33262', self.tmdb_key)
        self.americangraffiti_link = self.tmdb_api_link % ('33263', self.tmdb_key)
        self.anaconda_link = self.tmdb_api_link % ('33264', self.tmdb_key)
        self.analyzethis_link = self.tmdb_api_link % ('33265', self.tmdb_key)
        self.anchorman_link = self.tmdb_api_link % ('33266', self.tmdb_key)
        self.austinpowers_link = self.tmdb_api_link % ('33267', self.tmdb_key)
        self.backtothefuture_link = self.tmdb_api_link % ('33268', self.tmdb_key)
        self.badboys_link = self.tmdb_api_link % ('33269', self.tmdb_key)
        self.badsanta_link = self.tmdb_api_link % ('33270', self.tmdb_key)
        self.basicinstinct_link = self.tmdb_api_link % ('33271', self.tmdb_key)
        self.beverlyhillscop_link = self.tmdb_api_link % ('33272', self.tmdb_key)
        self.bigmommashouse_link = self.tmdb_api_link % ('33273', self.tmdb_key)
        self.bluesbrothers_link = self.tmdb_api_link % ('33274', self.tmdb_key)
        self.bourne_link = self.tmdb_api_link % ('33275', self.tmdb_key)
        self.brucealmighty_link = self.tmdb_api_link % ('33276', self.tmdb_key)
        self.caddyshack_link = self.tmdb_api_link % ('33277', self.tmdb_key)
        self.cheaperbythedozen_link = self.tmdb_api_link % ('33278', self.tmdb_key)
        self.cheechandchong_link = self.tmdb_api_link % ('33420', self.tmdb_key)
        self.childsplay_link = self.tmdb_api_link % ('33279', self.tmdb_key)
        self.cityslickers_link = self.tmdb_api_link % ('33280', self.tmdb_key)
        self.conan_link = self.tmdb_api_link % ('33281', self.tmdb_key)
        self.crank_link = self.tmdb_api_link % ('33282', self.tmdb_key)
        self.crocodiledundee_link = self.tmdb_api_link % ('33419', self.tmdb_key)
        self.thecrow_link = self.tmdb_api_link % ('13294', self.tmdb_key)
        self.davincicode_link = self.tmdb_api_link % ('33283', self.tmdb_key)
        self.daddydaycare_link = self.tmdb_api_link % ('33284', self.tmdb_key)
        self.deathwish_link = self.tmdb_api_link % ('33285', self.tmdb_key)
        self.deltaforce_link = self.tmdb_api_link % ('33286', self.tmdb_key)
        self.diehard_link = self.tmdb_api_link % ('33287', self.tmdb_key)
        self.dirtydancing_link = self.tmdb_api_link % ('33288', self.tmdb_key)
        self.dirtyharry_link = self.tmdb_api_link % ('33289', self.tmdb_key)
        self.dumbanddumber_link = self.tmdb_api_link % ('33290', self.tmdb_key)
        self.escapefromnewyork_link = self.tmdb_api_link % ('33291', self.tmdb_key)
        self.everywhichwaybutloose_link = self.tmdb_api_link % ('33292', self.tmdb_key)
        self.exorcist_link = self.tmdb_api_link % ('33293', self.tmdb_key)
        self.theexpendables_link = self.tmdb_api_link % ('33294', self.tmdb_key)
        self.fastandthefurious_link = self.tmdb_api_link % ('32779', self.tmdb_key)
        self.fatherofthebride_link = self.tmdb_api_link % ('33295', self.tmdb_key)
        self.fletch_link = self.tmdb_api_link % ('33296', self.tmdb_key)
        self.friday_link = self.tmdb_api_link % ('33297', self.tmdb_key)
        self.fridaythe13th_link = self.tmdb_api_link % ('33298', self.tmdb_key)
        self.fugitive_link = self.tmdb_api_link % ('33299', self.tmdb_key)
        self.gijoe_link = self.tmdb_api_link % ('33300', self.tmdb_key)
        self.getshorty_link = self.tmdb_api_link % ('33301', self.tmdb_key)
        self.gettysburg_link = self.tmdb_api_link % ('33302', self.tmdb_key)
        self.ghostrider_link = self.tmdb_api_link % ('33303', self.tmdb_key)
        self.ghostbusters_link = self.tmdb_api_link % ('33201', self.tmdb_key)
        self.godsnotdead_link = self.tmdb_api_link % ('33304', self.tmdb_key)
        self.godfather_link = self.tmdb_api_link % ('33305', self.tmdb_key)
        self.godzilla_link = self.tmdb_api_link % ('33306', self.tmdb_key)
        self.grownups_link = self.tmdb_api_link % ('33307', self.tmdb_key)
        self.grumpyoldmen_link = self.tmdb_api_link % ('33308', self.tmdb_key)
        self.gunsofnavarone_link = self.tmdb_api_link % ('33309', self.tmdb_key)
        self.halloween_link = self.tmdb_api_link % ('33310', self.tmdb_key)
        self.hangover_link = self.tmdb_api_link % ('33311', self.tmdb_key)
        self.hanniballector_link = self.tmdb_api_link % ('33312', self.tmdb_key)
        self.hellraiser_link = self.tmdb_api_link % ('33313', self.tmdb_key)
        self.highlander_link = self.tmdb_api_link % ('13256', self.tmdb_key)
        self.thehobbit_link = 'https://www.imdb.com/search/title?title=the+hobbit&title_type=feature,tv_movie&num_votes=1000,&countries=us&languages=en'
        self.hollowman_link = self.tmdb_api_link % ('13251', self.tmdb_key)
        self.honeyishrunkthekids_link = self.tmdb_api_link % ('33208', self.tmdb_key)
        self.horriblebosses_link = self.tmdb_api_link % ('33314', self.tmdb_key)
        self.hostel_link = self.tmdb_api_link % ('33315', self.tmdb_key)
        self.hotshots_link = self.tmdb_api_link % ('33316', self.tmdb_key)
        self.hungergames_link = 'https://www.imdb.com/search/title?title=hunger+games&title_type=feature&num_votes=1000,&countries=us&languages=en&sort=release_date,desc'
        self.huntsman_link = self.tmdb_api_link % ('13235', self.tmdb_key)
        self.independenceday_link = self.tmdb_api_link % ('33317', self.tmdb_key)
        self.indianajones_link = self.tmdb_api_link % ('33318', self.tmdb_key)
        self.insidious_link = self.tmdb_api_link % ('33319', self.tmdb_key)
        self.ironeagle_link = self.tmdb_api_link % ('33320', self.tmdb_key)
        self.jackreacher_link = self.tmdb_api_link % ('33321', self.tmdb_key)
        self.jackryan_link = self.tmdb_api_link % ('33322', self.tmdb_key)
        self.jackass_link = self.tmdb_api_link % ('33323', self.tmdb_key)
        self.jamesbond_link = self.tmdb_api_link % ('33324', self.tmdb_key)
        self.jaws_link = self.tmdb_api_link % ('33325', self.tmdb_key)
        self.jeeperscreepers_link = self.tmdb_api_link % ('33326', self.tmdb_key)
        self.johnwick_link = self.tmdb_api_link % ('33327', self.tmdb_key)
        self.jumanji_link = self.tmdb_api_link % ('33328', self.tmdb_key)
        self.jurassicpark_link = self.tmdb_api_link % ('33217', self.tmdb_key)
        self.kickass_link = self.tmdb_api_link % ('33329', self.tmdb_key)
        self.killbill_link = self.tmdb_api_link % ('33330', self.tmdb_key)
        self.kingkong_link = self.tmdb_api_link % ('33331', self.tmdb_key)
        self.laracroft_link = self.tmdb_api_link % ('33332', self.tmdb_key)
        self.legallyblonde_link = self.tmdb_api_link % ('33333', self.tmdb_key)
        self.lethalweapon_link = self.tmdb_api_link % ('33334', self.tmdb_key)
        self.lookwhostalking_link = self.tmdb_api_link % ('33335', self.tmdb_key)
        self.lordoftherings_link = 'https://www.imdb.com/search/title?title=the+lord+of+the+rings&title_type=feature&num_votes=1000,&countries=us&languages=en'
        self.machete_link = self.tmdb_api_link % ('33336', self.tmdb_key)
        self.magicmike_link = self.tmdb_api_link % ('33337', self.tmdb_key)
        self.majorleague_link = self.tmdb_api_link % ('33338', self.tmdb_key)
        self.manfromsnowyriver_link = self.tmdb_api_link % ('33339', self.tmdb_key)
        self.mask_link = self.tmdb_api_link % ('33340', self.tmdb_key)
        self.matrix_link = self.tmdb_api_link % ('33341', self.tmdb_key)
        self.mazerunner_link = self.tmdb_api_link % ('13182', self.tmdb_key)
        self.themechanic_link = self.tmdb_api_link % ('33342', self.tmdb_key)
        self.meettheparents_link = self.tmdb_api_link % ('33343', self.tmdb_key)
        self.meninblack_link = self.tmdb_api_link % ('33344', self.tmdb_key)
        self.mightyducks_link = self.tmdb_api_link % ('33345', self.tmdb_key)
        self.misscongeniality_link = self.tmdb_api_link % ('33346', self.tmdb_key)
        self.missinginaction_link = self.tmdb_api_link % ('33347', self.tmdb_key)
        self.missionimpossible_link = self.tmdb_api_link % ('33348', self.tmdb_key)
        self.themummy_link = 'https://www.imdb.com/search/title?title=mummy&title_type=feature&release_date=1999-01-01,&num_votes=1000,&countries=us&languages=en&sort=release_date,desc'
        self.nakedgun_link = self.tmdb_api_link % ('33349', self.tmdb_key)
        self.nationallampoon_link = self.tmdb_api_link % ('33350', self.tmdb_key)
        self.nationallampoonsvacation_link = self.tmdb_api_link % ('33351', self.tmdb_key)
        self.nationaltreasure_link = self.tmdb_api_link % ('33352', self.tmdb_key)
        self.neighbors_link = self.tmdb_api_link % ('33353', self.tmdb_key)
        self.nightatthemuseum_link = self.tmdb_api_link % ('33354', self.tmdb_key)
        self.nightmareonelmstreet_link = self.tmdb_api_link % ('33355', self.tmdb_key)
        self.nowyouseeme_link = self.tmdb_api_link % ('33356', self.tmdb_key)
        self.nuttyprofessor_link = self.tmdb_api_link % ('33357', self.tmdb_key)
        self.oceanseleven_link = self.tmdb_api_link % ('33358', self.tmdb_key)
        self.oddcouple_link = self.tmdb_api_link % ('33359', self.tmdb_key)
        self.ohgod_link = self.tmdb_api_link % ('33360', self.tmdb_key)
        self.olympushasfallen_link = self.tmdb_api_link % ('33361', self.tmdb_key)
        self.omen_link = self.tmdb_api_link % ('33362', self.tmdb_key)
        self.paulblart_link = self.tmdb_api_link % ('33363', self.tmdb_key)
        self.piratesofthecaribbean_link = self.tmdb_api_link % ('33364', self.tmdb_key)
        self.planetoftheapes_link = self.tmdb_api_link % ('33365', self.tmdb_key)
        self.policeacademy_link = self.tmdb_api_link % ('33366', self.tmdb_key)
        self.poltergeist_link = self.tmdb_api_link % ('33367', self.tmdb_key)
        self.porkys_link = self.tmdb_api_link % ('33368', self.tmdb_key)
        self.predator_link = self.tmdb_api_link % ('33369', self.tmdb_key)
        self.thepurge_link = self.tmdb_api_link % ('33370', self.tmdb_key)
        self.rambo_link = self.tmdb_api_link % ('33371', self.tmdb_key)
        self.red_link = self.tmdb_api_link % ('33372', self.tmdb_key)
        self.revengeofthenerds_link = self.tmdb_api_link % ('33373', self.tmdb_key)
        self.riddick_link = self.tmdb_api_link % ('33374', self.tmdb_key)
        self.ridealong_link = self.tmdb_api_link % ('33375', self.tmdb_key)
        self.thering_link = self.tmdb_api_link % ('33418', self.tmdb_key)
        self.robocop_link = self.tmdb_api_link % ('33376?', self.tmdb_key)
        self.rocky_link = self.tmdb_api_link % ('33377', self.tmdb_key)
        self.romancingthestone_link = self.tmdb_api_link % ('33378', self.tmdb_key)
        self.rushhour_link = self.tmdb_api_link % ('33379', self.tmdb_key)
        self.santaclause_link = self.tmdb_api_link % ('33380', self.tmdb_key)
        self.saw_link = self.tmdb_api_link % ('33381', self.tmdb_key)
        self.sexandthecity_link = self.tmdb_api_link % ('33382', self.tmdb_key)
        self.shaft_link = self.tmdb_api_link % ('33383', self.tmdb_key)
        self.shanghainoon_link = self.tmdb_api_link % ('33384', self.tmdb_key)
        self.sincity_link = self.tmdb_api_link % ('33385', self.tmdb_key)
        self.sinister_link = self.tmdb_api_link % ('33386', self.tmdb_key)
        self.sisteract_link = self.tmdb_api_link % ('33387', self.tmdb_key)
        self.smokeyandthebandit_link = self.tmdb_api_link % ('33388', self.tmdb_key)
        self.speed_link = self.tmdb_api_link % ('33389', self.tmdb_key)
        self.stakeout_link = self.tmdb_api_link % ('33390', self.tmdb_key)
        self.startrek_link = self.tmdb_api_link % ('33391', self.tmdb_key)
        self.starwars_link = self.tmdb_api_link % ('33237', self.tmdb_key)
        self.thesting_link = self.tmdb_api_link % ('33392', self.tmdb_key)
        self.taken_link = self.tmdb_api_link % ('33393', self.tmdb_key)
        self.taxi_link = self.tmdb_api_link % ('33394', self.tmdb_key)
        self.ted_link = self.tmdb_api_link % ('33395', self.tmdb_key)
        self.teenwolf_link = self.tmdb_api_link % ('33396', self.tmdb_key)
        self.terminator_link = self.tmdb_api_link % ('33397', self.tmdb_key)
        self.termsofendearment_link = self.tmdb_api_link % ('33398', self.tmdb_key)
        self.texaschainsawmassacre_link = self.tmdb_api_link % ('33399', self.tmdb_key)
        self.thething_link = self.tmdb_api_link % ('33400', self.tmdb_key)
        self.thomascrownaffair_link = self.tmdb_api_link % ('33401', self.tmdb_key)
        self.transformers_link = 'https://www.imdb.com/search/title?title=transformers&title_type=feature&num_votes=1000,&countries=us&languages=en&sort=release_date,desc'
        self.transporter_link = self.tmdb_api_link % ('33402', self.tmdb_key)
        self.tron_link = 'https://www.imdb.com/search/title?title=tron&title_type=feature&num_votes=1000,&countries=us&languages=en&sort=release_date,desc'
        self.twilight_link = 'https://www.imdb.com/search/title?title=twilight&title_type=feature&num_votes=1000,&countries=us&languages=en&plot=vampire&sort=release_date,desc'
        self.undersiege_link = self.tmdb_api_link % ('33403', self.tmdb_key)
        self.underworld_link = 'https://www.imdb.com/search/title?title=Underworld&title_type=feature&num_votes=1000,&genres=action&countries=us&languages=en&sort=release_date,desc'
        self.universalsoldier_link = self.tmdb_api_link % ('33404', self.tmdb_key)
        self.wallstreet_link = self.tmdb_api_link % ('33405', self.tmdb_key)
        self.waynesworld_link = self.tmdb_api_link % ('33406', self.tmdb_key)
        self.weekendatbernies_link = self.tmdb_api_link % ('33407', self.tmdb_key)
        self.wholenineyards_link = self.tmdb_api_link % ('33408?', self.tmdb_key)
        self.xfiles_link = self.tmdb_api_link % ('33409', self.tmdb_key)
        self.xxx_link = self.tmdb_api_link % ('33410', self.tmdb_key)
        self.youngguns_link = self.tmdb_api_link % ('33411', self.tmdb_key)
        self.zoolander_link = self.tmdb_api_link % ('33412', self.tmdb_key)
        self.zorro_link = self.tmdb_api_link % ('33413', self.tmdb_key)


# Boxset Collection Kids
        self.onehundredonedalmations_link = 'https://api.themoviedb.org/3/list/33182?api_key=%s' % (self.tmdb_key)
        self.addamsfamily_link = 'https://api.themoviedb.org/3/list/33183?api_key=%s' % (self.tmdb_key)
        self.aladdin_link = 'https://api.themoviedb.org/3/list/33184?api_key=%s' % (self.tmdb_key)
        self.alvinandthechipmunks_link = 'https://api.themoviedb.org/3/list/33185?api_key=%s' % (self.tmdb_key)
        self.atlantis_link = 'https://api.themoviedb.org/3/list/33186?api_key=%s' % (self.tmdb_key)
        self.babe_link = 'https://api.themoviedb.org/3/list/33187?api_key=%s' % (self.tmdb_key)
        self.balto_link = 'https://api.themoviedb.org/3/list/33188?api_key=%s' % (self.tmdb_key)
        self.bambi_link = 'https://api.themoviedb.org/3/list/33189?api_key=%s' % (self.tmdb_key)
        self.beautyandthebeast_link = 'https://api.themoviedb.org/3/list/33190?api_key=%s' % (self.tmdb_key)
        self.beethoven_link = 'https://api.themoviedb.org/3/list/33191?api_key=%s' % (self.tmdb_key)
        self.brotherbear_link = 'https://api.themoviedb.org/3/list/33192?api_key=%s' % (self.tmdb_key)
        self.cars_link = 'https://api.themoviedb.org/3/list/33193?api_key=%s' % (self.tmdb_key)
        self.cinderella_link = 'https://api.themoviedb.org/3/list/33194?api_key=%s' % (self.tmdb_key)
        self.cloudywithachanceofmeatballs_link = 'https://api.themoviedb.org/3/list/33195?api_key=%s' % (self.tmdb_key)
        self.despicableme_link = 'https://api.themoviedb.org/3/list/33197?api_key=%s' % (self.tmdb_key)
        self.findingnemo_link = 'https://api.themoviedb.org/3/list/33198?api_key=%s' % (self.tmdb_key)
        self.foxandthehound_link = 'https://api.themoviedb.org/3/list/33199?api_key=%s' % (self.tmdb_key)
        self.freewilly_link = 'https://api.themoviedb.org/3/list/33200?api_key=%s' % (self.tmdb_key)
        self.ghostbusters_link = 'https://api.themoviedb.org/3/list/33201?api_key=%s' % (self.tmdb_key)
        self.gremlins_link = 'https://api.themoviedb.org/3/list/33202?api_key=%s' % (self.tmdb_key)
        self.happyfeet_link = 'https://api.themoviedb.org/3/list/33204?api_key=%s' % (self.tmdb_key)
        self.harrypotter_link = 'https://api.themoviedb.org/3/list/33205?api_key=%s' % (self.tmdb_key)
        self.homealone_link = 'https://api.themoviedb.org/3/list/33206?api_key=%s' % (self.tmdb_key)
        self.homewardbound_link = 'https://api.themoviedb.org/3/list/33207?api_key=%s' % (self.tmdb_key)
        self.honeyishrunkthekids_link = 'https://api.themoviedb.org/3/list/33208?api_key=%s' % (self.tmdb_key)
        self.hoteltransylvania_link = 'https://api.themoviedb.org/3/list/33209?api_key=%s' % (self.tmdb_key)
        self.howtotrainyourdragon_link = 'https://api.themoviedb.org/3/list/33210?api_key=%s' % (self.tmdb_key)
        self.hunchbackofnotredame_link = 'https://api.themoviedb.org/3/list/33211?api_key=%s' % (self.tmdb_key)
        self.iceage_link = 'https://api.themoviedb.org/3/list/33212?api_key=%s' % (self.tmdb_key)
        self.jurassicpark_link = 'https://api.themoviedb.org/3/list/33217?api_key=%s' % (self.tmdb_key)
        self.kungfupanda_link = 'https://api.themoviedb.org/3/list/33218?api_key=%s' % (self.tmdb_key)
        self.ladyandthetramp_link = 'https://api.themoviedb.org/3/list/33219?api_key=%s' % (self.tmdb_key)
        self.liloandstitch_link = 'https://api.themoviedb.org/3/list/33220?api_key=%s' % (self.tmdb_key)
        self.madagascar_link = 'https://api.themoviedb.org/3/list/33221?api_key=%s' % (self.tmdb_key)
        self.monstersinc_link = 'https://api.themoviedb.org/3/list/33222?api_key=%s' % (self.tmdb_key)
        self.mulan_link = 'https://api.themoviedb.org/3/list/33223?api_key=%s' % (self.tmdb_key)
        self.narnia_link = 'https://api.themoviedb.org/3/list/33224?api_key=%s' % (self.tmdb_key)
        self.newgroove_link = 'https://api.themoviedb.org/3/list/33225?api_key=%s' % (self.tmdb_key)
        self.openseason_link = 'https://api.themoviedb.org/3/list/33226?api_key=%s' % (self.tmdb_key)
        self.planes_link = 'https://api.themoviedb.org/3/list/33227?api_key=%s' % (self.tmdb_key)
        self.pocahontas_link = 'https://api.themoviedb.org/3/list/33228?api_key=%s' % (self.tmdb_key)
        self.problemchild_link = 'https://api.themoviedb.org/3/list/33229?api_key=%s' % (self.tmdb_key)
        self.rio_link = 'https://api.themoviedb.org/3/list/33230?api_key=%s' % (self.tmdb_key)
        self.sammysadventures_link = 'https://api.themoviedb.org/3/list/33231?api_key=%s' % (self.tmdb_key)
        self.scoobydoo_link = 'https://api.themoviedb.org/3/list/33232?api_key=%s' % (self.tmdb_key)
        self.shortcircuit_link = 'https://api.themoviedb.org/3/list/33233?api_key=%s' % (self.tmdb_key)
        self.shrek_link = 'https://api.themoviedb.org/3/list/33234?api_key=%s' % (self.tmdb_key)
        self.spongebobsquarepants_link = 'https://api.themoviedb.org/3/list/33235?api_key=%s' % (self.tmdb_key)
        self.spykids_link = 'https://api.themoviedb.org/3/list/33236?api_key=%s' % (self.tmdb_key)
        self.starwars_link = 'https://api.themoviedb.org/3/list/33237?api_key=%s' % (self.tmdb_key)
        self.stuartlittle_link = 'https://api.themoviedb.org/3/list/33238?api_key=%s' % (self.tmdb_key)
        self.tarzan_link = 'https://api.themoviedb.org/3/list/33239?api_key=%s' % (self.tmdb_key)
        self.teenagemutantninjaturtles_link = 'https://api.themoviedb.org/3/list/33240?api_key=%s' % (self.tmdb_key)
        self.thejunglebook_link = 'https://api.themoviedb.org/3/list/33216?api_key=%s' % (self.tmdb_key)
        self.thekaratekid_link = 'https://api.themoviedb.org/3/list/33241?api_key=%s' % (self.tmdb_key)
        self.thelionking_link = 'https://api.themoviedb.org/3/list/33242?api_key=%s' % (self.tmdb_key)
        self.thelittlemermaid_link = 'https://api.themoviedb.org/3/list/33243?api_key=%s' % (self.tmdb_key)
        self.theneverendingstory_link = 'https://api.themoviedb.org/3/list/33248?api_key=%s' % (self.tmdb_key)
        self.thesmurfs_link = 'https://api.themoviedb.org/3/list/33249?api_key=%s' % (self.tmdb_key)
        self.toothfairy_link = 'https://api.themoviedb.org/3/list/33251?api_key=%s' % (self.tmdb_key)
        self.tinkerbell_link = 'https://api.themoviedb.org/3/list/33252?api_key=%s' % (self.tmdb_key)
        self.tomandjerry_link = 'https://api.themoviedb.org/3/list/33253?api_key=%s' % (self.tmdb_key)
        self.toystory_link = 'https://api.themoviedb.org/3/list/33254?api_key=%s' % (self.tmdb_key)
        self.veggietales_link = 'https://api.themoviedb.org/3/list/33255?api_key=%s' % (self.tmdb_key)
        self.winniethepooh_link = 'https://api.themoviedb.org/3/list/33257?api_key=%s' % (self.tmdb_key)
        self.wizardofoz_link = 'https://api.themoviedb.org/3/list/33258?api_key=%s' % (self.tmdb_key)

# Superhero Collection
        self.avengers_link = 'https://api.themoviedb.org/3/list/33128?api_key=%s' % (self.tmdb_key)
        self.batman_link = 'https://api.themoviedb.org/3/list/33129?api_key=%s' % (self.tmdb_key)
        self.captainamerica_link = 'https://api.themoviedb.org/3/list/33130?api_key=%s' % (self.tmdb_key)
        self.darkknight_link = 'https://api.themoviedb.org/3/list/33132?api_key=%s' % (self.tmdb_key)
        self.fantasticfour_link = 'https://api.themoviedb.org/3/list/33133?api_key=%s' % (self.tmdb_key)
        self.hulk_link = 'https://api.themoviedb.org/3/list/33134?api_key=%s' % (self.tmdb_key)
        self.ironman_link = 'https://api.themoviedb.org/3/list/33135?api_key=%s' % (self.tmdb_key)
        self.spiderman_link = 'https://api.themoviedb.org/3/list/33126?api_key=%s' % (self.tmdb_key)
        self.superman_link = 'https://api.themoviedb.org/3/list/33136?api_key=%s' % (self.tmdb_key)
        self.thor_link = 'https://www.imdb.com/search/title?title=thor&title_type=feature&num_votes=1000,&genres=action&countries=us&languages=en&sort=release_date,desc'
        self.xmen_link = 'https://api.themoviedb.org/3/list/33137?api_key=%s' % (self.tmdb_key)

# Actor Collection
        self.adamsandler_link = 'https://api.themoviedb.org/3/list/32777?api_key=%s' % (self.tmdb_key)
        self.alpacino_link = 'https://api.themoviedb.org/3/list/32815?api_key=%s' % (self.tmdb_key)
        self.alanrickman_link = 'https://api.themoviedb.org/3/list/32819?api_key=%s' % (self.tmdb_key)
        self.anthonyhopkins_link = 'https://api.themoviedb.org/3/list/32820?api_key=%s' % (self.tmdb_key)
        self.angelinajolie_link = 'https://api.themoviedb.org/3/list/32821?api_key=%s' % (self.tmdb_key)
        self.arnoldschwarzenegger_link = 'https://api.themoviedb.org/3/list/32825?api_key=%s' % (self.tmdb_key)
        self.charlizetheron_link = 'https://api.themoviedb.org/3/list/32826?api_key=%s' % (self.tmdb_key)
        self.clinteastwood_link = 'https://api.themoviedb.org/3/list/32827?api_key=%s' % (self.tmdb_key)
        self.demimoore_link = 'https://api.themoviedb.org/3/list/32828?api_key=%s' % (self.tmdb_key)
        self.denzelwashington_link = 'https://api.themoviedb.org/3/list/32829?api_key=%s' % (self.tmdb_key)
        self.eddiemurphy_link = 'https://api.themoviedb.org/3/list/32830?api_key=%s' % (self.tmdb_key)
        self.elvispresley_link = 'https://api.themoviedb.org/3/list/32831?api_key=%s' % (self.tmdb_key)
        self.genewilder_link = 'https://api.themoviedb.org/3/list/32999?api_key=%s' % (self.tmdb_key)
        self.gerardbutler_link = 'https://api.themoviedb.org/3/list/33000?api_key=%s' % (self.tmdb_key)
        self.goldiehawn_link = 'https://api.themoviedb.org/3/list/33023?api_key=%s' % (self.tmdb_key)
        self.jasonstatham_link = 'https://api.themoviedb.org/3/list/33001?api_key=%s' % (self.tmdb_key)
        self.jeanclaudevandamme_link = 'https://api.themoviedb.org/3/list/33002?api_key=%s' % (self.tmdb_key)
        self.jeffreydeanmorgan_link = 'https://api.themoviedb.org/3/list/33003?api_key=%s' % (self.tmdb_key)
        self.johntravolta_link = 'https://api.themoviedb.org/3/list/33004?api_key=%s' % (self.tmdb_key)
        self.johnnydepp_link = 'https://api.themoviedb.org/3/list/33005?api_key=%s' % (self.tmdb_key)
        self.juliaroberts_link = 'https://api.themoviedb.org/3/list/33006?api_key=%s' % (self.tmdb_key)
        self.kevincostner_link = 'https://api.themoviedb.org/3/list/33015?api_key=%s' % (self.tmdb_key)
        self.liamneeson_link = 'https://api.themoviedb.org/3/list/33016?api_key=%s' % (self.tmdb_key)
        self.melgibson_link = 'https://api.themoviedb.org/3/list/33017?api_key=%s' % (self.tmdb_key)
        self.melissamccarthy_link = 'https://api.themoviedb.org/3/list/33020?api_key=%s' % (self.tmdb_key)
        self.merylstreep_link = 'https://api.themoviedb.org/3/list/33021?api_key=%s' % (self.tmdb_key)
        self.michellepfeiffer_link = 'https://api.themoviedb.org/3/list/33022?api_key=%s' % (self.tmdb_key)
        self.nicolascage_link = 'https://api.themoviedb.org/3/list/33024?api_key=%s' % (self.tmdb_key)
        self.nicolekidman_link = 'https://api.themoviedb.org/3/list/33025?api_key=%s' % (self.tmdb_key)
        self.paulnewman_link = 'https://api.themoviedb.org/3/list/33026?api_key=%s' % (self.tmdb_key)
        self.reesewitherspoon_link = 'https://api.themoviedb.org/3/list/33027?api_key=%s' % (self.tmdb_key)
        self.robertdeniro_link = 'https://api.themoviedb.org/3/list/33028?api_key=%s' % (self.tmdb_key)
        self.samueljackson_link = 'https://api.themoviedb.org/3/list/33029?api_key=%s' % (self.tmdb_key)
        self.seanconnery_link = 'https://api.themoviedb.org/3/list/33030?api_key=%s' % (self.tmdb_key)
        self.scarlettjohansson_link = 'https://api.themoviedb.org/3/list/33031?api_key=%s' % (self.tmdb_key)
        self.sharonstone_link = 'https://api.themoviedb.org/3/list/33032?api_key=%s' % (self.tmdb_key)
        self.sigourneyweaver_link = 'https://api.themoviedb.org/3/list/33033?api_key=%s' % (self.tmdb_key)
        self.stevenseagal_link = 'https://api.themoviedb.org/3/list/33035?api_key=%s' % (self.tmdb_key)
        self.Sylvesterstallone_link = 'https://api.themoviedb.org/3/list/124428?api_key=%s' % (self.tmdb_key)
        self.tomhanks_link = 'https://api.themoviedb.org/3/list/33036?api_key=%s' % (self.tmdb_key)
        self.vindiesel_link = 'https://api.themoviedb.org/3/list/33037?api_key=%s' % (self.tmdb_key)
        self.wesleysnipes_link = 'https://api.themoviedb.org/3/list/33038?api_key=%s' % (self.tmdb_key)
        self.willsmith_link = 'https://api.themoviedb.org/3/list/33039?api_key=%s' % (self.tmdb_key)
        self.winonaryder_link = 'https://api.themoviedb.org/3/list/33040?api_key=%s' % (self.tmdb_key)

    def actorBoxset(self, lite = False):
        self.addDirectoryItem('Adam Sandler', 'collections&url=adamsandler', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Alpacino',     'collections&url=alpacino', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Alan Rickman', 'collections&url=alanrickman', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Anthony Hopkins', 'collections&url=anthonyhopkins', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Angelina Jolie', 'collections&url=angelinajolie', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Arnold Schwarzenegger', 'collections&url=arnoldschwarzenegger', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Charlize Theron', 'collections&url=charlizetheron', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Clint Eastwood', 'collections&url=clinteastwood', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Demi Moore', 'collections&url=demimoore', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Denzel Washington', 'collections&url=denzelwashington', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Eddie Murphy', 'collections&url=eddiemurphy', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Gene Wilder', 'collections&url=genewilder', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Gerard Butler', 'collections&url=gerardbutler', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Goldie Hawn', 'collections&url=goldiehawn', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Jason Statham', 'collections&url=jasonstatham', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Jean Claude Van Damme', 'collections&url=jeanclaudevandamme', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Jeffrey Dean Morgan', 'collections&url=jeffreydeanmorgan', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('John Travolta', 'collections&url=johntravolta', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Johnny Depp', 'collections&url=johnnydepp', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Julia Roberts', 'collections&url=juliaroberts', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Kevin Costner', 'collections&url=kevincostner', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Liam Neeson', 'collections&url=liamneeson', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Mel Gibson', 'collections&url=melgibson', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Melissa McCarthy', 'collections&url=melissamccarthy', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Meryl Streep', 'collections&url=merylstreep', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Michelle Pfeiffer', 'collections&url=michellepfeiffer', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Nicolas Cage', 'collections&url=nicolascage', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Nicole Kidman', 'collections&url=nicolekidman', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Paul Newman', 'collections&url=paulnewman', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Reese Witherspoon', 'collections&url=reesewitherspoon', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Robert De Niro', 'collections&url=robertdeniro', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Samuel L Jackson', 'collections&url=samueljackson', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Sean connery', 'collections&url=seanconnery', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Scarlett Johansson', 'collections&url=scarlettjohansson', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Sharon Stone', 'collections&url=sharonstone', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Sigourney Weaver', 'collections&url=sigourneyweaver', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Steven Seagal', 'collections&url=stevenseagal', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Sylvester stallone', 'collections&url=Sylvesterstallone', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Vin Diesel', 'collections&url=vindiesel', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Wesley Snipes', 'collections&url=wesleysnipes', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Will Smith', 'collections&url=willsmith', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem('Winona Ryder', 'collections&url=winonaryder', 'movies.png', 'DefaultRecentlyAddedMovies.png')
        self.endDirectory()




    def collectionsNavigator(self, lite = False):
        self.addDirectoryItem('IMDb Lists', 'movieimdbUserLists', 'imdb.png', 'DefaultMovies.png') 
        self.addDirectoryItem('Movies Collection', 'collectionBoxset', 'movies.png', 'movies.png')
        self.addDirectoryItem('Movies Selection', 'collections&url=moviemy', 'movies.png', 'movies.png')
        self.addDirectoryItem('ActorBoxset', 'actorNavigator', 'movies.png', 'movies.png')
        if self.getMenuEnabled('navi.xmascollections') == True:
            self.addDirectoryItem('Christmas Collections', 'collections&url=xmasmovies', 'movies.png', 'movies.png')
        self.addDirectoryItem('DC Comics', 'collections&url=dcmovies', 'movies.png', 'movies.png')
        self.addDirectoryItem('Marvel Comics', 'collections&url=marvelmovies', 'movies.png', 'movies.png')
        self.addDirectoryItem('Superheroes', 'collectionSuperhero', 'movies.png', 'movies.png')
        self.addDirectoryItem('Kids Collections', 'collectionKids', 'movies.png', 'movies.png')
        self.endDirectory()


    def collectionBoxset(self):
        self.addDirectoryItem('300 (2007-2014)', 'collections&url=tmdb300', 'movies.png', 'movies.png')
        self.addDirectoryItem('48 Hrs. (1982-1990)', 'collections&url=fortyeighthours', 'movies.png', 'movies.png')
        self.addDirectoryItem('Ace Ventura (1994-1995)', 'collections&url=aceventura', 'movies.png', 'movies.png')
        self.addDirectoryItem('Airplane (1980-1982)', 'collections&url=airplane', 'movies.png', 'movies.png')
        self.addDirectoryItem('Airport (1970-1979)', 'collections&url=airport', 'movies.png', 'movies.png')
        self.addDirectoryItem('American Graffiti (1973-1979)', 'collections&url=americangraffiti', 'movies.png', 'movies.png')
        self.addDirectoryItem('Anaconda (1997-2004)', 'collections&url=anaconda', 'movies.png', 'movies.png')
        self.addDirectoryItem('Analyze This (1999-2002)', 'collections&url=analyzethis', 'movies.png', 'movies.png')
        self.addDirectoryItem('Anchorman (2004-2013)', 'collections&url=anchorman', 'movies.png', 'movies.png')
        self.addDirectoryItem('Austin Powers (1997-2002)', 'collections&url=austinpowers', 'movies.png', 'movies.png')
        self.addDirectoryItem('Back to the Future (1985-1990)', 'collections&url=backtothefuture', 'movies.png', 'movies.png')
        self.addDirectoryItem('Bad Boys (1995-2003)', 'collections&url=badboys', 'movies.png', 'movies.png')
        self.addDirectoryItem('Bad Santa (2003-2016)', 'collections&url=badsanta', 'movies.png', 'movies.png')
        self.addDirectoryItem('Basic Instinct (1992-2006)', 'collections&url=basicinstinct', 'movies.png', 'movies.png')
        self.addDirectoryItem('Beverly Hills Cop (1984-1994)', 'collections&url=beverlyhillscop', 'movies.png', 'movies.png')
        self.addDirectoryItem('Big Mommas House (2000-2011)', 'collections&url=bigmommashouse', 'movies.png', 'movies.png')
        self.addDirectoryItem('Blues Brothers (1980-1998)', 'collections&url=bluesbrothers', 'movies.png', 'movies.png')
        self.addDirectoryItem('Bourne (2002-2016)', 'collections&url=bourne', 'movies.png', 'movies.png')
        self.addDirectoryItem('Bruce Almighty (2003-2007)', 'collections&url=brucealmighty', 'movies.png', 'movies.png')
        self.addDirectoryItem('Caddyshack (1980-1988)', 'collections&url=caddyshack', 'movies.png', 'movies.png')
        self.addDirectoryItem('Cheaper by the Dozen (2003-2005)', 'collections&url=cheaperbythedozen', 'movies.png', 'movies.png')
        self.addDirectoryItem('Cheech and Chong (1978-1984)', 'collections&url=cheechandchong', 'movies.png', 'movies.png')
        self.addDirectoryItem('Childs Play (1988-2004)', 'collections&url=childsplay', 'movies.png', 'movies.png')
        self.addDirectoryItem('City Slickers (1991-1994)', 'collections&url=cityslickers', 'movies.png', 'movies.png')
        self.addDirectoryItem('Conan (1982-2011)', 'collections&url=conan', 'movies.png', 'movies.png')
        self.addDirectoryItem('Crank (2006-2009)', 'collections&url=crank', 'movies.png', 'movies.png')
        self.addDirectoryItem('Crocodile Dundee (1986-2001)', 'collections&url=crocodiledundee', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Crow (1994-2005)', 'collections&url=thecrow', 'movies.png', 'movies.png')
        self.addDirectoryItem('Da Vinci Code (2006-2017)', 'collections&url=davincicode', 'movies.png', 'movies.png')
        self.addDirectoryItem('Daddy Day Care (2003-2007)', 'collections&url=daddydaycare', 'movies.png', 'movies.png')
        self.addDirectoryItem('Death Wish (1974-1994)', 'collections&url=deathwish', 'movies.png', 'movies.png')
        self.addDirectoryItem('Delta Force (1986-1990)', 'collections&url=deltaforce', 'movies.png', 'movies.png')
        self.addDirectoryItem('Die Hard (1988-2013)', 'collections&url=diehard', 'movies.png', 'movies.png')
        self.addDirectoryItem('Dirty Dancing (1987-2004)', 'collections&url=dirtydancing', 'movies.png', 'movies.png')
        self.addDirectoryItem('Dirty Harry (1971-1988)', 'collections&url=dirtyharry', 'movies.png', 'movies.png')
        self.addDirectoryItem('Dumb and Dumber (1994-2014)', 'collections&url=dumbanddumber', 'movies.png', 'movies.png')
        self.addDirectoryItem('Escape from New York (1981-1996)', 'collections&url=escapefromnewyork', 'movies.png', 'movies.png')
        self.addDirectoryItem('Every Which Way But Loose (1978-1980)', 'collections&url=everywhichwaybutloose', 'movies.png', 'movies.png')
        self.addDirectoryItem('Exorcist (1973-2005)', 'collections&url=exorcist', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Expendables (2010-2014)', 'collections&url=theexpendables', 'movies.png', 'movies.png')
        self.addDirectoryItem('Fast and the Furious (2001-2017)', 'collections&url=fastandthefurious', 'movies.png', 'movies.png')
        self.addDirectoryItem('Father of the Bride (1991-1995)', 'collections&url=fatherofthebride', 'movies.png', 'movies.png')
        self.addDirectoryItem('Fletch (1985-1989)', 'collections&url=fletch', 'movies.png', 'movies.png')
        self.addDirectoryItem('Friday (1995-2002)', 'collections&url=friday', 'movies.png', 'movies.png')
        self.addDirectoryItem('Friday the 13th (1980-2009)', 'collections&url=fridaythe13th', 'movies.png', 'movies.png')
        self.addDirectoryItem('Fugitive (1993-1998)', 'collections&url=fugitive', 'movies.png', 'movies.png')
        self.addDirectoryItem('G.I. Joe (2009-2013)', 'collections&url=gijoe', 'movies.png', 'movies.png')
        self.addDirectoryItem('Get Shorty (1995-2005)', 'collections&url=getshorty', 'movies.png', 'movies.png')
        self.addDirectoryItem('Gettysburg (1993-2003)', 'collections&url=gettysburg', 'movies.png', 'movies.png')
        self.addDirectoryItem('Ghost Rider (2007-2011)', 'collections&url=ghostrider', 'movies.png', 'movies.png')
        self.addDirectoryItem('Ghostbusters (1984-2016)', 'collections&url=ghostbusters', 'movies.png', 'movies.png')
        self.addDirectoryItem('Gods Not Dead (2014-2016)', 'collections&url=godsnotdead', 'movies.png', 'movies.png')
        self.addDirectoryItem('Godfather (1972-1990)', 'collections&url=godfather', 'movies.png', 'movies.png')
        self.addDirectoryItem('Godzilla (1956-2016)', 'collections&url=godzilla', 'movies.png', 'movies.png')
        self.addDirectoryItem('Grown Ups (2010-2013)', 'collections&url=grownups', 'movies.png', 'movies.png')
        self.addDirectoryItem('Grumpy Old Men (2010-2013)', 'collections&url=grumpyoldmen', 'movies.png', 'movies.png')
        self.addDirectoryItem('Guns of Navarone (1961-1978)', 'collections&url=gunsofnavarone', 'movies.png', 'movies.png')
        self.addDirectoryItem('Halloween (1978-2009)', 'collections&url=halloween', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hangover (2009-2013)', 'collections&url=hangover', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hannibal Lector (1986-2007)', 'collections&url=hanniballector', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hellraiser (1987-1996)', 'collections&url=hellraiser', 'movies.png', 'movies.png')
        self.addDirectoryItem('Highlander', 'collections&url=highlander', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Hobbit (1977-2014)', 'collections&url=thehobbit', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hollow Man (2000-2006)', 'collections&url=hollowman', 'movies.png', 'movies.png')
        self.addDirectoryItem('Honey I Shrunk the Kids (1989-1995)', 'collections&url=honeyishrunkthekids', 'movies.png', 'movies.png')
        self.addDirectoryItem('Horrible Bosses (2011-2014)', 'collections&url=horriblebosses', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hostel (2005-2011)', 'collections&url=hostel', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hot Shots (1991-1996)', 'collections&url=hotshots', 'movies.png', 'movies.png')
        self.addDirectoryItem('Hunger Games (2012-2015)', 'collections&url=hungergames', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Huntsman (2012-2016)', 'collections&url=huntsman', 'movies.png', 'movies.png')
        self.addDirectoryItem('Independence Day (1996-2016)', 'collections&url=independenceday', 'movies.png', 'movies.png')
        self.addDirectoryItem('Indiana Jones (1981-2008)', 'collections&url=indianajones', 'movies.png', 'movies.png')
        self.addDirectoryItem('Insidious (2010-2015)', 'collections&url=insidious', 'movies.png', 'movies.png')
        self.addDirectoryItem('Iron Eagle (1986-1992)', 'collections&url=ironeagle', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jack Reacher (2012-2016)', 'collections&url=jackreacher', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jack Ryan (1990-2014)', 'collections&url=jackryan', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jackass (2002-2013)', 'collections&url=jackass', 'movies.png', 'movies.png')
        self.addDirectoryItem('James Bond (1963-2015)', 'collections&url=jamesbond', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jaws (1975-1987)', 'collections&url=jaws', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jeepers Creepers (2001-2017)', 'collections&url=jeeperscreepers', 'movies.png', 'movies.png')
        self.addDirectoryItem('John Wick (2014-2017)', 'collections&url=johnwick', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jumanji (1995-2005)', 'collections&url=jumanji', 'movies.png', 'movies.png')
        self.addDirectoryItem('Jurassic Park (1993-2015)', 'collections&url=jurassicpark', 'movies.png', 'movies.png')
        self.addDirectoryItem('Kick-Ass (2010-2013)', 'collections&url=kickass', 'movies.png', 'movies.png')
        self.addDirectoryItem('Kill Bill (2003-2004)', 'collections&url=killbill', 'movies.png', 'movies.png')
        self.addDirectoryItem('King Kong (1933-2016)', 'collections&url=kingkong', 'movies.png', 'movies.png')
        self.addDirectoryItem('Lara Croft (2001-2003)', 'collections&url=laracroft', 'movies.png', 'movies.png')
        self.addDirectoryItem('Legally Blonde (2001-2003)', 'collections&url=legallyblonde', 'movies.png', 'movies.png')
        self.addDirectoryItem('Lethal Weapon (1987-1998)', 'collections&url=lethalweapon', 'movies.png', 'movies.png')
        self.addDirectoryItem('Look Whos Talking (1989-1993)', 'collections&url=lookwhostalking', 'movies.png', 'movies.png')
        self.addDirectoryItem('Lord of The Rings (1978-2003)', 'collections&url=lordoftherings', 'movies.png', 'movies.png')
        self.addDirectoryItem('Machete (2010-2013)', 'collections&url=machete', 'movies.png', 'movies.png')
        self.addDirectoryItem('Magic Mike (2012-2015)', 'collections&url=magicmike', 'movies.png', 'movies.png')
        self.addDirectoryItem('Major League (1989-1998)', 'collections&url=majorleague', 'movies.png', 'movies.png')
        self.addDirectoryItem('Man from Snowy River (1982-1988)', 'collections&url=manfromsnowyriver', 'movies.png', 'movies.png')
        self.addDirectoryItem('Mask (1994-2005)', 'collections&url=mask', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Matrix (1999-2003)', 'collections&url=matrix', 'movies.png', 'movies.png')
        self.addDirectoryItem('Maze Runner(2014-2018)', 'collections&url=mazerunner', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Mechanic (2011-2016)', 'collections&url=themechanic', 'movies.png', 'movies.png')
        self.addDirectoryItem('Meet the Parents (2000-2010)', 'collections&url=meettheparents', 'movies.png', 'movies.png')
        self.addDirectoryItem('Men in Black (1997-2012)', 'collections&url=meninblack', 'movies.png', 'movies.png')
        self.addDirectoryItem('Mighty Ducks (1995-1996)', 'collections&url=mightyducks', 'movies.png', 'movies.png')
        self.addDirectoryItem('Miss Congeniality (2000-2005)', 'collections&url=misscongeniality', 'movies.png', 'movies.png')
        self.addDirectoryItem('Missing in Action (1984-1988)', 'collections&url=missinginaction', 'movies.png', 'movies.png')
        self.addDirectoryItem('Mission Impossible (1996-2015)', 'collections&url=missionimpossible', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Mummy (1999-2017)', 'collections&url=themummy', 'movies.png', 'movies.png')
        self.addDirectoryItem('Naked Gun (1988-1994)', 'collections&url=nakedgun', 'movies.png', 'movies.png')
        self.addDirectoryItem('National Lampoon (1978-2006)', 'collections&url=nationallampoon', 'movies.png', 'movies.png')
        self.addDirectoryItem('National Lampoons Vacation (1983-2015)', 'collections&url=nationallampoonsvacation', 'movies.png', 'movies.png')
        self.addDirectoryItem('National Treasure (2004-2007)', 'collections&url=nationaltreasure', 'movies.png', 'movies.png')
        self.addDirectoryItem('Neighbors (2014-2016)', 'collections&url=neighbors', 'movies.png', 'movies.png')
        self.addDirectoryItem('Night at the Museum (2006-2014)', 'collections&url=nightatthemuseum', 'movies.png', 'movies.png')
        self.addDirectoryItem('Nightmare on Elm Street (1984-2010)', 'collections&url=nightmareonelmstreet', 'movies.png', 'movies.png')
        self.addDirectoryItem('Now You See Me (2013-2016)', 'collections&url=nowyouseeme', 'movies.png', 'movies.png')
        self.addDirectoryItem('Nutty Professor (1996-2000)', 'collections&url=nuttyprofessor', 'movies.png', 'movies.png')
        self.addDirectoryItem('Oceans Eleven (2001-2007)', 'collections&url=oceanseleven', 'movies.png', 'movies.png')
        self.addDirectoryItem('Odd Couple (1968-1998)', 'collections&url=oddcouple', 'movies.png', 'movies.png')
        self.addDirectoryItem('Oh, God (1977-1984)', 'collections&url=ohgod', 'movies.png', 'movies.png')
        self.addDirectoryItem('Olympus Has Fallen (2013-2016)', 'collections&url=olympushasfallen', 'movies.png', 'movies.png')
        self.addDirectoryItem('Omen (1976-1981)', 'collections&url=omen', 'movies.png', 'movies.png')
        self.addDirectoryItem('Paul Blart Mall Cop (2009-2015)', 'collections&url=paulblart', 'movies.png', 'movies.png')
        self.addDirectoryItem('Pirates of the Caribbean (2003-2017)', 'collections&url=piratesofthecaribbean', 'movies.png', 'movies.png')
        self.addDirectoryItem('Planet of the Apes (1968-2014)', 'collections&url=planetoftheapes', 'movies.png', 'movies.png')
        self.addDirectoryItem('Police Academy (1984-1994)', 'collections&url=policeacademy', 'movies.png', 'movies.png')
        self.addDirectoryItem('Poltergeist (1982-1988)', 'collections&url=poltergeist', 'movies.png', 'movies.png')
        self.addDirectoryItem('Porkys (1981-1985)', 'collections&url=porkys', 'movies.png', 'movies.png')
        self.addDirectoryItem('Predator (1987-2010)', 'collections&url=predator', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Purge (2013-2016)', 'collections&url=thepurge', 'movies.png', 'movies.png')
        self.addDirectoryItem('Rambo (1982-2008)', 'collections&url=rambo', 'movies.png', 'movies.png')
        self.addDirectoryItem('RED (2010-2013)', 'collections&url=red', 'movies.png', 'movies.png')
        self.addDirectoryItem('Revenge of the Nerds (1984-1987)', 'collections&url=revengeofthenerds', 'movies.png', 'movies.png')
        self.addDirectoryItem('Riddick (2000-2013)', 'collections&url=riddick', 'movies.png', 'movies.png')
        self.addDirectoryItem('Ride Along (2014-2016)', 'collections&url=ridealong', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Ring (2002-2017)', 'collections&url=thering', 'movies.png', 'movies.png')
        self.addDirectoryItem('RoboCop (1987-1993)', 'collections&url=robocop', 'movies.png', 'movies.png')
        self.addDirectoryItem('Rocky (1976-2015)', 'collections&url=rocky', 'movies.png', 'movies.png')
        self.addDirectoryItem('Romancing the Stone (1984-1985)', 'collections&url=romancingthestone', 'movies.png', 'movies.png')
        self.addDirectoryItem('Rush Hour (1998-2007)', 'collections&url=rushhour', 'movies.png', 'movies.png')
        self.addDirectoryItem('Santa Clause (1994-2006)', 'collections&url=santaclause', 'movies.png', 'movies.png')
        self.addDirectoryItem('Saw (2004-2010)', 'collections&url=saw', 'movies.png', 'movies.png')
        self.addDirectoryItem('Sex and the City (2008-2010)', 'collections&url=sexandthecity', 'movies.png', 'movies.png')
        self.addDirectoryItem('Shaft (1971-2000)', 'collections&url=shaft', 'movies.png', 'movies.png')
        self.addDirectoryItem('Shanghai Noon (2000-2003)', 'collections&url=shanghainoon', 'movies.png', 'movies.png')
        self.addDirectoryItem('Sin City (2005-2014)', 'collections&url=sincity', 'movies.png', 'movies.png')
        self.addDirectoryItem('Sinister (2012-2015)', 'collections&url=sinister', 'movies.png', 'movies.png')
        self.addDirectoryItem('Sister Act (1995-1993)', 'collections&url=sisteract', 'movies.png', 'movies.png')
        self.addDirectoryItem('Smokey and the Bandit (1977-1986)', 'collections&url=smokeyandthebandit', 'movies.png', 'movies.png')
        self.addDirectoryItem('Speed (1994-1997)', 'collections&url=speed', 'movies.png', 'movies.png')
        self.addDirectoryItem('Stakeout (1987-1993)', 'collections&url=stakeout', 'movies.png', 'movies.png')
        self.addDirectoryItem('Star Trek (1979-2016)', 'collections&url=startrek', 'movies.png', 'movies.png')
        self.addDirectoryItem('Star Wars (1977-2015)', 'collections&url=starwars', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Sting (1973-1983)', 'collections&url=thesting', 'movies.png', 'movies.png')
        self.addDirectoryItem('Taken (2008-2014)', 'collections&url=taken', 'movies.png', 'movies.png')
        self.addDirectoryItem('Taxi (1998-2007)', 'collections&url=taxi', 'movies.png', 'movies.png')
        self.addDirectoryItem('Ted (2012-2015)', 'collections&url=ted', 'movies.png', 'movies.png')
        self.addDirectoryItem('Teen Wolf (1985-1987)', 'collections&url=teenwolf', 'movies.png', 'movies.png')
        self.addDirectoryItem('Terminator (1984-2015)', 'collections&url=terminator', 'movies.png', 'movies.png')
        self.addDirectoryItem('Terms of Endearment (1983-1996)', 'collections&url=termsofendearment', 'movies.png', 'movies.png')
        self.addDirectoryItem('Texas Chainsaw Massacre (1974-2013)', 'collections&url=texaschainsawmassacre', 'movies.png', 'movies.png')
        self.addDirectoryItem('The Thing (1982-2011)', 'collections&url=thething', 'movies.png', 'movies.png')
        self.addDirectoryItem('Thomas Crown Affair (1968-1999)', 'collections&url=thomascrownaffair', 'movies.png', 'movies.png')
        self.addDirectoryItem('Transformers (2002-2015)', 'collections&url=transformers', 'movies.png', 'movies.png')
        self.addDirectoryItem('Transporter (2002-2015)', 'collections&url=transporter', 'movies.png', 'movies.png')
        self.addDirectoryItem('Tron (1982-2010)', 'collections&url=tron', 'movies.png', 'movies.png')
        self.addDirectoryItem('Twilight (2008-2012)', 'collections&url=twilight', 'movies.png', 'movies.png')
        self.addDirectoryItem('Under Siege (1992-1995)', 'collections&url=undersiege', 'movies.png', 'movies.png')
        self.addDirectoryItem('Underworld (2003-2016)', 'collections&url=underworld', 'movies.png', 'movies.png')
        self.addDirectoryItem('Universal Soldier (1992-2012)', 'collections&url=universalsoldier', 'movies.png', 'movies.png')
        self.addDirectoryItem('Wall Street (1987-2010)', 'collections&url=wallstreet', 'movies.png', 'movies.png')
        self.addDirectoryItem('Waynes World (1992-1993)', 'collections&url=waynesworld', 'movies.png', 'movies.png')
        self.addDirectoryItem('Weekend at Bernies (1989-1993)', 'collections&url=weekendatbernies', 'movies.png', 'movies.png')
        self.addDirectoryItem('Whole Nine Yards (2000-2004)', 'collections&url=wholenineyards', 'movies.png', 'movies.png')
        self.addDirectoryItem('X-Files (1998-2008)', 'collections&url=xfiles', 'movies.png', 'movies.png')
        self.addDirectoryItem('xXx (2002-2005)', 'collections&url=xxx', 'movies.png', 'movies.png')
        self.addDirectoryItem('Young Guns (1988-1990)', 'collections&url=youngguns', 'movies.png', 'movies.png')
        self.addDirectoryItem('Zoolander (2001-2016)', 'collections&url=zoolander', 'movies.png', 'movies.png')
        self.addDirectoryItem('Zorro (1998-2005)', 'collections&url=zorro', 'movies.png', 'movies.png')
        self.endDirectory()


    def collectionKids(self):
        self.addDirectoryItem('Disney Collection', 'collections&url=disneymovies', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Kids Boxset Collection', 'collectionBoxsetKids', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Kids Movie Collection', 'collections&url=kidsmovies', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Kids Movie Collection2', 'collections&url=kidsmovies2', 'collectionkids.png', 'collectionkids.png')
        self.endDirectory()


    def collectionBoxsetKids(self):
        self.addDirectoryItem('101 Dalmations (1961-2003)', 'collections&url=onehundredonedalmations', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Addams Family (1991-1998)', 'collections&url=addamsfamily', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Aladdin (1992-1996)', 'collections&url=aladdin', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Alvin and the Chipmunks (2007-2015)', 'collections&url=alvinandthechipmunks', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Atlantis (2001-2003)', 'collections&url=atlantis', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Babe (1995-1998)', 'collections&url=babe', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Balto (1995-1998)', 'collections&url=balto', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Bambi (1942-2006)', 'collections&url=bambi', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Beauty and the Beast (1991-2017)', 'collections&url=beautyandthebeast', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Beethoven (1992-2014)', 'collections&url=beethoven', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Brother Bear (2003-2006)', 'collections&url=brotherbear', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Cars (2006-2017)', 'collections&url=cars', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Cinderella (1950-2007)', 'collections&url=cinderella', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Cloudy With a Chance of Meatballs (2009-2013)', 'collections&url=cloudywithachanceofmeatballs', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Despicable Me (2010-2015)', 'collections&url=despicableme', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Finding Nemo (2003-2016)', 'collections&url=findingnemo', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Fox and the Hound (1981-2006)', 'collections&url=foxandthehound', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Free Willy (1993-2010)', 'collections&url=freewilly', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Ghostbusters (1984-2016)', 'collections&url=ghostbusters', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Gremlins (1984-2016)', 'collections&url=gremlins', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Happy Feet (2006-2011)', 'collections&url=happyfeet', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Harry Potter (2001-2011)', 'collections&url=harrypotter', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Home Alone (1990-2012)', 'collections&url=homealone', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Homeward Bound (1993-1996)', 'collections&url=homewardbound', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Honey, I Shrunk the Kids (1989-1997)', 'collections&url=honeyishrunkthekids', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Hotel Transylvania (2012-2015)', 'collections&url=hoteltransylvania', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('How to Train Your Dragon (2010-2014)', 'collections&url=howtotrainyourdragon', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Hunchback of Notre Dame (1996-2002)', 'collections&url=hunchbackofnotredame', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Ice Age (2002-2016)', 'collections&url=iceage', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Jurassic Park (1993-2015)', 'collections&url=jurassicpark', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Kung Fu Panda (2008-2016)', 'collections&url=kungfupanda', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Lady and the Tramp (1955-2001)', 'collections&url=ladyandthetramp', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Lilo and Stitch (2002-2006)', 'collections&url=liloandstitch', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Madagascar (2005-2014)', 'collections&url=madagascar', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Monsters Inc (2001-2013)', 'collections&url=monstersinc', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Mulan (1998-2004)', 'collections&url=mulan', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Narnia (2005-2010)', 'collections&url=narnia', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('New Groove (2000-2005)', 'collections&url=newgroove', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Open Season (2006-2015)', 'collections&url=openseason', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Planes (2013-2014)', 'collections&url=planes', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Pocahontas (1995-1998)', 'collections&url=pocahontas', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Problem Child (1990-1995)', 'collections&url=problemchild', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Rio (2011-2014)', 'collections&url=rio', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Sammys Adventures (2010-2012)', 'collections&url=sammysadventures', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Scooby-Doo (2002-2014)', 'collections&url=scoobydoo', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Short Circuit (1986-1988)', 'collections&url=shortcircuit', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Shrek (2001-2011)', 'collections&url=shrek', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('SpongeBob SquarePants (2004-2017)', 'collections&url=spongebobsquarepants', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Spy Kids (2001-2011)', 'collections&url=spykids', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Star Wars (1977-2015)', 'collections&url=starwars', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Stuart Little (1999-2002)', 'collections&url=stuartlittle', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Tarzan (1999-2016)', 'collections&url=tarzan', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Teenage Mutant Ninja Turtles (1978-2009)', 'collections&url=teenagemutantninjaturtles', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Jungle Book (1967-2003)', 'collections&url=thejunglebook', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Karate Kid (1984-2010)', 'collections&url=thekaratekid', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Lion King (1994-2016)', 'collections&url=thelionking', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Little Mermaid (1989-1995)', 'collections&url=thelittlemermaid', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Neverending Story (1984-1994)', 'collections&url=theneverendingstory', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('The Smurfs (2011-2013)', 'collections&url=thesmurfs', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Tooth Fairy (2010-2012)', 'collections&url=toothfairy', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Tinker Bell (2008-2014)', 'collections&url=tinkerbell', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Tom and Jerry (1992-2013)', 'collections&url=tomandjerry', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Toy Story (1995-2014)', 'collections&url=toystory', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('VeggieTales (2002-2008)', 'collections&url=veggietales', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Winnie the Pooh (2000-2005)', 'collections&url=winniethepooh', 'collectionkids.png', 'collectionkids.png')
        self.addDirectoryItem('Wizard of Oz (1939-2013)', 'collections&url=wizardofoz', 'collectionkids.png', 'collectionkids.png')
        self.endDirectory()


    def collectionSuperhero(self):
        self.addDirectoryItem('Avengers (2008-2017)', 'collections&url=avengers', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Batman (1989-2016)', 'collections&url=batman', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Captain America (2011-2016)', 'collections&url=captainamerica', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Dark Knight Trilogy (2005-2013)', 'collections&url=darkknight', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Fantastic Four (2005-2015)', 'collections&url=fantasticfour', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Hulk (2003-2008)', 'collections&url=hulk', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Iron Man (2008-2013)', 'collections&url=ironman', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Spider-Man (2002-2017)', 'collections&url=spiderman', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Thor (2011-2017)', 'collections&url=thor', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('Superman (1978-2016)', 'collections&url=superman', 'fitness.png', 'fitness.png')
        self.addDirectoryItem('X-Men (2000-2016)', 'collections&url=xmen', 'fitness.png', 'fitness.png')
        self.endDirectory()


    def getMenuEnabled(self, menu_title):
        is_enabled = control.setting(menu_title).strip()
        if (is_enabled == '' or is_enabled == 'false'): return False
        return True


    def get(self, url, idx = True):
        try:
            try: url = getattr(self, url + '_link')
            except: pass

            try: u = urlparse.urlparse(url).netloc.lower()
            except: pass

            if u in self.tmdb_link and ('/user/' in url or '/list/' in url):
                self.list = self.tmdb_collections_list(url)
                self.worker()

            elif u in self.tmdb_link and not ('/user/' in url or '/list/' in url):
                self.list = cache.get(self.tmdb_list, 24, url)
                self.worker()

            elif u in self.imdb_link and ('/user/' in url or '/list/' in url):
                self.list = cache.get(self.imdb_list, 0, url)
                if idx == True: self.worker()

            elif u in self.imdb_link:
                self.list = cache.get(self.imdb_list, 24, url)
                if idx == True: self.worker()

            if idx == True: self.movieDirectory(self.list)
            return self.list
        except:
            pass


    def imdb_list(self, url):
        list = []
        try:
            for i in re.findall('date\[(\d+)\]', url):
                url = url.replace('date[%s]' % i, (self.datetime - datetime.timedelta(days = int(i))).strftime('%Y-%m-%d'))

            def imdb_watchlist_id(url):
                return client.parseDOM(client.request(url).decode('iso-8859-1').encode('utf-8'), 'meta', ret='content', attrs = {'property': 'pageId'})[0]

            if url == self.imdbwatchlist_link:
                url = cache.get(imdb_watchlist_id, 8640, url)
                url = self.imdblist_link % url
            elif url == self.imdbwatchlist2_link:
                url = cache.get(imdb_watchlist_id, 8640, url)
                url = self.imdblist2_link % url

            result = client.request(url)
            result = result.replace('\n', ' ')
            result = result.decode('iso-8859-1').encode('utf-8')

            items = client.parseDOM(result, 'div', attrs = {'class': '.+? lister-item'}) + client.parseDOM(result, 'div', attrs = {'class': 'lister-item .+?'})
            items += client.parseDOM(result, 'div', attrs = {'class': 'list_item.+?'})
        except:
            return

        try:
            # HTML syntax error, " directly followed by attribute name. Insert space in between. parseDOM can otherwise not handle it.
            result = result.replace('"class="lister-page-next', '" class="lister-page-next')

            next = client.parseDOM(result, 'a', ret='href', attrs = {'class': 'lister-page-next.+?'})

            if len(next) == 0:
                next = client.parseDOM(result, 'div', attrs = {'class': 'pagination'})[0]
                next = zip(client.parseDOM(next, 'a', ret='href'), client.parseDOM(next, 'a'))
                next = [i[0] for i in next if 'Next' in i[1]]

            next = url.replace(urlparse.urlparse(url).query, urlparse.urlparse(next[0]).query)
            next = client.replaceHTMLCodes(next)
            next = next.encode('utf-8')
        except:
            next = ''

        for item in items:
            try:
                title = client.parseDOM(item, 'a')[1]
                title = client.replaceHTMLCodes(title)
                title = title.encode('utf-8')

                year = client.parseDOM(item, 'span', attrs = {'class': 'lister-item-year.+?'})
                year = re.findall('(\d{4})', year[0])[0]
                year = year.encode('utf-8')

                try: show = '–'.decode('utf-8') in str(year).decode('utf-8') or '-'.decode('utf-8') in str(year).decode('utf-8')
                except: show = False
                if show: raise Exception() # Some lists contain TV shows.

                if int(year) > int((self.datetime).strftime('%Y')): raise Exception()

                imdb = client.parseDOM(item, 'a', ret='href')[0]
                imdb = re.findall('(tt\d*)', imdb)[0]
                imdb = imdb.encode('utf-8')

                try: poster = client.parseDOM(item, 'img', ret='loadlate')[0]
                except: poster = '0'
                if '/nopicture/' in poster: poster = '0'
                poster = re.sub('(?:_SX|_SY|_UX|_UY|_CR|_AL)(?:\d+|_).+?\.', '_SX500.', poster)
                poster = client.replaceHTMLCodes(poster)
                poster = poster.encode('utf-8')

                try: genre = client.parseDOM(item, 'span', attrs = {'class': 'genre'})[0]
                except: genre = '0'
                genre = ' / '.join([i.strip() for i in genre.split(',')])
                if genre == '': genre = '0'
                genre = client.replaceHTMLCodes(genre)
                genre = genre.encode('utf-8')

                try: duration = re.findall('(\d+?) min(?:s|)', item)[-1]
                except: duration = '0'
                duration = duration.encode('utf-8')

                rating = '0'
                try: rating = client.parseDOM(item, 'span', attrs = {'class': 'rating-rating'})[0]
                except: pass
                try: rating = client.parseDOM(rating, 'span', attrs = {'class': 'value'})[0]
                except: rating = '0'
                try: rating = client.parseDOM(item, 'div', ret='data-value', attrs = {'class': '.*?imdb-rating'})[0]
                except: pass
                if rating == '' or rating == '-': rating = '0'
                rating = client.replaceHTMLCodes(rating)
                rating = rating.encode('utf-8')

                try: votes = client.parseDOM(item, 'div', ret='title', attrs = {'class': '.*?rating-list'})[0]
                except: votes = '0'
                try: votes = re.findall('\((.+?) vote(?:s|)\)', votes)[0]
                except: votes = '0'
                if votes == '': votes = '0'
                votes = client.replaceHTMLCodes(votes)
                votes = votes.encode('utf-8')

                try: mpaa = client.parseDOM(item, 'span', attrs = {'class': 'certificate'})[0]
                except: mpaa = '0'
                if mpaa == '' or mpaa == 'NOT_RATED': mpaa = '0'
                mpaa = mpaa.replace('_', '-')
                mpaa = client.replaceHTMLCodes(mpaa)
                mpaa = mpaa.encode('utf-8')

                try: director = re.findall('Director(?:s|):(.+?)(?:\||</div>)', item)[0]
                except: director = '0'
                director = client.parseDOM(director, 'a')
                director = ' / '.join(director)
                if director == '': director = '0'
                director = client.replaceHTMLCodes(director)
                director = director.encode('utf-8')

                try: cast = re.findall('Stars(?:s|):(.+?)(?:\||</div>)', item)[0]
                except: cast = '0'
                cast = client.replaceHTMLCodes(cast)
                cast = cast.encode('utf-8')
                cast = client.parseDOM(cast, 'a')
                if cast == []: cast = '0'

                plot = '0'
                try: plot = client.parseDOM(item, 'p', attrs = {'class': 'text-muted'})[0]
                except: pass
                try: plot = client.parseDOM(item, 'div', attrs = {'class': 'item_description'})[0]
                except: pass
                plot = plot.rsplit('<span>', 1)[0].strip()
                plot = re.sub('<.+?>|</.+?>', '', plot)
                if plot == '': plot = '0'
                plot = client.replaceHTMLCodes(plot)
                plot = plot.encode('utf-8')

                self.list.append({'title': title, 'originaltitle': title, 'year': year, 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'cast': cast, 'plot': plot, 'tagline': '0', 'imdb': imdb, 'tmdb': '0', 'tvdb': '0', 'poster': poster, 'next': next})
            except:
                pass

        return self.list


    def tmdb_list(self, url):
        next = url
        for i in re.findall('date\[(\d+)\]', url):
            url = url.replace('date[%s]' % i, (self.datetime - datetime.timedelta(days = int(i))).strftime('%Y-%m-%d'))
        try:
            result = client.request(url % self.tmdb_key)
            result = json.loads(result)
            items = result['results']
        except:
            return
        try:
            page = int(result['page'])
            total = int(result['total_pages'])
            if page >= total: raise Exception()
            url2 = '%s&page=%s' % (url.split('&page=', 1)[0], str(page+1))

            result = client.request(url2 % self.tmdb_key)
            result = json.loads(result)
            items += result['results']
        except:
            pass
        try:
            page = int(result['page'])
            total = int(result['total_pages'])
            if page >= total: raise Exception()
            if not 'page=' in url: raise Exception()

            next = '%s&page=%s' % (next.split('&page=', 1)[0], str(page+1))
            next = next.encode('utf-8')
        except:
            next = ''
        for item in items:
            try:
                title = item['title']
                title = client.replaceHTMLCodes(title)
                title = title.encode('utf-8')

                year = item['release_date']
                year = re.compile('(\d{4})').findall(year)[-1]
                year = year.encode('utf-8')

#                year = client.parseDOM(item, 'span', attrs = {'class': 'lister-item-year.+?'})
#                year = re.findall('(\d{4})', year[0])[0]
#                year = year.encode('utf-8')

                tmdb = item['id']
                tmdb = re.sub('[^0-9]', '', str(tmdb))
                tmdb = tmdb.encode('utf-8')

                poster = item['poster_path']
                if poster == '' or poster == None:
                    raise Exception()
                else:
                    poster = '%s%s' % (self.tmdb_poster, poster)
                poster = poster.encode('utf-8')

                fanart = item['backdrop_path']
                if fanart == '' or fanart == None: fanart = '0'
                if not fanart == '0': fanart = '%s%s' % (self.tmdb_image, fanart)
                fanart = fanart.encode('utf-8')

                premiered = item['release_date']
                try   : premiered = re.compile('(\d{4}-\d{2}-\d{2})').findall(premiered)[0]
                except: premiered = '0'
                premiered = premiered.encode('utf-8')

                rating = str(item['vote_average'])
                if rating == '' or rating == None: rating = '0'
                rating = rating.encode('utf-8')

                votes = str(item['vote_count'])
                try   : votes = str(format(int(votes),',d'))
                except: pass
                if votes == '' or votes == None: votes = '0'
                votes = votes.encode('utf-8')

                plot = item['overview']
                if plot == '' or plot == None: plot = '0'
                plot = client.replaceHTMLCodes(plot)
                plot = plot.encode('utf-8')

                tagline = re.compile('[.!?][\s]{1,2}(?=[A-Z])').split(plot)[0]
                try   : tagline = tagline.encode('utf-8')
                except: pass

                self.list.append({'title': title, 'originaltitle': title, 'year': year, 'premiered': premiered, 'studio': '0', 'genre': '0', 'duration': '0', 'rating': rating, 'votes': votes, 'mpaa': '0', 'director': '0', 'writer': '0', 'cast': '0', 'plot': plot, 'tagline': tagline, 'code': '0', 'imdb': '0', 'tmdb': tmdb, 'tvdb': '0', 'poster': poster, 'banner': '0', 'fanart': fanart, 'next': next})
            except:
                pass
        return self.list


    def tmdb_collections_list(self, url):
        try:
            result = client.request(url)
            result = json.loads(result)
            items = result['items']
        except:
            return
        next = ''
        for item in items:
            try:
                media_type = item['media_type']
                title = item['title']
                if not media_type == 'movie': title = item['name']
                title = client.replaceHTMLCodes(title)
                title = title.encode('utf-8')

                year = item['release_date']
                try: year = re.compile('(\d{4})').findall(year)[0]
                except: year = '0'
                if year == '' or year == None: year = '0'
                year = year.encode('utf-8')

                tmdb = item['id']
                tmdb = re.sub('[^0-9]', '', str(tmdb))
                tmdb = tmdb.encode('utf-8')

                poster = item['poster_path']
                if poster == '' or poster == None: raise Exception()
                else: poster = '%s%s' % (self.tmdb_poster, poster)
                poster = poster.encode('utf-8')

                fanart = item['backdrop_path']
                if fanart == '' or fanart == None: fanart = '0'
                if not fanart == '0': fanart = '%s%s' % (self.tmdb_image, fanart)
                fanart = fanart.encode('utf-8')

                premiered = item['release_date']
                try: premiered = re.compile('(\d{4}-\d{2}-\d{2})').findall(premiered)[0]
                except: premiered = '0'
                premiered = premiered.encode('utf-8')

                rating = str(item['vote_average'])
                if rating == '' or rating == None: rating = '0'
                rating = rating.encode('utf-8')

                votes = str(item['vote_count'])
                try: votes = str(format(int(votes),',d'))
                except: pass
                if votes == '' or votes == None: votes = '0'
                votes = votes.encode('utf-8')

                plot = item['overview']
                if plot == '' or plot == None: plot = '0'
                plot = client.replaceHTMLCodes(plot)
                plot = plot.encode('utf-8')

                tagline = re.compile('[.!?][\s]{1,2}(?=[A-Z])').split(plot)[0]
                try: tagline = tagline.encode('utf-8')
                except: pass

                self.list.append({'title': title, 'originaltitle': title, 'year': year, 'premiered': premiered, 'studio': '0', 'genre': '0', 'duration': '0', 'rating': rating, 'votes': votes, 'mpaa': '0', 'director': '0', 'writer': '0', 'cast': '0', 'plot': plot, 'tagline': tagline, 'code': '0', 'imdb': '0', 'tmdb': tmdb, 'tvdb': '0', 'poster': poster, 'banner': '0', 'fanart': fanart, 'next': next})
            except:
                pass
        return self.list


    def worker(self, level = 1):
        if self.list == None or self.list == []: return
        self.meta = []
        total = len(self.list)

        self.fanart_tv_headers = {'api-key': '9f846e7ec1ea94fad5d8a431d1d26b43'}
        if not self.fanart_tv_user == '': self.fanart_tv_headers.update({'client-key': self.fanart_tv_user})

        for i in range(0, total): self.list[i].update({'metacache': False})

        self.list = metacache.fetch(self.list, self.lang, self.user)

        imdb_t = self.list[i]['imdb']
        tmdb_t = self.list[i]['tmdb']

        for r in range(0, total, 40):
            threads = []
            for i in range(r, r+40):
                if i <= total and imdb_t != '0': threads.append(workers.Thread(self.super_imdb_info, i))
                if i <= total and tmdb_t != '0': threads.append(workers.Thread(self.super_tmdb_info, i))
            [i.start() for i in threads]
            [i.join() for i in threads]
            if self.meta: metacache.insert(self.meta)

        self.list = [i for i in self.list]
        self.list = metacache.local(self.list, self.tm_img_link, 'poster3', 'fanart2')

        if self.fanart_tv_user == '':
            for i in self.list: i.update({'clearlogo': '0', 'clearart': '0'})


    def super_imdb_info(self, i):
        try:
            if self.list[i]['metacache'] == True: raise Exception()

            imdb = self.list[i]['imdb']

            item = trakt.getMovieSummary(id = imdb)

            title = item.get('title')
            title = client.replaceHTMLCodes(title)

            originaltitle = title

            year = item.get('year', 0)
            year = re.sub('[^0-9]', '', str(year))

            imdb = item.get('ids', {}).get('imdb', '0')
            imdb = 'tt' + re.sub('[^0-9]', '', str(imdb))

            tmdb = str(item.get('ids', {}).get('tmdb', 0))

            premiered = item.get('released', '0')
            try: premiered = re.compile('(\d{4}-\d{2}-\d{2})').findall(premiered)[0]
            except: premiered = '0'

            genre = item.get('genres', [])
            genre = [x.title() for x in genre]
            genre = ' / '.join(genre).strip()
            if not genre: genre = '0'

            duration = str(item.get('runtime', 0))

            rating = item.get('rating', '0')
            if not rating or rating == '0.0': rating = '0'

            votes = item.get('votes', '0')
            try: votes = str(format(int(votes), ',d'))
            except: pass

            mpaa = item.get('certification', '0')
            if not mpaa: mpaa = '0'

            tagline = item.get('tagline', '0')

            plot = item.get('overview', '0')

            people = trakt.getPeople(imdb, 'movies')

            director = writer = ''
            if 'crew' in people and 'directing' in people['crew']:
                director = ', '.join([director['person']['name'] for director in people['crew']['directing'] if director['job'].lower() == 'director'])
            if 'crew' in people and 'writing' in people['crew']:
                writer = ', '.join([writer['person']['name'] for writer in people['crew']['writing'] if writer['job'].lower() in ['writer', 'screenplay', 'author']])

            cast = []
            for person in people.get('cast', []):
                cast.append({'name': person['person']['name'], 'role': person['character']})
            cast = [(person['name'], person['role']) for person in cast]

            try:
                if self.lang == 'en' or self.lang not in item.get('available_translations', [self.lang]): raise Exception()
                trans_item = trakt.getMovieTranslation(imdb, self.lang, full = True)

                title = trans_item.get('title') or title
                tagline = trans_item.get('tagline') or tagline
                plot = trans_item.get('overview') or plot
            except:
                pass

            try:
                artmeta = True
                art = client.request(self.fanart_tv_art_link % imdb, headers = self.fanart_tv_headers, timeout = '10', error = True)
                try: art = json.loads(art)
                except: artmeta = False
            except:
                pass

            try:
                poster2 = art['movieposter']
                poster2 = [x for x in poster2 if x.get('lang') == self.lang][::-1] + [x for x in poster2 if x.get('lang') == 'en'][::-1] + [x for x in poster2 if x.get('lang') in ['00', '']][::-1]
                poster2 = poster2[0]['url'].encode('utf-8')
            except:
                poster2 = '0'

            try:
                if 'moviebackground' in art: fanart = art['moviebackground']
                else: fanart = art['moviethumb']
                fanart = [x for x in fanart if x.get('lang') == self.lang][::-1] + [x for x in fanart if x.get('lang') == 'en'][::-1] + [x for x in fanart if x.get('lang') in ['00', '']][::-1]
                fanart = fanart[0]['url'].encode('utf-8')
            except:
                fanart = '0'

            try:
                banner = art['moviebanner']
                banner = [x for x in banner if x.get('lang') == self.lang][::-1] + [x for x in banner if x.get('lang') == 'en'][::-1] + [x for x in banner if x.get('lang') in ['00', '']][::-1]
                banner = banner[0]['url'].encode('utf-8')
            except:
                banner = '0'

            try:
                if 'hdmovielogo' in art: clearlogo = art['hdmovielogo']
                else: clearlogo = art['clearlogo']
                clearlogo = [x for x in clearlogo if x.get('lang') == self.lang][::-1] + [x for x in clearlogo if x.get('lang') == 'en'][::-1] + [x for x in clearlogo if x.get('lang') in ['00', '']][::-1]
                clearlogo = clearlogo[0]['url'].encode('utf-8')
            except:
                clearlogo = '0'

            try:
                if 'hdmovieclearart' in art: clearart = art['hdmovieclearart']
                else: clearart = art['clearart']
                clearart = [x for x in clearart if x.get('lang') == self.lang][::-1] + [x for x in clearart if x.get('lang') == 'en'][::-1] + [x for x in clearart if x.get('lang') in ['00', '']][::-1]
                clearart = clearart[0]['url'].encode('utf-8')
            except:
                clearart = '0'

            try:
                if 'moviethumb' in art: landscape = art['moviethumb']
                else: landscape = art['moviebackground']
                landscape = [x for x in landscape if x.get('lang') == 'en'][::-1] + [x for x in landscape if x.get('lang') == '00'][::-1]
                landscape = landscape[0]['url'].encode('utf-8')
            except:
                landscape = '0'

            try:
                if self.tm_user == '': raise Exception()
                art2 = client.request(self.tm_art_link % imdb, timeout = '10', error = True)
                art2 = json.loads(art2)
            except:
                pass

            try:
                poster3 = art2['posters']
                poster3 = [x for x in poster3 if x.get('iso_639_1') == self.lang] + [x for x in poster3 if x.get('iso_639_1') == 'en'] + [x for x in poster3 if x.get('iso_639_1') not in [self.lang, 'en']]
                poster3 = [(x['width'], x['file_path']) for x in poster3]
                poster3 = [(x[0], x[1]) if x[0] < 300 else ('300', x[1]) for x in poster3]
                poster3 = self.tm_img_link % poster3[0]
                poster3 = poster3.encode('utf-8')
            except:
                poster3 = '0'

            try:
                fanart2 = art2['backdrops']
                fanart2 = [x for x in fanart2 if x.get('iso_639_1') == self.lang] + [x for x in fanart2 if x.get('iso_639_1') == 'en'] + [x for x in fanart2 if x.get('iso_639_1') not in [self.lang, 'en']]
                fanart2 = [x for x in fanart2 if x.get('width') == 1920] + [x for x in fanart2 if x.get('width') < 1920]
                fanart2 = [(x['width'], x['file_path']) for x in fanart2]
                fanart2 = [(x[0], x[1]) if x[0] < 1280 else ('1280', x[1]) for x in fanart2]
                fanart2 = self.tm_img_link % fanart2[0]
                fanart2 = fanart2.encode('utf-8')
            except:
                fanart2 = '0'

            item = {'title': title, 'originaltitle': originaltitle, 'year': year, 'imdb': imdb, 'tmdb': tmdb, 'poster': '0', 'poster2': poster2, 'poster3': poster3, 'banner': banner, 'fanart': fanart, 'fanart2': fanart2, 'clearlogo': clearlogo, 'clearart': clearart, 'landscape': landscape, 'premiered': premiered, 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'writer': writer, 'cast': cast, 'plot': plot, 'tagline': tagline}
            item = dict((k,v) for k, v in item.iteritems() if not v == '0')
            self.list[i].update(item)

            if artmeta == False: raise Exception()

            meta = {'imdb': imdb, 'tmdb': tmdb, 'tvdb': '0', 'lang': self.lang, 'user': self.user, 'item': item}
            self.meta.append(meta)
        except:
            pass


    def super_tmdb_info(self, i):
        try:
            if self.list[i]['metacache'] == True: raise Exception()

            try: tmdb = self.list[i]['tmdb']
            except: tmdb = '0'
            if not tmdb == '0': url = self.tmdb_info_link % tmdb
            else: raise Exception()

            item = client.request(url, timeout='10')
            item = json.loads(item)

            title = item['title']
            title = client.replaceHTMLCodes(title)

            originaltitle = title

            year = item['release_date']
            try: year = re.compile('(\d{4})').findall(year)[0]
            except: year = '0'
            if year == '' or year == None: year = '0'
            year = year.encode('utf-8')

            tmdb = item['id']
            if tmdb == '' or tmdb == None: tmdb = '0'
            tmdb = re.sub('[^0-9]', '', str(tmdb))
            tmdb = tmdb.encode('utf-8')

            imdb = item['imdb_id']
            if imdb == '' or imdb == None: imdb = '0'
            imdb = imdb.encode('utf-8')

            poster = item['poster_path']
            if poster == '' or poster == None: poster = '0'
            if not poster == '0': poster = '%s%s' % (self.tmdb_poster, poster)
            poster = poster.encode('utf-8')

            fanart = item['backdrop_path']
            if fanart == '' or fanart == None: fanart = '0'
            if not fanart == '0': fanart = '%s%s' % (self.tmdb_image, fanart)
            fanart = fanart.encode('utf-8')

            premiered = item['release_date']
            try: premiered = re.compile('(\d{4}-\d{2}-\d{2})').findall(premiered)[0]
            except: premiered = '0'
            if premiered == '' or premiered == None: premiered = '0'
            premiered = premiered.encode('utf-8')

            # studio = item['production_companies']
            # try: studio = [x['name'] for x in studio][0]
            # except: studio = '0'
            # if studio == '' or studio == None: studio = '0'
            # studio = studio.encode('utf-8')
            # if not studio == '0': self.list[i].update({'studio': studio})

            genre = item['genres']
            try: genre = [x['name'] for x in genre]
            except: genre = '0'
            if genre == '' or genre == None or genre == []: genre = '0'
            genre = ' / '.join(genre)
            genre = genre.encode('utf-8')

            try: duration = str(item['runtime'])
            except: duration = '0'
            if duration == '' or duration == None: duration = '0'
            duration = duration.encode('utf-8')

            rating = str(item['vote_average'])
            if rating == '' or rating == None: rating = '0'
            rating = rating.encode('utf-8')

            votes = str(item['vote_count'])
            try: votes = str(format(int(votes),',d'))
            except: pass
            if votes == '' or votes == None: votes = '0'
            votes = votes.encode('utf-8')

            mpaa = item['releases']['countries']
            try: mpaa = [x for x in mpaa if not x['certification'] == '']
            except: mpaa = '0'
            try: mpaa = ([x for x in mpaa if x['iso_3166_1'].encode('utf-8') == 'US'] + [x for x in mpaa if not x['iso_3166_1'].encode('utf-8') == 'US'])[0]['certification']
            except: mpaa = '0'
            mpaa = mpaa.encode('utf-8')

            director = item['credits']['crew']
            try: director = [x['name'] for x in director if x['job'].encode('utf-8') == 'Director']
            except: director = '0'
            if director == '' or director == None or director == []: director = '0'
            director = ' / '.join(director)
            director = director.encode('utf-8')

            writer = item['credits']['crew']
            try: writer = [x['name'] for x in writer if x['job'].encode('utf-8') in ['Writer', 'Screenplay']]
            except: writer = '0'
            try: writer = [x for n,x in enumerate(writer) if x not in writer[:n]]
            except: writer = '0'
            if writer == '' or writer == None or writer == []: writer = '0'
            writer = ' / '.join(writer)
            writer = writer.encode('utf-8')

            cast = item['credits']['cast']
            try: cast = [(x['name'].encode('utf-8'), x['character'].encode('utf-8')) for x in cast]
            except: cast = []

            plot = item['overview']
            if plot == '' or plot == None: plot = '0'
            plot = plot.encode('utf-8')

            tagline = item['tagline']
            if (tagline == '' or tagline == None) and not plot == '0': tagline = re.compile('[.!?][\s]{1,2}(?=[A-Z])').split(plot)[0]
            elif tagline == '' or tagline == None: tagline = '0'
            try: tagline = tagline.encode('utf-8')
            except: pass

            try:
                if not imdb == None or imdb == '0':
                    url = self.imdbinfo % imdb
                    item = client.request(url, timeout='10')
                    item = json.loads(item)

                    plot2 = item['Plot']
                    if plot2 == '' or plot2 == None: plot = plot
                    plot = plot.encode('utf-8')

                    rating2 = str(item['imdbRating'])
                    if rating2 == '' or rating2 == None: rating = rating2
                    rating = rating.encode('utf-8')

                    votes2 = str(item['imdbVotes'])
                    try: votes2 = str(votes2)
                    except: pass
                    if votes2 == '' or votes2 == None: votes = votes2
                    votes = votes.encode('utf-8')

            except:
                pass

            try:
                artmeta = True
                art = client.request(self.fanart_tv_art_link % imdb, headers=self.fanart_tv_headers, timeout='10', error=True)
                try: art = json.loads(art)
                except: artmeta = False
            except:
                pass

            try:
                poster2 = art['movieposter']
                poster2 = [x for x in poster2 if x.get('lang') == self.lang][::-1] + [x for x in poster2 if x.get('lang') == 'en'][::-1] + [x for x in poster2 if x.get('lang') in ['00', '']][::-1]
                poster2 = poster2[0]['url'].encode('utf-8')
            except:
                poster2 = '0'

            try:
                if 'moviebackground' in art: fanart = art['moviebackground']
                else: fanart = art['moviethumb']
                fanart = [x for x in fanart if x.get('lang') == self.lang][::-1] + [x for x in fanart if x.get('lang') == 'en'][::-1] + [x for x in fanart if x.get('lang') in ['00', '']][::-1]
                fanart = fanart[0]['url'].encode('utf-8')
            except:
                fanart = '0'

            try:
                banner = art['moviebanner']
                banner = [x for x in banner if x.get('lang') == self.lang][::-1] + [x for x in banner if x.get('lang') == 'en'][::-1] + [x for x in banner if x.get('lang') in ['00', '']][::-1]
                banner = banner[0]['url'].encode('utf-8')
            except:
                banner = '0'

            try:
                if 'hdmovielogo' in art: clearlogo = art['hdmovielogo']
                else: clearlogo = art['clearlogo']
                clearlogo = [x for x in clearlogo if x.get('lang') == self.lang][::-1] + [x for x in clearlogo if x.get('lang') == 'en'][::-1] + [x for x in clearlogo if x.get('lang') in ['00', '']][::-1]
                clearlogo = clearlogo[0]['url'].encode('utf-8')
            except:
                clearlogo = '0'

            try:
                if 'hdmovieclearart' in art: clearart = art['hdmovieclearart']
                else: clearart = art['clearart']
                clearart = [x for x in clearart if x.get('lang') == self.lang][::-1] + [x for x in clearart if x.get('lang') == 'en'][::-1] + [x for x in clearart if x.get('lang') in ['00', '']][::-1]
                clearart = clearart[0]['url'].encode('utf-8')
            except:
                clearart = '0'

            try:
                if 'moviethumb' in art: landscape = art['moviethumb']
                else: landscape = art['moviebackground']
                landscape = [x for x in landscape if x.get('lang') == 'en'][::-1] + [x for x in landscape if x.get('lang') == '00'][::-1]
                landscape = landscape[0]['url'].encode('utf-8')
            except:
                landscape = '0'

            try:
                if self.tm_user == '': raise Exception()
                art2 = client.request(self.tm_art_link % imdb, timeout='10', error=True)
                art2 = json.loads(art2)
            except:
                pass

            try:
                poster3 = art2['posters']
                poster3 = [x for x in poster3 if x.get('iso_639_1') == self.lang] + [x for x in poster3 if x.get('iso_639_1') == 'en'] + [x for x in poster3 if x.get('iso_639_1') not in [self.lang, 'en']]
                poster3 = [(x['width'], x['file_path']) for x in poster3]
                poster3 = [(x[0], x[1]) if x[0] < 300 else ('300', x[1]) for x in poster3]
                poster3 = self.tm_img_link % poster3[0]
                poster3 = poster3.encode('utf-8')
            except:
                poster3 = '0'

            try:
                fanart2 = art2['backdrops']
                fanart2 = [x for x in fanart2 if x.get('iso_639_1') == self.lang] + [x for x in fanart2 if x.get('iso_639_1') == 'en'] + [x for x in fanart2 if x.get('iso_639_1') not in [self.lang, 'en']]
                fanart2 = [x for x in fanart2 if x.get('width') == 1920] + [x for x in fanart2 if x.get('width') < 1920]
                fanart2 = [(x['width'], x['file_path']) for x in fanart2]
                fanart2 = [(x[0], x[1]) if x[0] < 1280 else ('1280', x[1]) for x in fanart2]
                fanart2 = self.tm_img_link % fanart2[0]
                fanart2 = fanart2.encode('utf-8')
            except:
                fanart2 = '0'

            item = {'title': title, 'originaltitle': originaltitle, 'year': year, 'imdb': imdb, 'tmdb': tmdb, 'poster': '0', 'poster2': poster2, 'poster3': poster3, 'banner': banner, 'fanart': fanart, 'fanart2': fanart2, 'clearlogo': clearlogo, 'clearart': clearart, 'landscape': landscape, 'premiered': premiered, 'studio': '0', 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'writer': writer, 'cast': cast, 'plot': plot, 'tagline': tagline}
            item = dict((k,v) for k, v in item.iteritems() if not v == '0')
            self.list[i].update(item)

            if artmeta == False: raise Exception()

            meta = {'imdb': imdb, 'tmdb': tmdb, 'tvdb': '0', 'lang': self.lang, 'user': self.user, 'item': item}
            self.meta.append(meta)

#            self.meta.append({'tmdb': tmdb, 'imdb': imdb, 'tmdb': tmdb, 'tvdb': '0', 'lang': self.tmdb_lang, 'item': {'title': title, 'year': year, 'code': imdb, 'imdb': imdb, 'tmdb': tmdb, 'poster': poster, 'fanart': fanart, 'premiered': premiered, 'studio': studio, 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'writer': writer, 'cast': cast, 'plot': plot, 'tagline': tagline}})
        except:
            pass


    def movieDirectory(self, items):
        if items == None or len(items) == 0: 
            control.idle()
            control.notification(title = 32001, message = 33049, icon = 'INFO')
            sys.exit()


        addonPoster, addonBanner = control.addonPoster(), control.addonBanner()
        addonFanart, settingFanart = control.addonFanart(), control.setting('fanart')

        traktCredentials = trakt.getTraktCredentialsInfo()

        try: isOld = False ; control.item().getArt('type')
        except: isOld = True

        indicators = playcount.getMovieIndicators()

        isPlayable = 'true' if not 'plugin' in control.infoLabel('Container.PluginName') else 'false'

        playbackMenu = control.lang(32063).encode('utf-8') if control.setting('hosts.mode') == '2' else control.lang(32064).encode('utf-8')
        watchedMenu = control.lang(32068).encode('utf-8') if trakt.getTraktIndicatorsInfo() == True else control.lang(32066).encode('utf-8')
        unwatchedMenu = control.lang(32069).encode('utf-8') if trakt.getTraktIndicatorsInfo() == True else control.lang(32067).encode('utf-8')
        queueMenu = control.lang(32065).encode('utf-8')
        traktManagerMenu = control.lang(32070).encode('utf-8')
        nextMenu = control.lang(32053).encode('utf-8')
        addToLibrary = control.lang(32551).encode('utf-8')

        for i in items:
            try:
                imdb, tmdb, year = i['imdb'], i['tmdb'], i['year']
                try: title = i['originaltitle']
                except: title = i['title']
                label = '%s (%s)' % (i['title'], i['year'])

                sysname = urllib.quote_plus('%s (%s)' % (title, year))
                systitle = urllib.quote_plus(title)

                meta = dict((k,v) for k, v in i.iteritems() if not v == '0')
                meta.update({'code': imdb, 'imdbnumber': imdb, 'imdb_id': imdb})
                meta.update({'tmdb_id': tmdb})
                meta.update({'mediatype': 'movie'})
                meta.update({'trailer': '%s?action=trailer&name=%s' % (sysaddon, urllib.quote_plus(label))})

                # Some descriptions have a link at the end that. Remove it.
                try:
                    plot = meta['plot']
                    index = plot.rfind('See full summary')
                    if index >= 0: plot = plot[:index]
                    plot = plot.strip()
                    if re.match('[a-zA-Z\d]$', plot): plot += ' ...'
                    meta['plot'] = plot
                except: pass

                try: meta.update({'duration': str(int(meta['duration']) * 60)})
                except: pass
                try: meta.update({'genre': cleangenre.lang(meta['genre'], self.lang)})
                except: pass
                try: meta.update({'year': int(meta['year'])})
                except: pass

                poster = [i[x] for x in ['poster3', 'poster', 'poster2'] if i.get(x, '0') != '0']
                poster = poster[0] if poster else addonPoster
                meta.update({'poster': poster})
                sysmeta = urllib.quote_plus(json.dumps(meta))

                url = '%s?action=play&title=%s&year=%s&imdb=%s&meta=%s&t=%s' % (sysaddon, systitle, year, imdb, sysmeta, self.systime)
                sysurl = urllib.quote_plus(url)
#                path = '%s?action=play&title=%s&year=%s&imdb=%s' % (sysaddon, systitle, year, imdb)

####-Context Menu and Overlays-####
                cm = []
                if traktCredentials == True:
                    cm.append((traktManagerMenu, 'RunPlugin(%s?action=traktManager&name=%s&imdb=%s)' % (sysaddon, sysname, imdb)))

                try:
                    overlay = int(playcount.getMovieOverlay(indicators, imdb))
                    if overlay == 7:
                        cm.append((unwatchedMenu, 'RunPlugin(%s?action=moviePlaycount&imdb=%s&query=6)' % (sysaddon, imdb)))
                        meta.update({'playcount': 1, 'overlay': 7})
                    else:
                        cm.append((watchedMenu, 'RunPlugin(%s?action=moviePlaycount&imdb=%s&query=7)' % (sysaddon, imdb)))
                        meta.update({'playcount': 0, 'overlay': 6})
                except:
                    pass
                cm.append(('Find similar', 'ActivateWindow(10025,%s?action=movies&url=https://api.trakt.tv/movies/%s/related,return)' % (sysaddon, imdb)))
                cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
                cm.append((playbackMenu, 'RunPlugin(%s?action=alterSources&url=%s&meta=%s)' % (sysaddon, sysurl, sysmeta)))
                if isOld == True:
                    cm.append((control.lang2(19033).encode('utf-8'), 'Action(Info)'))
                cm.append((addToLibrary, 'RunPlugin(%s?action=movieToLibrary&name=%s&title=%s&year=%s&imdb=%s&tmdb=%s)' % (sysaddon, sysname, systitle, year, imdb, tmdb)))
                poster = '0'
                if poster == '0' and 'poster3' in i: poster = i['poster3']
                if poster == '0' and 'poster2' in i: poster = i['poster2']
                if poster == '0' and 'poster' in i: poster = i['poster']

                icon = '0'
                if icon == '0' and 'icon3' in i: icon = i['icon3']
                if icon == '0' and 'icon2' in i: icon = i['icon2']
                if icon == '0' and 'icon' in i: icon = i['icon']

                thumb = '0'
                if thumb == '0' and 'thumb3' in i: thumb = i['thumb3']
                if thumb == '0' and 'thumb2' in i: thumb = i['thumb2']
                if thumb == '0' and 'thumb' in i: thumb = i['thumb']

                banner = '0'
                if banner == '0' and 'banner3' in i: banner = i['banner3']
                if banner == '0' and 'banner2' in i: banner = i['banner2']
                if banner == '0' and 'banner' in i: banner = i['banner']

                fanart = '0'
                if settingFanart:
                    if fanart == '0' and 'fanart3' in i: fanart = i['fanart3']
                    if fanart == '0' and 'fanart2' in i: fanart = i['fanart2']
                    if fanart == '0' and 'fanart' in i: fanart = i['fanart']

                clearlogo = '0'
                if clearlogo == '0' and 'clearlogo' in i: clearlogo = i['clearlogo']

                clearart = '0'
                if clearart == '0' and 'clearart' in i: clearart = i['clearart']

                landscape = '0'
                if landscape == '0' and 'landscape' in i: landscape = i['landscape']

                if poster == '0': poster = addonPoster
                if icon == '0': icon = poster
                if thumb == '0': thumb = poster
                if banner == '0': banner = addonBanner
                if fanart == '0': fanart = addonFanart

                art = {}
                if not poster == '0' and not poster == None: art.update({'poster' : poster})
                if not icon == '0' and not icon == None: art.update({'icon' : icon})
                if not thumb == '0' and not thumb == None: art.update({'thumb' : thumb})
                if not banner == '0' and not banner == None: art.update({'banner' : banner})
                if not clearlogo == '0' and not clearlogo == None: art.update({'clearlogo' : clearlogo})
                if not clearart == '0' and not clearart == None: art.update({'clearart' : clearart})
                if not landscape == '0' and not landscape == None: art.update({'landscape' : landscape})


                item = control.item(label = label)
                if not fanart == '0' and not fanart == None: item.setProperty('Fanart_Image', fanart)
                item.setArt(art)
                item.setProperty('IsPlayable', isPlayable)
                item.setInfo(type='Video', infoLabels = control.metadataClean(meta))
                video_streaminfo = {'codec': 'h264'}
                item.addStreamInfo('video', video_streaminfo)
                item.addContextMenuItems(cm)
                control.addItem(handle = syshandle, url = url, listitem = item, isFolder = False)
            except:
                pass

        try:
            url = items[0]['next']
            if url == '': raise Exception()

            icon = control.addonNext()
            url = '%s?action=moviePage&url=%s' % (sysaddon, urllib.quote_plus(url))

            item = control.item(label=nextMenu)

            item.setArt({'icon': icon, 'thumb': icon, 'poster': icon, 'banner': icon})
            if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)

            control.addItem(handle = syshandle, url = url, listitem = item, isFolder = True)
        except:
            pass

        control.content(syshandle, 'movies')
        control.directory(syshandle, cacheToDisc=True)
        views.setView('movies', {'skin.estuary': 55, 'skin.confluence': 500})


    def addDirectory(self, items, queue = False):
        if items == None or len(items) == 0: control.idle() ; sys.exit()

        addonFanart, addonThumb, artPath = control.addonFanart(), control.addonThumb(), control.artPath()
        queueMenu = control.lang(32065).encode('utf-8')
        playRandom = control.lang(32535).encode('utf-8')
        addToLibrary = control.lang(32551).encode('utf-8')

        for i in items:
            try:
                name = i['name']

                if i['image'].startswith('http'): thumb = i['image']
                elif not artPath == None: thumb = os.path.join(artPath, i['image'])
                else: thumb = addonThumb

                url = '%s?action=%s' % (sysaddon, i['action'])
                try: url += '&url=%s' % urllib.quote_plus(i['url'])
                except: pass

                cm = []
                cm.append((playRandom, 'RunPlugin(%s?action=random&rtype=movie&url=%s)' % (sysaddon, urllib.quote_plus(i['url']))))
                if queue == True:
                    cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
                try: cm.append((addToLibrary, 'RunPlugin(%s?action=moviesToLibrary&url=%s)' % (sysaddon, urllib.quote_plus(i['context']))))
                except: pass
                item = control.item(label = name)

                item.setArt({'icon': thumb, 'thumb': thumb, 'poster': thumb, 'banner': thumb})
                if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)

                item.addContextMenuItems(cm)
                control.addItem(handle = syshandle, url = url, listitem = item, isFolder = True)
            except:
                pass

        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc = True)


    def addDirectoryItem(self, name, query, thumb, icon, context = None, queue = False, isAction = True, isFolder = True):
        try: name = control.lang(name).encode('utf-8')
        except: pass

        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query

        thumb = os.path.join(artPath, thumb) if not artPath == None else icon

        cm = []
        if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
        if not context == None: cm.append((control.lang(context[0]).encode('utf-8'), 'RunPlugin(%s?action=%s)' % (sysaddon, context[1])))
        item = control.item(label = name)
        item.addContextMenuItems(cm)

        item.setArt({'icon': thumb, 'thumb': thumb})
        if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
        control.addItem(handle=syshandle, url = url, listitem = item, isFolder = isFolder)


    def endDirectory(self):
        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc = True)
