# -*- coding: utf-8 -*-

'''
    mirrorv2 Add-on
'''

import urlparse, sys, urllib, xbmc
from resources.lib.modules import control
from resources.lib.modules import log_utils

params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))
action = params.get('action')

subid = params.get('subid')
name = params.get('name')
title = params.get('title')
year = params.get('year')
imdb = params.get('imdb')
tvdb = params.get('tvdb')
tmdb = params.get('tmdb')
season = params.get('season')
episode = params.get('episode')
tvshowtitle = params.get('tvshowtitle')
premiered = params.get('premiered')
url = params.get('url')
image = params.get('image')
meta = params.get('meta')
art = params.get('art')
select = params.get('select')
query = params.get('query')
source = params.get('source')
content = params.get('content')
docu_category = params.get('docuCat')
docu_watch = params.get('docuPlay')
windowedtrailer = params.get('windowedtrailer')
windowedtrailer = int(windowedtrailer) if windowedtrailer in ("0","1") else 0


if action is None:
    from resources.lib.menus import navigator
    from resources.lib.modules import cache
    run = control.setting('first.info')
    if run == '': run = 'true' 
    if cache._find_cache_version(): run = 'true'  
    if run == 'true':
        from resources.lib.modules import changelog
        changelog.get()
        control.setSetting(id='first.info', value='false')
    cache.cache_version_check()
    navigator.Navigator().root()



####################################################
#---News and Updates
####################################################
elif action == 'infoCheck':
    from resources.lib.menus import navigator
    navigator.Navigator().infoCheck('')

elif action == 'ShowNews':
    from resources.lib.modules import newsinfo
    newsinfo.news()

elif action == 'ShowChangelog':
    from resources.lib.modules import changelog
    changelog.get()



####################################################
#---MOVIE
####################################################
elif action == 'movieNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().movies()

elif action == 'movieliteNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().movies(lite=True)

elif action == 'mymovieNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().mymovies()

elif action == 'mymovieliteNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().mymovies(lite=True)

elif action == 'movies':
    from resources.lib.menus import movies
    movies.Movies().get(url)

elif action == 'moviePage':
    from resources.lib.menus import movies
    movies.Movies().get(url)

elif action == 'tmdbmovies':
    from resources.lib.menus import movies
    movies.Movies().getTMDb(url)

elif action == 'tmdbmoviePage':
    from resources.lib.menus import movies
    movies.Movies().getTMDb(url)

elif action == 'newMovies':
    from resources.lib.menus import movies
    movies.Movies().newMovies()

elif action == 'movieSearch':
    from resources.lib.menus import movies
    movies.Movies().search()

elif action == 'movieSearchnew':
    from resources.lib.menus import movies
    movies.Movies().search_new()

elif action == 'movieSearchterm':
    from resources.lib.menus import movies
    movies.Movies().search_term(name)

elif action == 'moviePerson':
    from resources.lib.menus import movies
    movies.Movies().person()

elif action == 'movieGenres':
    from resources.lib.menus import movies
    movies.Movies().genres()

elif action == 'movieLanguages':
    from resources.lib.menus import movies
    movies.Movies().languages()

elif action == 'movieCertificates':
    from resources.lib.menus import movies
    movies.Movies().certifications()

elif action == 'movieYears':
    from resources.lib.menus import movies
    movies.Movies().years()

elif action == 'moviePersons':
    from resources.lib.menus import movies
    movies.Movies().persons(url)

elif action == 'movieUserlists':
    from resources.lib.menus import movies
    movies.Movies().userlists()



####################################################
#---Collections
####################################################

elif action == 'boxsetsmaster':
    from resources.lib.menus import navigator
    navigator.Navigator().boxsetsmaster()

if action == 'boxsetsNavigator':
    from resources.lib.menus import tmdb
    tmdb.movies().collectionBoxset()

if action == 'boxsets':
    from resources.lib.menus import tmdb
    tmdb.movies().collectionBoxset()

if action == 'actorNavigator':
    from resources.lib.menus import tmdb
    tmdb.movies().actorBoxset()

elif action == 'holidaysNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().holidaysBoxset()

elif action == 'mysupermvNavigator':
    from resources.lib.menus import tmdb
    tmdb.movies().mysupermv()

elif action == 'collectionSuperhero':
    from resources.lib.menus import tmdb
    tmdb.movies().collectionSuperhero()

elif action == 'kidsboxsets':
    from resources.lib.menus import tmdb
    tmdb.movies().kidsboxsets()

elif action == 'collections':
    from resources.lib.menus import collections
    collections.collections().get(url)

elif action == 'movieExploreKeywords':
    from resources.lib.menus import movies
    movies.Movies().exploreKeywords()

elif action == 'tvshowExploreKeywords':
    from resources.lib.menus import tvshows
    tvshows.TVshows().exploreKeywords()

elif action == 'movieimdbUserLists':
    from resources.lib.menus import movies
    movies.Movies().imdbUserLists()

elif action == 'tvshowimdbUserLists':
    from resources.lib.menus import tvshows
    tvshows.TVshows().imdbUserLists()

elif action == 'hellaLifeTimeHallMark':
    from resources.lib.menus import movies
    movies.Movies().hellaLifeTimeHallMark()

elif action == 'genremovies':
    from resources.lib.menus import navigator
    navigator.Navigator().genremovies()

####################################################
#---OPENMETA
####################################################

elif action == 'openmeta_menu':
    from resources.lib.menus import iptv
    iptv.indexer().rootopenmeta_menu()

####################################################
#---MCLIST
####################################################

elif action == 'mclist':
    from resources.lib.menus import iptv
    iptv.indexer().rootmclist()

####################################################
#---Furk
####################################################
elif action == "furkNavigator":
    from resources.lib.menus import navigator
    navigator.Navigator().furk()

elif action == "furkMetaSearch":
    from resources.lib.menus import furk
    furk.Furk().furk_meta_search(url)

elif action == "furkSearch":
    from resources.lib.menus import furk
    furk.Furk().search()

elif action == "furkUserFiles":
    from resources.lib.menus import furk
    furk.Furk().user_files()

elif action == "furkSearchNew":
    from resources.lib.menus import furk
    furk.Furk().search_new()



####################################################
# TV Shows
####################################################
elif action == 'tvNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().tvshows()

elif action == 'tvliteNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().tvshows(lite=True)

elif action == 'mytvNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().mytvshows()

elif action == 'mytvliteNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().mytvshows(lite=True)

elif action == 'channels':
    from resources.lib.menus import channels
    channels.channels().get()

elif action == 'tvshows':
    from resources.lib.menus import tvshows
    tvshows.TVshows().get(url)

elif action == 'tvshowPage':
    from resources.lib.menus import tvshows
    tvshows.TVshows().get(url)

elif action == 'tmdbTvshows':
    from resources.lib.menus import tvshows
    tvshows.TVshows().getTMDb(url)

elif action == 'tmdbTvshowPage':
    from resources.lib.menus import tvshows
    tvshows.TVshows().getTMDb(url)

elif action == 'tvmazeTvshows':
    from resources.lib.menus import tvshows
    tvshows.TVshows().getTVmaze(url)

elif action == 'tvmazeTvshowPage':
    from resources.lib.menus import tvshows
    tvshows.TVshows().getTVmaze(url)

elif action == 'tvSearch':
    from resources.lib.menus import tvshows
    tvshows.TVshows().search()

elif action == 'tvSearchnew':
    from resources.lib.menus import tvshows
    tvshows.TVshows().search_new()

elif action == 'tvSearchterm':
    from resources.lib.menus import tvshows
    tvshows.TVshows().search_term(name)

elif action == 'tvPerson':
    from resources.lib.menus import tvshows
    tvshows.TVshows().person()

elif action == 'tvGenres':
    from resources.lib.menus import tvshows
    tvshows.TVshows().genres()

elif action == 'tvNetworks':
    from resources.lib.menus import tvshows
    tvshows.TVshows().networks()

elif action == 'tvLanguages':
    from resources.lib.menus import tvshows
    tvshows.TVshows().languages()

elif action == 'tvCertificates':
    from resources.lib.menus import tvshows
    tvshows.TVshows().certifications()

elif action == 'tvPersons':
    from resources.lib.menus import tvshows
    tvshows.TVshows().persons(url)

elif action == 'tvUserlists':
    from resources.lib.menus import tvshows
    tvshows.TVshows().userlists()

####################################################
# DOCUMENTARY
####################################################

elif action == 'docuNavigator':
    from resources.lib.menus import docu
    docu.documentary().root()

elif action == 'docuHeaven':
    from resources.lib.menus import docu
    if not docu_category == None:
        docu.documentary().docu_list(docu_category)
    elif not docu_watch == None:
        docu.documentary().docu_play(docu_watch)
    else:
        docu.documentary().root()

####################################################
# YOUTUBE
####################################################

elif action == 'ytube':
    from resources.lib.menus import youtube
    if subid == None:
        youtube.yt_index().root(action)
    else:
        youtube.yt_index().get(action, subid)

elif action == 'kidscorner':
    from resources.lib.menus import youtube
    if subid == None:
        youtube.yt_index().root(action)
    else:
        youtube.yt_index().get(action, subid)

elif action == 'fitness':
    from resources.lib.menus import youtube
    if subid == None:
        youtube.yt_index().root(action)
    else:
        youtube.yt_index().get(action, subid)

elif action == 'legends':
    from resources.lib.menus import youtube
    if subid == None:
        youtube.yt_index().root(action)
    else:
        youtube.yt_index().get(action, subid)

elif action == 'browser':
    from resources.lib.menus import iptv
    iptv.resolver().browser(url)

elif action == 'lists_play':
    from resources.lib.menus import iptv
    iptv.player().play(url, content)




####################################################
# SEASON
####################################################
elif action == 'seasons':
    from resources.lib.menus import seasons
    seasons.Seasons().get(tvshowtitle, year, imdb, tvdb)

elif action == 'seasonsUserlists':
    from resources.lib.indexers import seasons
    seasons.Seasons().userlists()

elif action == 'seasonsList':
    from resources.lib.menus import seasons
    seasons.Seasons().seasonList(url)



####################################################
# EPISODES
####################################################
elif action == 'episodes':
    from resources.lib.menus import episodes
    episodes.Episodes().get(tvshowtitle, year, imdb, tvdb, season, episode)

elif action == 'tvWidget':
    from resources.lib.menus import episodes
    episodes.Episodes().widget()

elif action == 'calendar':
    from resources.lib.menus import episodes
    episodes.Episodes().calendar(url)

elif action == 'calendars':
    from resources.lib.menus import episodes
    episodes.Episodes().calendars()

elif action == 'episodesUnfinished':
    from resources.lib.menus import episodes
    episodes.Episodes().unfinished()

elif action == 'episodesUserlists':
    from resources.lib.menus import episodes
    episodes.Episodes().userlists()


####################################################
# IPTV NAVIGATOR
####################################################
elif action == 'iptvNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().iptv()

elif action == 'directory':
    from resources.lib.menus import iptv
    iptv.indexer().get(url)

elif action == 'qdirectory':
    from resources.lib.menus import iptv
    iptv.indexer().getq(url)

elif action == 'xdirectory':
    from resources.lib.menus import iptv
    iptv.indexer().getx(url)

if action == 'xxx':
    from resources.lib.menus import iptv
    iptv.indexer().rootXXX()

if action == 'alltv':
    from resources.lib.menus import iptv
    iptv.indexer().rootalltv()

if action == 'countrytv':
    from resources.lib.menus import iptv
    iptv.indexer().rootcountrytv()

if action == 'foreigntv':
    from resources.lib.menus import iptv
    iptv.indexer().rootforeign_channels()

if action == 'foreignchannels':
    from resources.lib.menus import navigator
    navigator.Navigator().foreignchannels()

elif action == 'ustvgoNavigator':
    from resources.lib.menus import ustvgo
    ustvgo.ustvgo().root()

elif action == 'ustvgoPlay':
    from resources.lib.menus import ustvgo
    ustvgo.ustvgo().play(url)

if action == 'cinematv':
    from resources.lib.menus import iptv
    iptv.indexer().rootcinematv()

if action == 'faithtv':
    from resources.lib.menus import iptv
    iptv.indexer().rootfaithtv()

if action == 'lodgetv':
    from resources.lib.menus import iptv
    iptv.indexer().rootlodgetv()

if action == 'radiotv':
    from resources.lib.menus import iptv
    iptv.indexer().rootradiotv()

if action == 'sportplugins':
    from resources.lib.menus import iptv
    iptv.indexer().rootsportplugins()

if action == 'mytv':
    from resources.lib.menus import iptv
    iptv.indexer().rootmytv()

if action == 'sportChannels':
    from resources.lib.menus import iptv
    iptv.indexer().root()

elif action == 'mytube':
    from resources.lib.menus import youtube
    if subid == None:
        youtube.yt_index().root(action)
    else:
        youtube.yt_index().get(action, subid)

elif action == 'tmdb':
    from resources.lib.menus import tmdb
    tmdb.movies().get(url)

if action == 'kids':
    from resources.lib.menus import iptv
    iptv.indexer().rootkids()

elif action == 'vipbox':
    from resources.lib.menus import navigator
    navigator.Navigator().vipbox()


####################################################
#---ONECLICK MOVIES
####################################################

if action == '1click':
    from resources.lib.menus import iptv
    iptv.indexer().root_1click()

if action == '1clicknl':
    from resources.lib.menus import iptv
    iptv.indexer().rootnlmovie()

if action == '4kmovies':
    from resources.lib.menus import iptv
    iptv.indexer().root4kmovies()

if action == '1kmovies':
    from resources.lib.menus import iptv
    iptv.indexer().root1kmovies()

if action == 'dtsmovies':
    from resources.lib.menus import iptv
    iptv.indexer().rootdtsmovies()

elif action == 'oneclick':
    from resources.lib.menus import navigator
    navigator.Navigator().oneclickmovies()

if action == 'kids':
    from resources.lib.menus import iptv
    iptv.indexer().rootkids()

####################################################
#---ACRONAITV
####################################################

elif action == 'acronaitv_menu':
    from resources.lib.menus import acrotv
    acrontv.acronaitv().list_categories()

elif action == 'arconai_cable':
    from resources.lib.menus import acrotv
    acrotv.acrotv().list_cable()

elif action == 'arconai_play':
    from resources.lib.menus import acrotv
    acrotv.acrotv().play_video(params['selection'])

####################################################
#---TUNES RADIO
####################################################

elif action == 'radioNavigator':
    from resources.lib.menus import tunes
    tunes.radionet().root()

elif action == 'radio':
    from resources.lib.menus import tunes
    tunes.radionet().get_stations(url)

elif action == 'radioCat':
    from resources.lib.menus import tunes
    tunes.radionet().get_categories(url)

elif action == 'radioCatStations':
    from resources.lib.menus import tunes
    tunes.radionet().get_category_stations(url)

elif action == 'radioPlayStation':
    from resources.lib.menus import tunes
    tunes.radionet().play_station(url)


####################################################
#---Tools
####################################################
elif action == 'download':
    import json
    from resources.lib.modules import sources
    from resources.lib.modules import downloader
    try:
        downloader.download(name, image, sources.Sources().sourcesResolve(json.loads(source)[0], True))
    except:
        pass

elif action == 'downloadNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().downloads()

elif action == 'libraryNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().library()

elif action == 'toolNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().tools()

elif action == 'searchNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().search()

elif action == 'viewsNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().views()

elif action == 'resetViewTypes':
    from resources.lib.modules import views
    views.clearViews()

elif action == 'addView':
    from resources.lib.modules import views
    views.addView(content)

elif action == 'refresh':
    from resources.lib.modules import control
    control.refresh()

elif action == 'openSettings':
    from resources.lib.modules import control
    control.openSettings(query)

elif action == 'open.Settings.CacheProviders':
    from resources.lib.modules import control
    control.openSettings(query)

elif action == 'artwork':
    from resources.lib.modules import control
    control.artwork()



####################################################
#---Playcount
####################################################
elif action == 'moviePlaycount':
    from resources.lib.modules import playcount
    playcount.movies(imdb, query)

elif action == 'episodePlaycount':
    from resources.lib.modules import playcount
    playcount.episodes(imdb, tvdb, season, episode, query)

elif action == 'tvPlaycount':
    from resources.lib.modules import playcount
    playcount.tvshows(name, imdb, tvdb, season, query)



####################################################
#---Trakt
####################################################
elif action == 'traktManager':
    from resources.lib.modules import trakt
    trakt.manager(name, imdb, tvdb, season, episode)

elif action == 'traktlist':
    from resources.lib.menus import navigator
    navigator.Navigator().traktlist()

elif action == 'authTrakt':
    from resources.lib.modules import trakt
    trakt.authTrakt()
    control.openSettings(query, "plugin.video.mirrorv2")

elif action == 'cachesyncMovies':
    from resources.lib.modules import trakt
    trakt.cachesyncMovies()

elif action == 'cachesyncTVShows':
    from resources.lib.modules import trakt
    trakt.cachesyncTVShows()


####################################################
# PLAYLIST
####################################################
elif action == 'playlistManager':
    from resources.lib.modules import playlist
    playlist.playlistManager(name, url, meta, art)

elif action == 'showPlaylist':
    from resources.lib.modules import playlist
    playlist.playlistShow()

elif action == 'clearPlaylist':
    from resources.lib.modules import playlist
    playlist.playlistClear()

elif action == 'queueItem':
    from resources.lib.modules import control
    control.queueItem()
    if name is None:
        control.notification(title = 35515, message = 35519, icon = 'INFO', sound = False)
    else:
        control.notification(title = name, message = 35519, icon = 'INFO', sound = False)



####################################################
#---Player
####################################################
elif action == 'play':
    from resources.lib.modules import sources
    sources.Sources().play(title, year, imdb, tvdb, season, episode, tvshowtitle, premiered, meta, select)

elif action == 'playItem':
    from resources.lib.modules import sources
    sources.Sources().playItem(title, source)

elif action == 'trailer':
    from resources.lib.modules import trailer
    trailer.Trailer().play(name, url, windowedtrailer)

elif action == 'addItem':
    from resources.lib.modules import sources
    sources.Sources().addItem(title)

elif action == 'alterSources':
    from resources.lib.modules import sources
    sources.Sources().alterSources(url, meta)

elif action == 'random':
    rtype = params.get('rtype')
    if rtype == 'movies':
        from resources.lib.menus import movies
        rlist = movies.Movies().get(url, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'episode':
        from resources.lib.menus import episodes
        rlist = episodes.episodes().get(tvshowtitle, year, imdb, tvdb, season, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'season':
        from resources.lib.menus import episodes
        rlist = episodes.seasons().get(tvshowtitle, year, imdb, tvdb, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=episode"
    elif rtype == 'show':
        from resources.lib.menus import tvshows
        rlist = tvshows.tvshows().get(url, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=season"
    from resources.lib.modules import control
    from random import randint
    import json
    try:
        rand = randint(1,len(rlist))-1
        for p in ['title','year','imdb','tvdb','season','episode','tvshowtitle','premiered','select']:
            if rtype == "show" and p == "tvshowtitle":
                try: r += '&'+p+'='+urllib.quote_plus(rlist[rand]['title'])
                except: pass
            else:
                try: r += '&'+p+'='+urllib.quote_plus(rlist[rand][p])
                except: pass
        try: r += '&meta='+urllib.quote_plus(json.dumps(rlist[rand]))
        except: r += '&meta='+urllib.quote_plus("{}")
        if rtype == "movie":
            try: control.infoDialog(rlist[rand]['title'], control.lang(32536).encode('utf-8'), time=30000)
            except: pass
        elif rtype == "episode":
            try: control.infoDialog(rlist[rand]['tvshowtitle']+" - Season "+rlist[rand]['season']+" - "+rlist[rand]['title'], control.lang(32536).encode('utf-8'), time=30000)
            except: pass
        control.execute('RunPlugin(%s)' % r)
    except:
        control.infoDialog(control.lang(32537).encode('utf-8'), time=8000)


####################################################
#----Library Actions
####################################################
elif action == 'movieToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().add(name, title, year, imdb, tmdb)

elif action == 'moviesToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().range(url)

elif action == 'moviesToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libmovies().silent(url)

elif action == 'tvshowToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().add(tvshowtitle, year, imdb, tvdb)

elif action == 'tvshowsToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().range(url)

elif action == 'tvshowsToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libtvshows().silent(url)

elif action == 'updateLibrary':
    from resources.lib.modules import libtools
    libtools.libepisodes().update(query)

elif action == 'service':
    from resources.lib.modules import libtools
    libtools.libepisodes().service()



####################################################
#---Clear Cache actions
####################################################
elif action == 'cfNavigator':
    from resources.lib.menus import navigator
    navigator.Navigator().cf()

elif action == 'clearAllCache':
    from resources.lib.menus import navigator
    navigator.Navigator().clearCacheAll()

elif action == 'clearSources':
    from resources.lib.menus import navigator
    navigator.Navigator().clearCacheProviders()
    if params['opensettings'] == 'true':
        control.openSettings(query, 'plugin.video.mirrorv2')

elif action == 'clearMetaCache':
    from resources.lib.menus import navigator
    navigator.Navigator().clearCacheMeta()

elif action == 'clearCache':
    from resources.lib.menus import navigator
    navigator.Navigator().clearCache()

elif action == 'clearCacheSearch':
    from resources.lib.menus import navigator
    navigator.Navigator().clearCacheSearch()

elif action == 'clearBookmarks':
    from resources.lib.menus import navigator
    navigator.Navigator().clearBookmarks()



####################################################
#---Provider Source actions
####################################################
elif action == 'openscrapersSettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.openscrapers')


elif action == 'installLiptonscrapers':
    from resources.lib.modules import control
    control.installAddon('script.module.liptonscrapers')
    control.sleep(200)
    control.refresh()

elif action == 'liptonscrapersettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.liptonscrapers')

elif action == 'urlResolver':
    try: import resolveurl
    except: pass
    resolveurl.display_settings()

elif action == 'urlResolverRDTorrent':
    from resources.lib.modules import control
    control.openSettings(query, "script.module.resolveurl")


