# -*- coding: UTF-8 -*-


# Addon Name: Mirrorv2
# Addon id: plugin.video.mirrorv2
# Addon Provider: Cy4Root

import os, base64, sys, urllib2, urlparse
import xbmc, xbmcaddon, xbmcgui

from resources.lib.modules import control
from resources.lib.modules import trakt
from resources.lib.modules import cache


sysaddon = sys.argv[0] ; syshandle = int(sys.argv[1]) ; control.moderator()
artPath = control.artPath() ; addonFanart = control.addonFanart()

imdbCredentials = False if control.setting('imdb.user') == '' else True

traktCredentials = trakt.getTraktCredentialsInfo()
traktIndicators = trakt.getTraktIndicatorsInfo()

queueMenu = control.lang(32065).encode('utf-8')


class navigator:
    ADDON_ID      = xbmcaddon.Addon().getAddonInfo('id')
    HOMEPATH      = xbmc.translatePath('special://home/')
    ADDONSPATH    = os.path.join(HOMEPATH, 'addons')
    THISADDONPATH = os.path.join(ADDONSPATH, ADDON_ID)
    NEWSFILE      = base64.b64decode(b'aHR0cHM6Ly9wYXN0ZWJpbi5jb20vcmF3L1JHWGtkS0Vq')
    LOCALNEWS     = os.path.join(THISADDONPATH, 'whatsnew.txt')
    
    def root(self):
        self.addDirectoryItem(32001, 'movieNavigator', 'movies.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movietheaters') == True:
            self.addDirectoryItem(320222, 'tmdb&url=theaters', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32002, 'tvNavigator', 'tvshows.png', 'DefaultTVShows.png')
        if (traktIndicators == True and not control.setting('tv.widget.alt') == '0') or (traktIndicators == False and not control.setting('tv.widget') == '0'):
            self.addDirectoryItem(32006, 'tvWidget', 'latest-episodes.png', 'DefaultRecentlyAddedEpisodes.png') 
        if self.getMenuEnabled('navi.boxsetsmaster') == True:
            self.addDirectoryItem('BoxSets', 'boxsetsmaster', 'boxsets.png', 'DefaultSets.png')  
        if self.getMenuEnabled('navi.vipbox') == True:
            self.addDirectoryItem('VipBox', 'vipbox', 'vip.png', 'fanart2.gif')
        if self.getMenuEnabled('navi.noting') == False:
            self.addDirectoryItem(32008, 'toolNavigator', 'tools.png', 'DefaultAddonProgram.png')
            self.addDirectoryItem('Scraper Settings', 'openscrapersSettings&query=0.0', 'openscrapers.png', 'DefaultAddonProgram.png')
        downloads = True if control.setting('downloads') == 'true' and (len(control.listDir(control.setting('movie.download.path'))[0]) > 0 or len(control.listDir(control.setting('tv.download.path'))[0]) > 0) else False
        if downloads == True:
            self.addDirectoryItem(32009, 'downloadNavigator', 'downloads.png', 'DefaultFolder.png')
	#self.addDirectoryItem('Providers', 'liptonscrapersettings&query=2.0', 'module.png', 'DefaultAddonService.png', isFolder=False)
        self.addDirectoryItem(32010, 'searchNavigator', 'search.png', 'DefaultFolder.png')
        self.addDirectoryItem('Status', 'newsNavigator', 'icon.gif', 'DefaultAddonProgram.png')
        self.endDirectory()

    def getMenuEnabled(self, menu_title):
        is_enabled = control.setting(menu_title).strip()
        if (is_enabled == '' or is_enabled == 'false'): return False
        return True

#######################################################################

    def news(self):
            message=self.open_news_url(self.NEWSFILE)
            r = open(self.LOCALNEWS)
            compfile = r.read()       
            if len(message)>1:
                    if compfile == message:pass
                    else:
                            text_file = open(self.LOCALNEWS, "w")
                            text_file.write(message)
                            text_file.close()
                            compfile = message
            self.showText('[COLOR yellow]ONLINE STATUS:[/COLOR] [B][COLOR green]GOOD[/COLOR][/B]', compfile)
    def open_news_url(self, url):
            req = urllib2.Request(url)
            req.add_header('User-Agent', 'klopp')
            response = urllib2.urlopen(req)
            link=response.read()
            response.close()
            print link
            return link

    def news_local(self):
            r = open(self.LOCALNEWS)
            compfile = r.read()
            self.showText('[B]Updates and Information[/B]', compfile)

    def showText(self, heading, text):
        id = 10147
        xbmc.executebuiltin('ActivateWindow(%d)' % id)
        xbmc.sleep(500)
        win = xbmcgui.Window(id)
        retry = 50
        while (retry > 0):
            try:
                xbmc.sleep(10)
                retry -= 1
                win.getControl(1).setLabel(heading)
                win.getControl(5).setText(text)
                quit()
                return
            except: pass

#######################################################################

    def movies(self, lite=False):
 	if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32003, 'mymovieliteNavigator', 'mymovies.png', 'DefaultVideoPlaylists.png')
        if self.getMenuEnabled('navi.movieyears') == True:
            self.addDirectoryItem(32012, 'movieYears', 'years.png', 'DefaultMovies.png') 
            self.addDirectoryItem('1950 - 1959', 'movies&url=fiftys', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('1960 - 1969', 'movies&url=sixtys', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('1970 - 1979', 'movies&url=seventys', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('1980 - 1989', 'movies&url=eightys', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('1990 - 1999', 'movies&url=ninetys', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('2000 - 2009', 'movies&url=twothousand', 'years.png', 'DefaultMovies.png')
            self.addDirectoryItem('2010 - 2019', 'movies&url=twothousand2', 'years.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.moviereview') == True:
            self.addDirectoryItem(32623, 'movieReviews', 'reviews.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.moviegenre') == True:
            self.addDirectoryItem(32011, 'movieGenres', 'genres.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.moviepersons') == True:
            self.addDirectoryItem(32013, 'moviePersons', 'people.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movielanguages') == True:
            self.addDirectoryItem(32014, 'movieLanguages', 'languages.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.moviecerts') == True:
            self.addDirectoryItem(32015, 'movieCertificates', 'certificates.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movietrending') == True:
            self.addDirectoryItem(32017, 'movies&url=trending', 'people-watching.png', 'DefaultRecentlyAddedMovies.png')
        if self.getMenuEnabled('navi.moviepopular') == True:
            self.addDirectoryItem(32018, 'movies&url=popular', 'most-popular.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movieviews') == True:
            self.addDirectoryItem(32019, 'movies&url=views', 'most-voted.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movieoscars') == True:
            self.addDirectoryItem(32021, 'movies&url=oscars', 'oscar-winners.png', 'DefaultMovies.png')
        if self.getMenuEnabled('navi.movietheaters') == True:
            self.addDirectoryItem(32022, 'movies&url=theaters', 'in-theaters.png', 'DefaultRecentlyAddedMovies.png')
        if self.getMenuEnabled('navi.moviewidget') == True:
            self.addDirectoryItem(32005, 'movieWidget', 'latest-movies.png', 'DefaultRecentlyAddedMovies.png')
            self.addDirectoryItem(32028, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()


    def mymovies(self, lite=False):
        self.accountCheck()

        if traktCredentials == True and imdbCredentials == True:
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)

        elif traktCredentials == True:
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))

        elif imdbCredentials == True:
            self.addDirectoryItem(32032, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32033, 'movies&url=imdbwatchlist2', 'imdb.png', 'DefaultMovies.png', queue=True)

        if traktCredentials == True:
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'trakt.png', 'DefaultMovies.png', queue=True)

        elif imdbCredentials == True:
            self.addDirectoryItem(32035, 'movies&url=featured', 'imdb.png', 'DefaultMovies.png', queue=True)

        if traktIndicators == True:
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'trakt.png', 'DefaultMovies.png', queue=True)

        self.addDirectoryItem(32039, 'movieUserlists', 'userlists.png', 'DefaultMovies.png')

        if lite == False:
            self.addDirectoryItem(32031, 'movieliteNavigator', 'movies.png', 'DefaultMovies.png')
            self.addDirectoryItem(32028, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()


    def tvshows(self, lite=False):
	if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32004, 'mytvliteNavigator', 'mytvshows.png', 'DefaultVideoPlaylists.png')
        if self.getMenuEnabled('navi.movieyears') == True:
            self.addDirectoryItem('1950 - 1959', 'tvshows&url=fiftyst', 'years.png', 'DefaultTVShows.png')
            self.addDirectoryItem('1960 - 1969', 'tvshows&url=sixtyst', 'years.png', 'DefaultTVShows.png')
            self.addDirectoryItem('1970 - 1979', 'tvshows&url=seventyst', 'years.png', 'DefaultTVShows.png')
            self.addDirectoryItem('1980 - 1989', 'tvshows&url=eightyst', 'years.png', 'DefaultTVShows.png')
            self.addDirectoryItem('1990 - 1999', 'tvshows&url=ninetyst', 'years.png', 'DefaultTVShows.png')
            self.addDirectoryItem('2000 - 2009', 'tvshows&url=twothousandt', 'years.png', 'DefaultTVShows.png')
   	    self.addDirectoryItem('2010 - 2019', 'tvshows&url=twothousandt2', 'years.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvReviews') == True:
            self.addDirectoryItem(32623, 'tvReviews', 'reviews.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvGenres') == True:
            self.addDirectoryItem(32011, 'tvGenres', 'genres.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvNetworks') == True:
            self.addDirectoryItem(32016, 'tvNetworks', 'networks.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvLanguages') == True:
            self.addDirectoryItem(32014, 'tvLanguages', 'languages.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvCertificates') == True:
            self.addDirectoryItem(32015, 'tvCertificates', 'certificates.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvTrending') == True:
            self.addDirectoryItem(32017, 'tvshows&url=trending', 'people-watching.png', 'DefaultRecentlyAddedEpisodes.png')
        if self.getMenuEnabled('navi.tvPopular') == True:
            self.addDirectoryItem(32018, 'tvshows&url=popular', 'most-popular.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvRating') == True:
            self.addDirectoryItem(32023, 'tvshows&url=rating', 'highly-rated.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvViews') == True:
            self.addDirectoryItem(32019, 'tvshows&url=views', 'most-voted.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvAiring') == True:
            self.addDirectoryItem(32024, 'tvshows&url=airing', 'airing-today.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvActive') == True:
            self.addDirectoryItem(32025, 'tvshows&url=active', 'returning-tvshows.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvPremier') == True:
            self.addDirectoryItem(32026, 'tvshows&url=premiere', 'new-tvshows.png', 'DefaultTVShows.png')
        if self.getMenuEnabled('navi.tvAdded') == True:
            self.addDirectoryItem(32006, 'calendar&url=added', 'latest-episodes.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
        if self.getMenuEnabled('navi.tvCalendar') == True:
            self.addDirectoryItem(32027, 'calendars', 'calendar.png', 'DefaultRecentlyAddedEpisodes.png')
            self.addDirectoryItem(32028, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

        self.endDirectory()

    def mytvshows(self, lite=False):
        self.accountCheck()

        if traktCredentials == True and imdbCredentials == True:
            self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')

        elif traktCredentials == True:
            self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))

        elif imdbCredentials == True:
            self.addDirectoryItem(32032, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32033, 'tvshows&url=imdbwatchlist2', 'imdb.png', 'DefaultTVShows.png')

        if traktCredentials == True:
            self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'trakt.png', 'DefaultTVShows.png')

        elif imdbCredentials == True:
            self.addDirectoryItem(32035, 'tvshows&url=trending', 'imdb.png', 'DefaultMovies.png', queue=True)

        if traktIndicators == True:
            self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'trakt.png', 'DefaultTVShows.png', queue=True)
            self.addDirectoryItem(32037, 'calendar&url=progress', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
            self.addDirectoryItem(32038, 'calendar&url=mycalendar', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)

        self.addDirectoryItem(32040, 'tvUserlists', 'userlists.png', 'DefaultTVShows.png')

        if traktCredentials == True:
            self.addDirectoryItem(32041, 'episodeUserlists', 'userlists.png', 'DefaultTVShows.png')

        if lite == False:
            self.addDirectoryItem(32031, 'tvliteNavigator', 'tvshows.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32028, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

        self.endDirectory()

    

    def tools(self):
        self.addDirectoryItem(32043, 'openSettings&query=1.0', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32083, 'providersettings&query=2.0', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32556, 'libraryNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32049, 'viewsNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32050, 'clearSources', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32604, 'clearCacheSearch', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32052, 'clearCache', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32614, 'clearMetaCache', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32613, 'clearAllCache', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32073, 'authTrakt', 'trakt.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32609, 'urlResolver', 'urlresolver.png', 'DefaultAddonProgram.png')

        self.endDirectory()

    def library(self):
        self.addDirectoryItem(32557, 'openSettings&query=5.0', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32558, 'updateLibrary&query=tool', 'library_update.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32559, control.setting('library.movie'), 'movies.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem(32560, control.setting('library.tv'), 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32561, 'moviesToLibrary&url=traktcollection', 'trakt.png', 'DefaultMovies.png')
            self.addDirectoryItem(32562, 'moviesToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png')
            self.addDirectoryItem(32563, 'tvshowsToLibrary&url=traktcollection', 'trakt.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32564, 'tvshowsToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png')

        self.endDirectory()

    def downloads(self):
        movie_downloads = control.setting('movie.download.path')
        tv_downloads = control.setting('tv.download.path')

        if len(control.listDir(movie_downloads)[0]) > 0:
            self.addDirectoryItem(32001, movie_downloads, 'movies.png', 'DefaultMovies.png', isAction=False)
        if len(control.listDir(tv_downloads)[0]) > 0:
            self.addDirectoryItem(32002, tv_downloads, 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        self.endDirectory()

    def radio(self):
        try:
            self.addDirectoryItem('localstations', 'radio&url=localstations', 'podcast.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem('recommended', 'radio&url=recommended', 'podcast.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem('tophundred', 'radio&url=tophundred', 'podcast.png', 'DefaultVideoPlaylists.png')
	    self.addDirectoryItem('country', 'radioCat&url=country', 'podcast.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem('language', 'radioCat&url=language', 'podcast.png', 'DefaultVideoPlaylists.png')
	    self.endDirectory()
        except Exception:
            pass

    def boxsetsmaster(self):
        self.addDirectoryItem('[COLOR=gold]BoxSets Collection [/COLOR]','tmdb', 'boxsets.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem(32034, 'movieimdbUserLists', 'imdb.png', 'DefaultMovies.png')
        self.addDirectoryItem(32635,  'boxsetsNavigator', 'movies.png', 'DefaultMovies.png')
	self.addDirectoryItem(30324, 'tvshows&url=tvshowcoll', 'tvshows.png', 'DefaultVideoPlaylists.png')					
	self.addDirectoryItem(32092, 'holidaysNavigator', 'calendar.png', 'DefaultMovies.png')
	self.addDirectoryItem(32094, 'collections&url=disneymovies2', 'kids.png', 'DefaultMovies.png')
	self.addDirectoryItem(30323, 'kidsboxsets', 'kids.png', 'DefaultMovies.png')
        self.addDirectoryItem(32091, 'actorNavigator', 'genres.png', 'DefaultMovies.png')
        self.addDirectoryItem(32641, 'mysupermvNavigator', 'fitness.png', 'DefaultMovies.png')	
        self.addDirectoryItem('[COLOR=darkorange]BoxSets Selection[/COLOR]','tmdb', 'boxsets.png', 'DefaultVideoPlaylists.png')
	self.addDirectoryItem(32632, 'collections&url=moviemirror', 'tmdb2.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem(30335, 'movieimdbUserLists', 'imdb.png', 'DefaultMovies.png')
	self.addDirectoryItem(32093, 'collections&url=netflixmovies', 'tmdb2.png', 'DefaultMovies.png')
	self.addDirectoryItem(32633, 'collections&url=kidsboxcollection2', 'kids.png', 'DefaultVideoPlaylists.png')
	self.addDirectoryItem(30325, 'genremovies', 'genres.png', 'DefaultVideoPlaylists.png')
        self.endDirectory()

    def imdbLists(self):
        self.addDirectoryItem('Explore Keywords(Movies)', 'movieExploreKeywords', 'imdb.png', 'DefaultMovies.png')
        self.addDirectoryItem('Explore Keywords(TV Shows)', 'tvshowExploreKeywords', 'imdb.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Explore UserLists(Movies)', 'movieimdbUserLists', 'imdb.png', 'DefaultMovies.png')
        self.addDirectoryItem('Explore UserLists(TV Shows)', 'tvshowimdbUserLists', 'imdb.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Hella LifeTime & HallMark Movies', 'hellaLifeTimeHallMark', 'userlists.png', 'DefaultVideoPlaylists.png')
        self.endDirectory()

    def genremovies(self):
        self.addDirectoryItem('Horror (2019 - 2000)','movies&url=tophorr', 'movies.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem('Horror (Top 50 1980s)', 'collections&url=horror80s', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30326, 'movies&url=collectionshackers', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30327, 'movies&url=collectionscrime', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30328, 'movies&url=collectionsprison', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30329, 'collections&url=musical', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30330, 'movies&url=collectionsromance', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(30331, 'movies&url=collectionswestern', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
	self.addDirectoryItem(30338, 'movies&url=collectionsinterhindi', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
	self.addDirectoryItem(30336, 'movies&url=collectionsforeign', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
	self.addDirectoryItem(30337, 'movies&url=collectionspsychological', 'imdb.png', 'DefaultRecentlyAddedMovies.png')
        self.endDirectory()


    def iptv(self):
        self.addDirectoryItem('World Tv', 'worldtv', 'networks.png', 'fanart.jpg')
        self.addDirectoryItem('AllTV', 'alltv', 'networks.png', 'fanart.jpg')
        self.addDirectoryItem('CinemaTV', 'cinematv', 'networks.png', 'fanart.jpg')
	self.addDirectoryItem('FaithTV', 'faithtv', 'networks.png', '')
	self.addDirectoryItem('LodgeTV', 'lodgetv', 'networks.png', '')
	self.addDirectoryItem('AcroTV',  'arconai_cable',  'networks.png',  'DefaultTVShows.png')
	self.addDirectoryItem('MyTV',  'mytv',  'networks.png',  'DefaultTVShows.png')     
	self.endDirectory()

    def vipbox(self):
        self.addDirectoryItem('oneclick', 'oneclick', 'networks.png', 'DefaultRecentlyAddedMovies.png')   
        self.addDirectoryItem('random', 'random&rtype=movies&url=popular', 'library_update.png', 'DefaultRecentlyAddedMovies.png')   
	self.addDirectoryItem('Iptv', 'iptvNavigator', 'networks.png', 'fanart.jpg') 
        self.addDirectoryItem('Sport&Tv', 'sportplugins', 'networks.png', 'fanart.jpg')  
        self.addDirectoryItem('Documentary', 'docuNavigator', 'channels.png', 'DefaultMovies.png')
   	self.addDirectoryItem('Radio', 'radioNavigator', 'airing-today.png', 'DefaultVideoPlaylists.png')
 	self.addDirectoryItem('Music Choice', 'mclist', 'channels.png', 'DefaultMovies.png')
        self.addDirectoryItem('kidscorner', 'kidscorner', 'kids.png', 'DefaultMovies.png')
        self.addDirectoryItem('fitness', 'fitness', 'fitness.png', 'DefaultMovies.png')
        self.addDirectoryItem('legends', 'legends', 'legends.png', 'DefaultMovies.png')
        self.addDirectoryItem('Youtube', 'mytube', 'youtube.png', 'youtubemenu.png') #(root.txt)  
	if self.getMenuEnabled('navi.xxx') == True:
            self.addDirectoryItem('[COLOR pink]Adult\'s Only[/COLOR]', 'xxx', 'highly-rated.png', 'DefaultTVShows.png')  
        self.endDirectory()

    def oneclickmovies(self):
    	self.addDirectoryItem(33003, '1click', 'debrid.png', 'debrid.png')  
        self.addDirectoryItem(33002, '1kmovies', '1k.jpg', 'DefaultMovies.png')
        self.addDirectoryItem(33004, 'dtsmovies', 'dts.jpg', 'debrid.png')  
        self.addDirectoryItem(33001, '4kmovies', '4k.jpeg', 'DefaultMovies.png')
        self.addDirectoryItem(33020, 'vipclick', 'vip.png', 'DefaultMovies.png')
	if self.getMenuEnabled('navi.1clicknl') == True:
            self.addDirectoryItem(33006, 'nlmovie', 'dutch.png', 'debrid.png')  
            self.addDirectoryItem(30332, 'nltvshow', 'dutch.png', 'debrid.png')  
        self.addDirectoryItem(33005, 'kids', 'kidscorner.png', 'kidscorner.png')  
        self.endDirectory()
	
    def holidaysBoxset(self):
        self.addDirectoryItem(32095, 'collections&url=xmasmovies2', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32096, 'collections&url=eastermovies', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32097, 'collections&url=halloweenmovies', 'tmdb2.png', 'DefaultRecentlyAddedMovies.png')
        self.endDirectory()


    def providersettings(self):
        self.addDirectoryItem('[COLOR=gold]Under the settings menu you can switch from Providers (Click Here) [/COLOR]','openSettings&query=1.0', 'tools.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem('OpenScraper Settings (Default)', 'openscrapersSettings&query=0.0', 'openscrapers.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('LiptonModule Settings', 'liptonscrapersettings&query=0.0', 'module.png', 'DefaultAddonProgram.png')
        self.endDirectory()

    def search(self):
        self.addDirectoryItem(32001, 'movieSearch', 'search.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvSearch', 'search.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32029, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
        self.addDirectoryItem(32030, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')

        self.endDirectory()

    def views(self):
        try:
            control.idle()

            items = [ (control.lang(32001).encode('utf-8'), 'movies'), (control.lang(32002).encode('utf-8'), 'tvshows'), (control.lang(32054).encode('utf-8'), 'seasons'), (control.lang(32038).encode('utf-8'), 'episodes') ]

            select = control.selectDialog([i[0] for i in items], control.lang(32049).encode('utf-8'))

            if select == -1: return

            content = items[select][1]

            title = control.lang(32059).encode('utf-8')
            url = '%s?action=addView&content=%s' % (sys.argv[0], content)

            poster, banner, fanart = control.addonPoster(), control.addonBanner(), control.addonFanart()

            item = control.item(label=title)
            item.setInfo(type='Video', infoLabels = {'title': title})
            item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})
            item.setProperty('Fanart_Image', fanart)

            control.addItem(handle=int(sys.argv[1]), url=url, listitem=item, isFolder=False)
            control.content(int(sys.argv[1]), content)
            control.directory(int(sys.argv[1]), cacheToDisc=True)

            from resources.lib.modules import views
            views.setView(content, {})
        except:
            return


    def accountCheck(self):
        if traktCredentials == False and imdbCredentials == False:
            control.idle()
            control.infoDialog(control.lang(32042).encode('utf-8'), sound=True, icon='WARNING')
            sys.exit()


    def infoCheck(self, version):
        try:
            control.infoDialog('', control.lang(32074).encode('utf-8'), time=5000, sound=False)
            return '1'
        except:
            return '1'


    def clearCache(self):
        control.idle()
        yes = control.yesnoDialog(control.lang(32056).encode('utf-8'), '', '')
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear()
        control.infoDialog(control.lang(32057).encode('utf-8'), sound=True, icon='INFO')

    def clearCacheMeta(self):
        control.idle()
        yes = control.yesnoDialog(control.lang(32056).encode('utf-8'), '', '')
        if not yes: return
        from resources.lib.modules import cache

        cache.cache_clear_meta()
        control.infoDialog(control.lang(32057).encode('utf-8'), sound=True, icon='INFO')

    def clearCacheProviders(self):
        control.idle()
        yes = control.yesnoDialog(control.lang(32056).encode('utf-8'), '', '')
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_providers()
        control.infoDialog(control.lang(32057).encode('utf-8'), sound=True, icon='INFO')

    def clearCacheSearch(self):
        control.idle()
        yes = control.yesnoDialog(control.lang(32056).encode('utf-8'), '', '')
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_search()
        control.infoDialog(control.lang(32057).encode('utf-8'), sound=True, icon='INFO')

    def clearCacheAll(self):
        control.idle()
        yes = control.yesnoDialog(control.lang(32056).encode('utf-8'), '', '')
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_all()
        control.infoDialog(control.lang(32057).encode('utf-8'), sound=True, icon='INFO')

    def addDirectoryItem(self, name, query, thumb, icon, context=None, queue=False, isAction=True, isFolder=True):
        try: name = control.lang(name).encode('utf-8')
        except: pass
        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
        thumb = os.path.join(artPath, thumb) if not artPath == None else icon
        cm = []
        if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
        if not context == None: cm.append((control.lang(context[0]).encode('utf-8'), 'RunPlugin(%s?action=%s)' % (sysaddon, context[1])))
        item = control.item(label=name)
        item.addContextMenuItems(cm)
        item.setArt({'icon': thumb, 'thumb': thumb})
        if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
        control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)

    def Toggle_Dbird(self):
        HMMMPATH = xbmc.translatePath(os.path.join('special://home/addons/', 'script.module.resolveurl'))
        ummmDialog = xbmcgui.Dialog()
        if not os.path.exists(HMMMPATH):
            ummmDialog("ummmm", "There was a error loading script.module.resolveurl.")
            sys.exit()
        try:
            if xbmcaddon.Addon('script.module.resolveurl').getSetting('RealDebridResolver_enabled') != 'true':
                try:
                    xbmcaddon.Addon('script.module.resolveurl') .setSetting(id='RealDebridResolver_enabled', value='true')
                    control.refresh()
                    ummmDialog.notification('[B]Turn On[/B] RealDebridResolver', 'Done, Setting [B]Enabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except: pass
            elif xbmcaddon.Addon('script.module.resolveurl').getSetting('RealDebridResolver_enabled') != 'false':
                try:
                    xbmcaddon.Addon('script.module.resolveurl') .setSetting(id='RealDebridResolver_enabled', value='false')
                    control.refresh()
                    ummmDialog.notification('[B]Turn Off[/B] RealDebridResolver', 'Done, Setting [B]Disabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except: pass
        except:
            pass


    def Toggle_Adbird(self):
        HMMMPATH = xbmc.translatePath(os.path.join('special://home/addons/', 'script.module.resolveurl'))
        ummmDialog = xbmcgui.Dialog()
        if not os.path.exists(HMMMPATH):
            ummmDialog("ummmm", "There was a error loading script.module.resolveurl.")
            sys.exit()
        try:
            if xbmcaddon.Addon('script.module.resolveurl').getSetting('AllDebridResolver_enabled') != 'true':
                try:
                    xbmcaddon.Addon('script.module.resolveurl') .setSetting(id='AllDebridResolver_enabled', value='true')
                    control.refresh()
                    ummmDialog.notification('[B]Turn On[/B] AllDebridResolver', 'Done, Setting [B]Enabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except: pass
            elif xbmcaddon.Addon('script.module.resolveurl').getSetting('AllDebridResolver_enabled') != 'false':
                try:
                    xbmcaddon.Addon('script.module.resolveurl') .setSetting(id='AllDebridResolver_enabled', value='false')
                    control.refresh()
                    ummmDialog.notification('[B]Turn Off[/B] AllDebridResolver', 'Done, Setting [B]Disabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except: pass
        except:
            pass


    def Toggle_PreMe(self):
        HMMMPATH = xbmc.translatePath(os.path.join('special://home/addons/', 'script.module.resolveurl'))
        ummmDialog = xbmcgui.Dialog()
        if not os.path.exists(HMMMPATH):
            ummmDialog("ummmm", "There was a error loading script.module.resolveurl.")
            sys.exit()
        try:
            if xbmcaddon.Addon('script.module.resolveurl').getSetting('PremiumizeMeResolver_enabled') != 'true':
                try:
                    xbmcaddon.Addon('script.module.resolveurl').setSetting(id='PremiumizeMeResolver_enabled', value='true')
                    control.refresh()
                    ummmDialog.notification('[B]Turn On[/B] PremiumizeMeResolver', 'Done, Setting [B]Enabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except:
                    pass
            elif xbmcaddon.Addon('script.module.resolveurl').getSetting('PremiumizeMeResolver_enabled') != 'false':
                try:
                    xbmcaddon.Addon('script.module.resolveurl').setSetting(id='PremiumizeMeResolver_enabled', value='false')
                    control.refresh()
                    ummmDialog.notification('[B]Turn Off[/B] PremiumizeMeResolver', 'Done, Setting [B]Disabled[/B].', xbmcgui.NOTIFICATION_INFO, 5000)
                except:
                    pass
        except:
            pass

    def endDirectory(self):
        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc=True)



