# -*- coding: utf-8 -*-
import xbmc
import xbmcaddon

ADDON = xbmcaddon.Addon()
ADDON_NAME = ADDON.getAddonInfo('name')

def log(message, level=xbmc.LOGINFO):
    xbmc.log("[%s] %s" % (ADDON_NAME, message), level)

def check_osd(monitor):
    timeout = ADDON.getSettingInt('hide.timeout')
    
    if timeout == 0:
        return
    
    window = "videoosd"
    
    if xbmc.getCondVisibility("Window.IsActive(%s)" % window):
        while xbmc.getCondVisibility("Window.IsActive(%s)" % window):
            if monitor.abortRequested():
                return
            
            if xbmc.getCondVisibility("System.IdleTime(%s)" % timeout):
                xbmc.executebuiltin("Dialog.Close(%s)" % window)
                log("OSD closed after %s seconds of inactivity" % timeout)
                return
            
            if monitor.waitForAbort(0.5):
                return

def service_entry_point():
    monitor = xbmc.Monitor()
    
    log("Service started")
    
    while not monitor.abortRequested():
        if monitor.waitForAbort(1):
            break
        
        if not xbmc.Player().isPlaying():
            continue
        
        if not ADDON.getSettingBool('hide.enable'):
            continue
        
        try:
            check_osd(monitor)
        except Exception as e:
            log("Error: %s" % str(e), xbmc.LOGERROR)
    
    log("Service stopped")

if __name__ == '__main__':
    service_entry_point()
