import os
import xbmc
import threading

from xbmc import Monitor
from six.moves import urllib_request

from lt2http.daemon import shutdown, update
from lt2http.config import init, LT2HTTP_HOST


class Lt2HttpMonitor(Monitor):
    def __init__(self):
        self._closing = threading.Event()
        self._reboot = False
        Monitor.__init__(self)

    def __str__(self):
        return 'Lt2HttpMonitor'

    @property
    def closing(self):
        return self._closing

    def restart(self):
        try:
            init()
            urllib_request.urlopen("%s/restart" % LT2HTTP_HOST)
        except:
            pass

    def reboot(self, val=None):
        if val is not None:
            self._reboot = val

        return self._reboot

    def onAbortRequested(self):
        # Only when closing Kodi
        if self.abortRequested():
            xbmc.executebuiltin("Dialog.Close(all, true)")
            shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(0)
                pass

    def onSettingsChanged(self):
        try:
            init()
            update()
        except:
            pass

    def onNotification(self, sender, method, data):
        if method and "lt2http_restart" in method:
            self.restart()
            self.reboot(True)

            return
