import threading
from lt2http.logger import log
from lt2http.monitor import Lt2HttpMonitor
from lt2http.daemon import lt2http_thread

import xbmc

def run():
    # Make sure the XBMC jsonrpc server is started.
    xbmc.startServer(xbmc.SERVER_JSONRPCSERVER, True)

    # Make the monitor
    monitor = Lt2HttpMonitor()

    threads = [
        threading.Thread(target=lt2http_thread, args=[monitor])  # lt2http thread
    ]

    for t in threads:
        t.daemon = True
        t.start()

    # XBMC loop
    while not monitor.abortRequested():
        xbmc.sleep(1000)

    try:
        monitor.onAbortRequested()
    except:
        pass

    log.info("lt2http: exiting lt2http")
