from xbmctorrent.plugin import plugin


def ensure_magnet(uri):
    if not uri.startswith("magnet:"):
        uri = get_magnet(uri)
    return uri


def display_name(magnet_uri):
    import urlparse
    from xbmctorrent.utils import first
    magnet_args = urlparse.parse_qs(magnet_uri.replace("magnet:?", ""))
    return first(magnet_args.get("dn", []))


@plugin.route("/play/<uri>", options={"pulsar": "0"})
@plugin.route("/play/<uri>/<index>", name="play_file", options={"pulsar": "0"})
@plugin.route("/play/pulsar/<uri>", name="play_with_pulsar", options={"pulsar": "1"})
def play(uri, pulsar, index=None):
    if not uri.startswith("http://") and not uri.startswith("https://") and not uri.startswith("magnet:"):
        with open(uri, 'rb') as file:
            torrent_data = file.read()

        from bencode import bdecode
        uri = generate_magnet(bdecode(torrent_data))

    if int(pulsar):
        from urllib import urlencode
        plugin.set_resolved_url("plugin://plugin.video.pulsar/play?%s" % urlencode({"uri": uri}))
    else:
        from xbmctorrent.player import TorrentPlayer
        TorrentPlayer().init(uri, index).loop()


def get_magnet(url):
    from bencode import bdecode
    from xbmctorrent.utils import url_get

    return generate_magnet(bdecode(url_get(url)))


def generate_magnet(metadata, dn=None):
    import hashlib
    import base64
    import urllib
    from bencode import bencode

    tr = []
    if "announce-list" in metadata:
        tmp = metadata["announce-list"]
        if isinstance(tmp, list):
            for i in tmp:
                if isinstance(i, list):
                    tr += i
                else:
                    tr.append(i)
    if "announce" in metadata and not metadata["announce"] in tr:
        tr.append(metadata["announce"])

    params = {
        "dn": dn or metadata["info"].get("name", None),
        "tr": tr
    }

    b32hash = base64.b32encode(hashlib.sha1(bencode(metadata["info"])).digest())
    return "magnet:?%s&%s" % ("xt=urn:btih:%s" % b32hash, urllib.urlencode(params, True))
