#!/usr/bin/python
# -*- coding: utf-8 -*-

from xbmctorrent import plugin
from xbmctorrent.scrapers import scraper
from xbmctorrent.caching import cached_route, CACHE_DIR
from xbmctorrent.utils import ensure_fanart

BASE_URL = "http://torrents3d.ru/"
HEADERS = {
    "Referer": BASE_URL,
    'Accept': 'text/html, application/xml, application/xhtml+xml, image/png, image/jpeg, image/gif, image/x-xbitmap, */*',
    'Accept-Language': 'ru-RU,ru;q=0.9,en;q=0.8',
    'Accept-Encoding': 'gzip,deflate,sdch'
}

CATEGORIES = [
    (u"3D Фильмы", 7, [
        (u"Фильмы среднего качества", 6),
        (u"Анаглиф", 27),
    ]),
    (u"3D Мультфильмы", 28, [
        (u"Мультфильмы среднего качества", 29),
        (u"Анаглиф", 30),
    ]),
    (u"IMAX Документалки", 24),
    (u"Документальные фильмы", 36, [
        (u"Анаглиф", 31),
    ]),
    (u"3D шоу", 32),
    (u"Без черных полос (На весь экран)", 41),
]

# Cache TTLs
DEFAULT_TTL = 300  # 5 min
PAGE_SIZE = 50
SBS_FLAGS = ["SideBySide", "SBS"]
TAB_FLAGS = ["OverUnder", "OU"]

_cookiejar = None


def udec(x):
    return x.decode('utf-8')


def uenc(x):
    return x.encode('utf-8')


def url_get(url, params={}, headers={}, post=None):
    global _cookiejar
    import urllib2
    from xbmctorrent.utils import url_get as url_get_origin

    if not _cookiejar:
        import os
        import cookielib
        import xbmcvfs

        sid_file = os.path.join(CACHE_DIR, 'torrents3d.cookies.dat')
        _cookiejar = cookielib.MozillaCookieJar(sid_file)

        if not xbmcvfs.exists(sid_file):
            _cookiejar.save()

        _cookiejar.load()

    cookie_handler = urllib2.HTTPCookieProcessor(_cookiejar)
    result = url_get_origin(url, params, headers, post, handlers=[cookie_handler])
    _cookiejar.save()

    return result


@scraper("Torrents3D.ru", "%s/images/logo/dyz_logo.gif" % BASE_URL, plugin.get_setting("t3d_enabled", bool))
@plugin.route("/t3d/index")
@ensure_fanart
def torrents3d_index():
    yield {"label": u"[COLOR FFFFFF00][ Поиск ][/COLOR]", "path": plugin.url_for("torrents3d_search")}

    def make_cats(root, prefix=""):
        for cat in root:
            yield {
                "label": "%s%s" % (prefix, cat[0]),
                "path": plugin.url_for("torrents3d_page", section=cat[1], page=0),
            }
            if len(cat) > 2:
                for entry in make_cats(cat[2], prefix="%s    " % prefix):
                    yield entry

    for cat in make_cats(CATEGORIES):
        yield cat


@plugin.route("/t3d/page/<section>/<page>")
@cached_route(ttl=DEFAULT_TTL, content_type="movies")
@ensure_fanart
def torrents3d_page(section, page):
    import re
    from bs4 import BeautifulSoup
    from urlparse import urljoin

    page = int(page)
    html_data = url_get(urljoin(BASE_URL, "section/%s/%s/" % (section, PAGE_SIZE * page)), headers=HEADERS)
    soup = BeautifulSoup(html_data, "html5lib")
    regexp = re.compile("tr-(\d+)")
    nodes = soup.findAll("tr", id=regexp)
    print len(nodes)

    for node in nodes:
        tds = node.findAll("td")
        if len(tds) < 5:
            continue
        size, seeds = map(lambda x: x.text.strip(), tds[1:3])
        article_node = tds[0]
        article_href = article_node.find("a", class_="tt-text")
        stereo, title = _torrents3d_cleantitle(article_href.text)
        text = "[%s] %s (%s S:%s)" % (stereo, title, size.replace("&nbsp;", " "), seeds)
        yield {
            "label": text,
            "path": plugin.url_for("torrents3d_play", article=article_href["id"][3:]),
            "is_playable": True,
            "info": {
                "title": title
            }
        }

    if len(nodes) == PAGE_SIZE:
        next_page = {
            "label": u"[COLOR FFFFFF00][Далее >>][/COLOR]",
            "path": plugin.url_for("torrents3d_page", section=section, page=page + 1),
            "is_playable": False,
        }
        yield next_page


@plugin.route("/t3d/play/<article>")
def torrents3d_play(article):
    import xbmcgui
    from bs4 import BeautifulSoup
    from contextlib import closing
    from urlparse import urljoin
    from xbmctorrent.magnet import generate_magnet
    from xbmctorrent.utils import SafeDialogProgress

    article = int(article)

    with closing(SafeDialogProgress(delay_close=0)) as dialog:
        dialog.create(plugin.name)
        dialog.update(percent=0, line1=u"Получение информации о релизе...", line2="", line3="")

        url = urljoin(BASE_URL, "article/%d" % article)

        try:
            html_data = url_get(url, headers=HEADERS)
            soup = BeautifulSoup(html_data, "html5lib")
            torrent_href = soup.find("a", class_="genmed")

            if not torrent_href:
                dialog.update(percent=50, line2=u"Требуется авторизация. Авторизация...")

                if not plugin.get_setting("t3d_login") and not plugin.get_setting("t3d_passwd"):
                    plugin.notify("Проверьте настройки авторизации.", delay=15000)
                    return

                html_data = _torrents3d_login(url)
                soup = BeautifulSoup(html_data, "html5lib")
                torrent_href = soup.find("a", class_="genmed")

            if not torrent_href:
                xbmcgui.Dialog().ok(plugin.name, "Авторизация неудалась. Проверьте настройки авторизации.")
                return

            dialog.update(percent=100, line2=u"Обработка данных.")

            from bencode import bdecode

            title = "[%s] %s" % _torrents3d_cleantitle(soup.find("a", class_="tt-text").text)
            torrent_data = url_get(torrent_href["href"], headers=HEADERS)
            metadata = bdecode(torrent_data)

            plugin.redirect(plugin.url_for("play", uri=generate_magnet(metadata, uenc(title))))

        except:
            plugin.log.error("Cannot get data from remote server")
            xbmcgui.Dialog().ok(plugin.name, u"Не удалось получить данные от сервера")
            return


@plugin.route("/t3d/search")
def torrents3d_search():
    query = plugin.request.args.get("query")
    if query:
        query = query[0]
    else:
        query = plugin.keyboard("", "Torrents3D.ru - Search")
    if query:
        plugin.redirect(plugin.url_for("torrents3d_resuls", query=query, page=0))


@plugin.route("/t3d/results/<query>/<page>")
@cached_route(ttl=DEFAULT_TTL)
@ensure_fanart
def torrents3d_resuls(query, page):
    import re
    from bs4 import BeautifulSoup
    from urlparse import urljoin
    from xbmctorrent.utils import url_get

    page = int(page)
    params = {"nm": query, "start": page * PAGE_SIZE}

    html_data = url_get(urljoin(BASE_URL, "tracker.php"), params=params, headers=HEADERS)
    soup = BeautifulSoup(html_data, "html5lib")
    nodes = soup.findAll("tr", id=re.compile("tor_(\d+)"))

    for node in nodes:
        download_node = node.find("a", class_="tr-dl")
        # skip closed
        if not download_node:
            continue

        article_href = node.find("a", class_="genmed")["href"]
        size = download_node.text.replace("&nbsp;", " ").strip()
        title, _, _, seeds, peers, _ = map(lambda x: x.text.strip(), node.findAll("td")[3:])
        text = "[COLOR FFFFFFCC][%s][/COLOR] %s (%s S:%s P:%s)" % (_torrents3d_cleantitle(title) + (size, seeds, peers))
        yield {
            "label": text,
            "path": plugin.url_for("torrents3d_play", article=re.search(".*\/(\d+)\/", article_href).group(1)),
            "is_playable": True,
        }

    if len(nodes) == PAGE_SIZE:
        next_page = {
            "label": u"[COLOR FFFFFF00][Далее >>][/COLOR]",
            "path": plugin.url_for("torrents3d_resuls", query=query, page=page + 1),
            "is_playable": False,
        }
        yield next_page


def _torrents3d_login(referer=BASE_URL):
    from urlparse import urljoin

    HEADERS["Referer"] = referer
    HEADERS["Origin"] = BASE_URL
    HEADERS["Content-Type"] = "application/x-www-form-urlencoded"

    values = {
        "login_username": plugin.get_setting("t3d_login"),
        "login_password": plugin.get_setting("t3d_passw"),
        "autologin": 1,
        "login": "Вход"
    }

    html_data = url_get(urljoin(BASE_URL, "login.php"), post=values, headers=HEADERS)

    HEADERS["Referer"] = BASE_URL
    del HEADERS["Origin"]

    return html_data


def _torrents3d_cleantitle(title):
    title = title.strip()
    k1 = title.rfind("]")
    k2 = title.rfind("[")

    main = title[:k2 - 1]
    details = title[k2 + 1:k1 - 1]
    year = details[:4]

    stereo = "BD3D"
    is_sbs = any(flag in title for flag in SBS_FLAGS)
    is_tab = any(flag in title for flag in TAB_FLAGS)

    if is_sbs or is_tab:
        stereo = "F"
        if "Anamorph" in title:
            stereo = "H"
        if is_sbs:
            stereo = "[COLOR FF00FFFF]%sSBS[/COLOR]" % stereo
        elif is_tab:
            stereo = "[COLOR FF00FF00]%sTAB[/COLOR]" % stereo

    elif "Interlaced" in title:
        stereo = "Interlaced"

    elif "Anaglyph" in title:
        if "green'magenta" in title:
            stereo = "[COLOR FF00FF00]G[/COLOR]'[COLOR FFFF00FF]M[/COLOR]"
        elif "red'cyan" in title:
            stereo = "[COLOR FFFF0000]R[/COLOR]'[COLOR FF00FFFF]C[/COLOR]"
        else:
            stereo = "Anaglyph"

    n1 = main.rfind(")")
    if n1 >= 0:
        main = main[:main[:n1 - 1].rfind("(") - 1]

    n1 = main.find("/")
    if n1 >= 0:
        main = "[COLOR FFFFFFFF][B]%s[/B][/COLOR] / %s" % (main[:n1 - 1].strip(), main[n1 + 1:].strip())
    else:
        main = "[COLOR FFFFFFFF][B]%s[/B][/COLOR]" % main.strip()

    return stereo, "%s (%s)" % (main, year)
