# -*- coding: utf-8 -*-

import sys
import os
import xbmc
import xbmcplugin
import xbmcvfs
import urllib
from urlparse import urljoin

REPO_PACKAGE_DIR = "special://home/addons/packages/"
REPO_INSTALL_DIR = "special://home/addons/"


class AddonInstaller:

    def __init__(self, data_dir, zip=True):
        self.data_dir = data_dir
        self.zip = zip
        self.handle = int(sys.argv[1])

    def process(self, action, package, version):
        success = False
        if "install" == action:
            success = self._install(package, version)
        elif "uninstall" == action:
            success = self._uninstall(package)

        xbmc.executebuiltin("UpdateLocalAddons")
        xbmcplugin.endOfDirectory(self.handle, success)

    def _install(self, package, version):
        packageFile = self._download(urljoin(self.data_dir, "%s/%s-%s.zip" % (package, package, version)))
        if packageFile:
            from zipfile import is_zipfile

            if not is_zipfile(packageFile):  # bad archive
                return False

            self.log("Installing addon: %s, version: %s" % (package, version), level=xbmc.LOGNOTICE)

            newAddonDir = os.path.join(xbmc.translatePath(REPO_INSTALL_DIR), package)
            if xbmcvfs.exists(newAddonDir):  # update
                self._rmtree(newAddonDir)

            return self._extract(packageFile)
        return False

    def _uninstall(self, package):
        addonDir = os.path.join(xbmc.translatePath(REPO_INSTALL_DIR), package)
        if xbmcvfs.exists(addonDir):
            self._rmtree(addonDir, removeSelf=True)
        return False

    def _download(self, url, destination=REPO_PACKAGE_DIR):
        destination = os.path.join(xbmc.translatePath(destination), os.path.basename(url))
        if not xbmcvfs.exists(destination):
            destination, h = urllib.urlretrieve(url, destination)
        return destination

    def _extract(self, filename, destination=REPO_INSTALL_DIR):
        from zipfile import ZipFile
        with ZipFile(filename, "r") as zip:
            zip.extractall(xbmc.translatePath(destination))
        return True

    def _rmtree(self, directory, removeSelf=False):
        self.log("Processing folder %s" % directory, level=xbmc.LOGDEBUG)

        dirs, files = xbmcvfs.listdir(directory)
        for f in files:
            fileName = os.path.join(directory, f)
            self.log(" -- delete %s" % fileName, level=xbmc.LOGDEBUG)
            xbmcvfs.delete(fileName)
        for d in dirs:
            self._rmtree(os.path.join(directory, d), removeSelf=True)
        if removeSelf:
            self.log(" -- delete %s" % directory, level=xbmc.LOGDEBUG)
            xbmcvfs.rmdir(directory)

    def log(self, message, level=xbmc.LOGNOTICE):
        xbmc.log("[%s]: %s" % (self.__class__.__name__, message), level=xbmc.LOGDEBUG)


def get_params():
    param = []
    paramstring = sys.argv[2]

    if len(paramstring) >= 2:
        params = sys.argv[2]
        cleanedparams = params.replace("?", "")
        if (params[len(params) - 1] == "/"):
            params = params[0:len(params) - 2]
        pairsofparams = cleanedparams.split("&")
        param = {}
        for i in range(len(pairsofparams)):
            splitparams = {}
            splitparams = pairsofparams[i].split("=")
            if (len(splitparams)) == 2:
                param[splitparams[0]] = splitparams[1]

    return param


def invoke_installer():
    params = get_params()

    if "action" in params and params["action"] in ("install", "update", "uninstall") \
            and "package" in params and "version" in params:
        action, package, version = [params.get(k) for k in ["action", "package", "version"]]

        if action and package and version:
            import xml.etree.ElementTree as ET
            addon_path = os.path.join(xbmc.translatePath(REPO_INSTALL_DIR), package)
            xml = ET.parse(os.path.join(addon_path, "addon.xml"))
            repository_source = (ext for ext in xml.findall("extension") if
                                 ext.get("point") == "xbmc.addon.repository").next()
            datadir = repository_source.find("datadir").text
            AddonInstaller(datadir).process(action, package, version)
            sys.exit(0)
