# -*- coding: utf-8 -*-

import re
import fnmatch
import urllib2
from xbmctorrent import plugin
from xbmctorrent.caching import shelf
from xbmctorrent.common import RESOURCES_PATH

PAC_URL = "http://antizapret.prostovpn.org/proxy.pac"
CACHE = 24 * 3600  # 24 hour caching

_config = {}
_custom_hosts = []


def config():
    global _config
    if not _config:
        with shelf("xbmctorrent.antizapret.pac_config", ttl=CACHE) as pac:
            if not pac.get("pac"):
                plugin.log.info("Fetching Antizapret PAC file")
                try:
                    data = urllib2.urlopen(PAC_URL).read()
                except:
                    data = ""

                pac["pac"] = {
                    "server": None,
                    "domains": []
                }
                r = re.search(r"\"PROXY (.*); DIRECT", data)
                if not r:  # If antizapret bloked then read local copy
                    import os
                    with open(os.path.join(RESOURCES_PATH, "proxy.pac"), "r") as pacfile:
                        data = pacfile.read()

                r = re.search(r"\"PROXY (.*); DIRECT", data)
                if r:
                    pac["pac"]["server"] = r.group(1)
                    pac["pac"]["domains"] = map(lambda x: x.replace(r"\Z(?ms)", "").replace("\\", ""), map(fnmatch.translate, re.findall(r"\"(.*?)\",", data)))

            _config = pac["pac"]
    return _config


def add_host(host):
    host = host.split(':')[0]
    if host not in _custom_hosts:
        _custom_hosts.append(host)


class AntizapretProxyHandler(urllib2.ProxyHandler, object):

    def __init__(self):
        self.config = config()
        urllib2.ProxyHandler.__init__(self, {
            "http": "<empty>",
            "https": "<empty>",
            "ftp": "<empty>",
        })

    def proxy_open(self, req, proxy, type):
        import socket
        if self.config["server"]:
            host = req.get_host().split(":")[0]
            if host in self.config["domains"] or socket.gethostbyname(host) in self.config["domains"] or host in _custom_hosts:
                return urllib2.ProxyHandler.proxy_open(self, req, self.config["server"], type)

        return None


def url_get(url, params={}, headers={}, post=None):
    from contextlib import closing
    from xbmctorrent import plugin
    from xbmctorrent.common import USER_AGENT

    if params:
        import urllib
        url = "%s?%s" % (url, urllib.urlencode(params))

    if post:
        import urllib
        post = urllib.urlencode(post)

    req = urllib2.Request(url, post)
    req.add_header("User-Agent", USER_AGENT)
    for k, v in headers.items():
        req.add_header(k, v)
    try:
        with closing(urllib2.urlopen(req)) as response:
            data = response.read()
            if response.headers.get("Content-Encoding", "") == "gzip":
                import zlib
                return zlib.decompressobj(16 + zlib.MAX_WBITS).decompress(data)
            return data
    except urllib2.HTTPError as e:
        plugin.log.error("HTTP Error(%s): %s" % (e.errno, e.strerror))
        return None
