#!/usr/bin/python
# -*- coding: utf-8 -*-

import re

from xbmctorrent import plugin
from kinopoisk import KinoPoisk
from tvdb import TvDb
from tmdb import TmDb


STATUS = {
    'moder': (40501, 'FFFF0000'),
    'check': (40502, 'FFFF0000'),
    'repeat': (40503, 'FFFF0000'),
    'nodesc': (40504, 'FFFF0000'),
    'copyright': (40505, 'FFFF0000'),
    'close': (40506, 'FFFF0000'),
    'absorb': (40507, 'FFFF0000'),

    'nocheck': (40508, 'FFFF9900'),
    'neededit': (40509, 'FFFF9900'),
    'doubtful': (40510, 'FFFF9900'),
    'temp': (40511, 'FFFF9900'),

    'ok': (40512, 'FF339933')
}

GENRE = (
    ('anime', 80102),
    ('biography', 80103),
    ('action', 80104),
    ('western', 80105),
    ('military', 80106),
    ('detective', 80107),
    ('children', 80108),
    ('documentary', 80109),
    ('drama', 80110),
    ('game', 80111),
    ('history', 80112),
    ('comedy', 80113),
    ('concert', 80114),
    ('short', 80115),
    ('criminal', 80116),
    ('romance', 80117),
    ('music', 80118),
    ('cartoon', 80119),
    ('musical', 80120),
    ('news', 80121),
    ('adventures', 80122),
    ('realitytv', 80123),
    ('family', 80124),
    ('sports', 80125),
    ('talkshows', 80126),
    ('thriller', 80127),
    ('horror', 80128),
    ('fiction', 80129),
    ('filmnoir', 80130),
    ('fantasy', 80131)
)

WORK = (
    ('actor', u'Актер'),
    ('director', u'Режиссер'),
    ('writer', u'Сценарист'),
    ('producer', u'Продюсер'),
    ('composer', u'Композитор'),
    ('operator', u'Оператор'),
    ('editor', u'Монтажер'),
    ('design', u'Художник'),
    ('voice', u'Актер дубляжа'),
    ('voice_director', u'Режиссер дубляжа')
)

MPAA = ('G', 'PG', 'PG-13', 'R', 'NC-17', 'C', 'GP')


# ########################
#
#   COMMON
#
# ########################

# class TrailerParser:
#     def trailer_parser(self, trailers):
#         popup = []

#         # готовим список для попап-меню
#         for r in trailers:
#             name = r['name'] + u' [COLOR FFFFFFCC]['
#             if r['ru']:
#                 name += u'RU, '
#             if r['video'][0] > 3:
#                 name += u'HD, '
#             if r['time']:
#                 name += r['time'] + u', '
#             name += r['video'][2] + u'][/COLOR]'
#             popup.append((name, r['video'][1]))

#         label = self.lang[40101] + u' (' + str(len(popup)) + u')'
#         if [1 for x in trailers if x['ru']]:
#             label += u' RU'

#         return label, popup

# class Scrapers(TrailerParser):
class Scrapers():
    RE = {
        'year': re.compile(ur'(?:\[|\()([1-2]{1}[0-9]{3})(?:\)|\s*|\г|\,)', re.U),
        'second': re.compile(r'^([^\[]*)\[(.+)\]([^\]]*)$', re.U)
    }

    def scraper(self, content, item):
        # если есть специализированный скрабер, то запускаем его...
        if content == 'kinopoisk':
            return self.scraper_kinopoisk(item)

        elif content == 'tvdb':
            return self.scraper_tvdb(item)

        elif content == 'tmdb':
            return self.scraper_tmdb(item)

        else:
            # иначе, используем стандартное отображение
            return self.default(item)

    def scraper_kinopoisk(self, item):
        kinopoisk = KinoPoisk()
        scraper = self.scraper_default(item)

        name, search, year = self.split_name(item['label'])

        if not search:
            scraper['label'] = name
            return scraper

        kinopoisk = kinopoisk.scraper(search, year, None)
        if not kinopoisk:
            return scraper

        scraper.update(kinopoisk)
        scraper['label'] = name

        # для поиска похожих раздач
        if kinopoisk['info'].get('originaltitle'):
            scraper['search'] = kinopoisk['info']['originaltitle']
        elif kinopoisk['info'].get('title'):
            scraper['search'] = kinopoisk['info']['title']

        # для создания поддиректорий
        scraper['subdir'] = scraper['search']
        if scraper['info'].get('year'):
            scraper['subdir'] = u'.'.join([scraper['subdir'], str(scraper['info']['year'])])

        return scraper

    def scraper_tvdb(self, item):
        scraper = self.scraper_default(item)
        tvdb = TvDb()
        # пробуем получить сезон
        plugin.log.debug("TVDB: parsing season from item" + str(item).encode("utf-8"))
        r = re.compile(u'Сезон[\:]{0,1}[\s]{1,}([0-9]+)', re.U).search(item['label'])
        if r:
            scraper['info']['season'] = int(r.group(1))
        plugin.log.debug("TVDB: splitting name from " + item['label'].encode("utf-8"))
        name, search, year = self.split_name(item['label'])
        plugin.log.debug("TVDB: name split to [%s][%s]" % (name.encode("utf-8"), str(year)))

        if not search:
            return scraper

        tvdb = tvdb.scraper(search, year)
        plugin.log.debug("TVDB: scraper result" + str(tvdb))
        if not tvdb:
            scraper['label'] = name
            return scraper

        scraper.update(tvdb)
        plugin.log.debug("Scraper data updated")
        scraper['label'] = name
        plugin.log.debug("Scraper label updated")
        # для поиска похожих раздач и поддиректорий
        scraper['search'] = scraper['subdir'] = search[0]
        if tvdb['info'].get('originaltitle'):
            scraper['search'] = tvdb['info']['originaltitle']
        elif tvdb['info'].get('title'):
            scraper['search'] = tvdb['info']['title']
        plugin.log.debug("Scraper info updated")
        # для создания поддиректорий
        scraper['subdir'] = scraper['search']
        if scraper['info'].get('year'):
            scraper['subdir'] = u'.'.join([scraper['subdir'], str(scraper['info']['year'])])
        plugin.log.debug("Scraper subdir info updated")
        return scraper

    def scraper_tmdb(self, item):
        scraper = self.scraper_default(item)
        tmdb = TmDb()

        name, search, year = self.split_name(item['label'])

        if not search:
            return scraper

        # для поиска похожих раздач и поддиректорий
        scraper['search'] = scraper['subdir'] = search[0]

        meta = tmdb.scraper(search, year)
        if not meta:
            scraper['label'] = name
            return scraper

        scraper.update(meta)
        scraper['label'] = name

        # для поиска похожих раздач
        if meta['info'].get('originaltitle'):
            scraper['search'] = meta['info']['originaltitle']
        elif meta['info'].get('title'):
            scraper['search'] = meta['info']['title']

        # для создания поддиректорий
        scraper['subdir'] = scraper['search']
        if scraper['info'].get('year'):
            scraper['subdir'] = u'.'.join([scraper['subdir'], str(scraper['info']['year'])])

        return scraper

    def default(self, item):
        scraper = self.scraper_default(item)
        name, search, year = self.split_name(item['label'])
        scraper['label'] = name

        # для поиска похожих раздач и поддиректорий
        scraper['search'] = scraper['subdir'] = search[0]

        item.update(scraper)
        return item

    def scraper_default(self, item):
        return {
            'label': item['label'],
            'icon': None,
            'thumbnail': None,
            'search': None,
            'subdir': None,
            'info': {
                'title': item.get("info", {}) and item["info"].get("title") or item['label']
            },
            'properties': {
                'fanart_image': None
            },
        }

    def split_name(self, name):
        # пробуем отделить основную часть имени фильма
        index = 1000000
        for token in (u'/', u'(', u'['):
            i = name.find(token)
            if i != -1 and i < index:
                index = i
        if index == 1000000:
            return name, None, None, None

        first = name[0:index].strip()
        second = name[index:].strip()
        r = self.RE['second'].search(second)
        if r:
            g = []
            for i in range(1, 4):
                if r.group(i):
                    if i == 2:
                        g.append(u'[' + r.group(i).strip() + u']')
                    else:
                        g.append(r.group(i).strip())
                else:
                    g.append(u'')
            splits = first, g[0], g[1], g[2]
        else:
            splits = first, second, u'', u''

        # компилируем имя
        name = u'[COLOR FFEEEEEE][B]' + splits[0] + u'[/B][/COLOR]'
        if splits[1]:
            name += u' ' + splits[1]
        if splits[2]:
            name += u' [COLOR FFFFFFCC]' + splits[2] + u'[/COLOR]'
        if splits[3]:
            name += u' ' + splits[3]

        # пробуем вытащить дату
        r = self.RE['year'].search(second)
        if r:
            year = int(r.group(1))
        else:
            year = None

        search = [first]

        # попробуем вытащить альтернативные имена
        index1 = splits[1].find(u'/')
        index2 = splits[1].find(u'(')
        if index1 >= 0 and index2 >= 0 and index1 < index2:
            for alt in splits[1][index1 + 1:index2].split(u'/'):
                search.append(alt.strip())
        elif index1 >= 0 and index2 == -1:
            for alt in splits[1][index1 + 1:].split(u'/'):
                search.append(alt.strip())

        return name, search, year
