from xbmctorrent import plugin, magnet, scrapers, torrent  # noqa: F401
from xbmctorrent.utils import ensure_fanart
from xbmctorrent.osarch import PLATFORM
from xbmctorrent.scrapers import MODULES, lostfilm, rutor, t3d, rutracker  # noqa: F401


@plugin.route("/")
@ensure_fanart
def index():

    if PLATFORM["os"] not in ["android", "linux", "windows", "darwin"]:
        plugin.notify("Your system \"%(os)s_%(arch)s\" is not supported." % PLATFORM, delay=15000)

    for module in MODULES:
        if module["enabled"]:
            yield {
                "label": module["name"],
                "thumbnail": module["image"],
                "path": plugin.url_for(module["view"]),
            }
