# -*- coding: utf-8 -*-

import sys
from xbmcswift2 import actions
from xbmctorrent import plugin
from xbmctorrent.scrapers import scraper
from xbmctorrent.caching import cached_route, CACHE_DIR
from xbmctorrent.utils import ensure_fanart

BASE_URL = "%s/" % plugin.get_setting("base_rutor")
# DOWNLOAD_URL = BASE_URL.replace("http://", "http://d.").replace("https://", "https://d.")  # "http://d.rutor.info/"

HEADERS = {
    'Referer': BASE_URL,
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
    'Accept-Language': 'ru,en-US;q=0.8,en;q=0.6',
    'Accept-Charset': 'utf-8, *;q=0.1',
    'Accept-Encoding': 'gzip, deflate, sdch',
    'X-Compress': 'null'
}

CATEGORIES = (
    ("1", u"Зарубежные фильмы", "movies", "tmdb"),
    ("5", u"Наши фильмы", "movies", "kinopoisk"),
    ("12", u"Научно-популярные фильмы", "movies", ""),
    ("4", u"Сериалы", "tvshows", "tvdb"),
    ("6", u"Телевизор", "tvshows", ""),
    ("7", u"Мультипликация", "movies", "tmdb"),
    ("10", u"Аниме", "movies", ""),
    ("13", u"Спорт и Здоровье", "tvshows", ""),
    ("15", u"Юмор", "tvshows", ""),
    ("14", u"Хозяйство и Быт", "tvshows", ""),
)

# Cache TTLs
DEFAULT_TTL = 300  # 5 minutes

IGNORE = [u"Repack", u" PC |", u" РС", u" PC", u" PS", u"XBOX", u"RePack", u"FB2", u"TXT", u"DOC", u" MP3", u" JPG", u" PNG", u" SCR", u"PDF"]
IGNORE_EXT = [u".srt", u".ssa", u".txt", u".ac3", u".aac", u".jpg"]

_cookiejar = None


def udec(x):
    return x.decode('utf-8')


def uenc(x):
    return x.encode('utf-8')


def url_get(url, params={}, headers={}, post=None):
    global _cookiejar

    import re
    import time
    import cookielib
    from urlparse import urlparse
    from xbmctorrent.utils import url_get as url_get_origin

    if not _cookiejar:
        import os
        import urllib2
        import xbmcvfs

        sid_file = os.path.join(CACHE_DIR, 'rutor.cookies.dat')
        _cookiejar = cookielib.MozillaCookieJar(sid_file)

        if not xbmcvfs.exists(sid_file):
            _cookiejar.save()

        _cookiejar.load()

    cookie_handler = urllib2.HTTPCookieProcessor(_cookiejar)

    result = url_get_origin(url, params, headers, post, handlers=[cookie_handler])

    if not result:
        return ""

    match = re.search(r'document.cookie=\'_ddn_intercept_2_=(.*?); max-age=([0-9]*?); path=/\';', result)

    if match:
        parts = urlparse(url)
        expires = time.time() + int(match.group(2))
        cookie = cookielib.Cookie(version=0, name='_ddn_intercept_2_', value=match.group(1), port=(parts.port or "80"), port_specified=(parts.port is not None),
                                  domain=parts.hostname, domain_specified=(parts.hostname is not None), domain_initial_dot=parts.hostname.startswith('.'), path='/', path_specified=True,
                                  secure=(parts.scheme == "https"), expires=expires, discard=False, comment=None, comment_url=None, rest={'HttpOnly': False}, rfc2109=False)

        _cookiejar.set_cookie(cookie)
        _cookiejar.save()

        result = url_get_origin(url, params, headers, post, handlers=[cookie_handler])

    _cookiejar.save()

    return result


@scraper("RuTor.org", "http://s.rutor.is/logo.jpg", plugin.get_setting("rutor_enabled", bool))
@plugin.route("/rutor")
@ensure_fanart
def rutor_index():
    yield {
        "label": u"[COLOR FFFFFF00][ Поиск ][/COLOR]",
        "path": plugin.url_for("rutor_search"),
    }
    for cat in CATEGORIES:
        yield {
            "label": cat[1],
            "path": plugin.url_for("rutor_page", catind=cat[0], page=0, query=str(None)),
        }


@plugin.route("/rutor/browse/<catind>/<page>/<query>")
@cached_route(ttl=DEFAULT_TTL, content_type="movies")
@ensure_fanart
def rutor_page(catind, page, query=None):
    import hashlib
    import xbmc
    from bs4 import BeautifulSoup
    from urlparse import urljoin
    from concurrent import futures
    from contextlib import closing
    from xbmctorrent.utils import SafeDialogProgress

    scraper_name = ""
    category = ([cat for cat in CATEGORIES if cat[0] == catind] or [("0", u"", "", "")])[0]
    scraper_name = category[3]
    plugin.set_content(category[2])

    page = int(page)
    catind = int(catind)

    mode = "browse"
    if query and query != str(None):
        mode = "search"

    with closing(SafeDialogProgress(delay_close=0)) as dialog:
        dialog.create(plugin.name)
        dialog.update(percent=0, line1=u"Получение информации о раздачах...", line2="", line3="")

        nodes = []
        try:
            html_data = url_get(urljoin(BASE_URL, "%s/%d/%d/0/0/%s" % (mode, page, catind, query)), headers=HEADERS)
            soup = BeautifulSoup(html_data, "html5lib")
            nodes = soup.findAll("tr", class_=["gai", "tum"])
        except:
            import xbmcgui
            plugin.log.error("Unexpected error: %s" % sys.exc_info()[0])
            xbmcgui.Dialog().ok(plugin.name, "Не удалось получить данные от сервера")
            return

        if not nodes or len(nodes) == 0:
            yield {
                "label": u"[ Не найдено ]",
                "path": plugin.url_for("rutor_index"),
                "is_playable": False,
            }
            return

        # store length before filter
        nodeslen = len(nodes)
        nodes = [node for node in _rutor_filter_nodes(nodes)]

        items = []
        for node in nodes:
            cells = node.findAll("td")
            seeds, peers = map(lambda x: x.text.strip(), cells[len(cells) - 1].findAll("span"))
            links = cells[1].findAll("a")
            title_node = links[len(links) - 1]
            size = cells[len(cells) - 2].text
            tid = int(title_node["href"][9:title_node["href"].find(u"/", 9)])
            title = _rutor_cleantitle(title_node.text)
            label = "%s | %s (S:%s P:%s)" % (title, size, seeds, peers)
            item = {
                "label": label,
                "path": plugin.url_for("rutor_details", catind=catind, tid=tid),
                "info": {"title": title},
                "is_playable": False,
            }
            items.append(item)

        with futures.ThreadPoolExecutor(max_workers=5) as pool:
            from xbmctorrent.utils import get_item_info

            usesearch = plugin.get_setting("rutor_usesearch", bool)
            jobs = [pool.submit(get_item_info, i, usesearch and scraper_name or None) for i in items]
            state = {"done": 0}

            def on_done(future):
                if not future.cancelled():
                    state["done"] += 1
                    data = future.result()
                    dialog.update(
                        percent=int(state["done"] * 100.0 / len(jobs)),
                        line2=data["info"].get("title") or data.get("label") or "",
                    )

            [job.add_done_callback(on_done) for job in jobs]
            while not all(job.done() for job in jobs):
                if dialog.iscanceled():
                    [job.cancel() for job in jobs]
                    return
                xbmc.sleep(100)
            items = [job.result() for job in jobs if not job.cancelled()]

        passed = {}
        for item in items:
            sha1 = hashlib.sha1(uenc(item.get("subdir") and item["subdir"] or (item.get("search") and item["search"] or item["label"]))).hexdigest()
            if mode == "search" or not passed.get(sha1):
                passed[sha1] = True
                del item["search"]
                del item["subdir"]
                yield item

        if nodeslen == 100:
            next_page = {
                "label": u"[COLOR FF00FF00][Далее >][/COLOR]",
                "path": plugin.url_for("rutor_page", catind=catind, page=page + 1, query=query),
                "is_playable": False,
            }
            yield next_page


@plugin.route("/rutor/details/<catind>/<tid>")
@cached_route(ttl=DEFAULT_TTL, content_type="movies")
@ensure_fanart
def rutor_details(catind, tid):
    import xbmcgui
    from bs4 import BeautifulSoup
    from urlparse import urljoin
    from xbmctorrent.utils import get_quality_from_name
    from xbmctorrent.search import scrapers as search

    scraper_name = ""
    category = ([cat for cat in CATEGORIES if cat[0] == catind] or [("0", u"", "", "")])[0]
    scraper_name = category[3]
    plugin.set_content(category[2])

    tid = int(tid)
    try:
        html_data = url_get(urljoin(BASE_URL, "torrent/%d/" % tid), headers=HEADERS)
    except:
        xbmcgui.Dialog().ok(plugin.name, "Не удалось получить данные от сервера")
        return

    soup = BeautifulSoup(html_data, "html5lib")
    if len(soup.select("div#download")) == 0:
        # it may occur if site redirects a request to his mirror
        xbmcgui.Dialog().ok(plugin.name, "Раздачи не существует. Обновите список")
        return

    div_index = soup.select("div#index")

    scrapers = search.Scrapers()

    details = soup.select("table#details")[0].findAll("tr")
    shift = 1 if len(details[1].select("a")) > 0 else 0
    seeds = details[3 + shift].contents[1].text
    peers = details[4 + shift].contents[1].text
    size = details[7 + shift].contents[1].text
    size = size[:size.find(" ")]
    title = _rutor_cleantitle(soup.h1.text)
    label = "%s | %s (S:%s P:%s)" % (title, size, seeds, peers)
    item = {
        "label": label,
        "info": {"title": title}
    }

    if plugin.get_setting("rutor_usesearch", bool):
        meta = scrapers.scraper(scraper_name, item)
    else:
        meta = scrapers.default(item)

    meta["path"] = plugin.url_for("rutor_play", tid=tid)
    meta["is_playable"] = True
    meta.setdefault("stream_info", {}).update(get_quality_from_name(meta['label']))
    meta["context_menu"] = [("Play with Pulsar", actions.update_view(plugin.url_for("rutor_play_pulsar", tid=tid)))]

    del meta["search"]
    del meta["subdir"]
    yield meta

    if len(div_index) > 0:
        nodes = div_index[0].findAll("tr", class_=["gai", "tum"])
        nodes = [node for node in _rutor_filter_nodes(nodes)]

        for node in nodes:
            cells = node.findAll("td")
            seeds, peers = map(lambda x: x.text.strip(), cells[len(cells) - 1].findAll("span"))
            donwload_node, magnet_node, title_node = cells[1].findAll("a")
            size = cells[len(cells) - 2].text
            title = _rutor_cleantitle(title_node.text)
            tid = int(title_node["href"][9:title_node["href"].find(u"/", 9)])
            label = "%s | %s (S:%s P:%s)" % (title, size, seeds, peers)

            item = scrapers.default({
                "label": label,
                "info": {"title": title}
            })
            item.update({
                "path": plugin.url_for("rutor_play", tid=tid),
                "is_playable": True,
                "thumbnail": meta["thumbnail"],
                "icon": meta["icon"]
            })
            item["info"].update(meta["info"])
            item["properties"].update(meta["properties"])
            item.setdefault("stream_info", {}).update(get_quality_from_name(item['label']))
            item["context_menu"] = [("Play with Pulsar", actions.update_view(plugin.url_for("rutor_play_pulsar", tid=tid)))]

            del item["search"]
            del item["subdir"]
            yield item


@plugin.route("/rutor/search")
def rutor_search():
    import urllib

    query = plugin.request.args.get("query")
    if query:
        query = query[0]
    else:
        query = plugin.keyboard("", "RuTor.org - Search")
    if query:
        plugin.redirect(plugin.url_for("rutor_page", catind=0, page=0, query=urllib.quote(query)))


@plugin.route("/rutor/play/<tid>", options={"pulsar": "0"})
@plugin.route("/rutor/play/<tid>/pulsar", name="rutor_play_pulsar", options={"pulsar": "1"})
@ensure_fanart
def rutor_play(tid, pulsar):
    from contextlib import closing
    from bencode import bdecode
    from urlparse import urljoin
    from xbmctorrent.magnet import generate_magnet
    from xbmctorrent.utils import first, SafeDialogProgress
    from xbmctorrent.acestream import ace_supported

    with closing(SafeDialogProgress(delay_close=0)) as dialog:
        dialog.create(plugin.name)
        dialog.update(percent=0, line1="Получение информации о раздаче...")

        torrent_url = urljoin(BASE_URL, "download/%s" % tid)
        try:
            metadata = bdecode(url_get(torrent_url, headers=HEADERS))
        except:
            import xbmcgui
            plugin.log.error("Unexpected error: %s" % sys.exc_info()[0])
            xbmcgui.Dialog().ok(plugin.name, "Не удалось получить данные от сервера")
            return

        dialog.update(percent=100, line1="Готово")

        if "files" in metadata["info"]:  # and ace_supported():
            items = []
            for index, info in enumerate(metadata["info"]["files"]):
                name = "/".join(info["path"])
                if not _rutor_valid_file(name):
                    continue

                if plugin.get_setting("torrent_engine", int) == 1 and ace_supported():
                    path = plugin.url_for("torrent_play", url=torrent_url, index=index, name=name)
                else:
                    path = plugin.url_for("play_file", uri=generate_magnet(metadata, name), index=index)

                items.append({"label": name, "path": path})

            items = sorted(items, key=lambda x: x["label"])
            if len(items) == 1:  # start playback if torrent contains only one file
                plugin.redirect(items[0]["path"])
            else:               # ask to select which file to play
                import xbmcgui
                select_items = [item["label"] for item in items]
                select = xbmcgui.Dialog().select("Выберите файл для проигрывания", select_items)
                if select >= 0:
                    plugin.redirect(items[select]["path"])
        else:
            name = metadata["info"].get("name") or " / ".join(first(metadata["info"]["files"])["path"]) or "rutor.org"
            if plugin.get_setting("torrent_engine", int) == 1 and ace_supported():
                path = plugin.url_for("torrent_play", url=torrent_url, index=0, name=name)
            else:
                path = plugin.url_for(["play", "play_with_pulsar"][int(pulsar)], uri=generate_magnet(metadata, name))
            plugin.redirect(path)


def _rutor_filter_nodes(nodes):
    for node in nodes:
        title = _rutor_title_from_node(node)
        valid = True

        for exclude in IGNORE:
            if title.find(exclude) >= 0:
                valid = False
                break

        if valid:
            yield node


def _rutor_valid_file(filename):
    for exclude in IGNORE_EXT:
        if filename.decode("utf-8").endswith(exclude):
            return False
    return True


def _rutor_title_from_node(node):
    cells = node.findAll("td")
    links = cells[1].findAll("a")
    return links[len(links) - 1].text


def _rutor_only_title(title):
    return title[:title.find(u'(')].strip()


def _rutor_only_title_from_node(node):
    return _rutor_only_title(_rutor_title_from_node(node))


def _rutor_cleantitle(title):
    # k1=title.find('/')
    # if k1<0: k1=title.find('(')
    k1 = title.find('(')
    tmp1 = title[:k1]
    n1 = -1
    if tmp1.find('[') < 0:
        n1 = title.find('[')
    if n1 < 0:
        n1 = title.find('(')
    k2 = title.find(u" от ")
    if k2 < 0:
        k2 = None
    tmp2 = title[n1:k2]
    title = tmp1 + tmp2
    title = title.replace(u"| Лицензия", "")
    title = title.replace(u"| лицензия", "")
    title = title.replace(u"| ЛицензиЯ", "")
    return title.strip()
