from xbmctorrent import plugin


@plugin.route("/cmd/install")
def firstrun():
    clear_cache()
    plugin.notify("Please review your settings.")
    plugin.set_setting("firstrun", "true")
    plugin.open_settings()


@plugin.route("/cmd/clear_cache")
def clear_cache():
    import os
    import glob
    from xbmctorrent.caching import CACHE_DIR
    for directory in [CACHE_DIR, plugin.storage_path]:
        for dbfile in glob.glob(os.path.join(directory, "*.db")):
            os.remove(dbfile)
    plugin.notify("Cache cleared.")


if not plugin.get_setting("firstrun", bool):
    firstrun()
