<?php

/**
 * Did someone clone me - detect website clones
 *
 * @author    Wesley Neelen <contact@didsomeoneclone.me>
 * @copyright Copyright (c) 2023 Wesley Neelen
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Registry\Registry;

if ( ! defined( 'DSCM_PLUGIN_DIR' ) )
{
	define( 'DSCM_PLUGIN_DIR', dirname( __FILE__ ) );
}

class plgSystemDidsomeonecloneme extends CMSPlugin
{
	/**
	 * If plugin is enabled
	 *
	 * @var bool
	 */
	public $enabled = true;
	
	public function __construct( &$subject, $config )
	{
		parent::__construct( $subject, $config );
		// Disable if we cannot initialize application
		try
		{
			$this->app = Factory::getApplication();
		}
		catch ( Exception $e )
		{
			$this->enabled = false;

			return;
		}
	
		// Disable if not on front end
		if ( ! $this->app->isClient( 'site' ) )
		{
			$this->enabled = false;

			return;
		}
		
		// Disable if site offline
		if ( $this->app->get( 'offline', '0' ))
		{
			$this->enabled = false;

			return;
		}

	}
	
	public function onAfterRender()
	{
		
		if ( ! $this->enabled )
		{
			return false;
		}
		
		// Get link
		$link = $this->params->get('link');
		
		// Check if link is not empty
		if($link && filter_var($link, FILTER_VALIDATE_URL)){
			
			$replacedHtml = "<script src=\"" . htmlspecialchars($link) . "\" crossorigin=\"anonymous\"></script>";
		
			$html = $this->app->getBody();
		
			$sOptimizedHtml = $html;
		
			$sOptimizedHtml = str_replace('</body>', $replacedHtml . '
			</body>', $sOptimizedHtml);

			$this->app->setBody( $sOptimizedHtml );
		
		}
	}
}
