//version 1.0--12/5/14

cap program drop pairsimsens

program define pairsimsens, rclass
version 9

//version 9, so "Binomial" function is backward-compatible--
//changed to "binomialtail" at some point.

syntax varname [if] [in], Treat(varname numeric) Str(varname numeric) [Gam(real 1.0) Del(real 1.0) Mcnemar Wsignedrank Hlestimate] 

if `c(changed)' == 1{
di "{error:Save data in memory before proceeding (note: clear option invalid for simsens)}"
exit 4
}

if `gam'<1{
di "{error:Enter a value of Gamma that is at least 1}"
exit 198
}

if `del'<1{
di "{error:Enter a value of Delta that is at least 1}"
exit 198
}

if "`wsignedrank'"=="wsignedrank" & "`mcnemar'"=="mcnemar"{
di "{error: specify one of wsignedrank and mcnemar options}"
exit 198
}

if "`wsignedrank'"=="" & "`mcnemar'"==""{
di "{error: specify one of wsignedrank and mcnemar options}"
exit 198
}

local mainfile= "`c(filename)'"

//McNemar Test:
if "`mcnemar'"=="mcnemar"{

//begin quietly:
quietly{

//for clarity in code:
local resp="`varlist'"

//eliminate concordant pairs:
egen __tv=mean(`resp'), by(`str')
replace __tv=. if __tv==0 | __tv==1

//define sample: discordant pairs where response, treat, stratum nonmissing:
marksample touse
markout `touse' `treat' `str' __tv
drop __tv

//check that strata contain only pairs:
egen __tv=count(`treat') if `touse'==1, by(`str')
summ __tv
if `r(max)'>2 | `r(min)'< 2{
noisily di "{error: strata must exactly two units for pairsimsens}"
drop __tv
exit 198
}
drop __tv

summ `treat' if `touse'==1
return list
local n=`r(sum)'
//n: number of discordant matched pairs (dmp)

summ `resp' if `treat'==1 & `touse'==1
local k=`r(sum)'
//k: of the dmp, how many of the treated subjects have the positive outcome.


local p=(1+`gam'*`del')/((`gam'+1)*(`del'+1))
//p: p(treated has positive outcome among dmps | u)

local pval = Binomial(`n',`k',`p')
//pval: max[p(T>=observed test stat|u)], under null.

//standardized deviate and approximation of pval (apval) not needed or displayed, but is returned:  
local dev = (`k'- `n'*`p')/(sqrt(`n'*`p'*(1-`p')))
local apval=1-normal(`dev')

use "`mainfile'",clear
} //end quietly

di  _newline(1) "{result:{ul on}SIMULTANEOUS SENSITIVITY ANALYSIS FOR MCNEMAR TEST{ul off}}" _newline(2) ///
"{res:Gamma: `gam'}"  _newline(1) ///
"{res:Delta: `del'}"  _newline(1) ///
"{res:Discordant Matched Pairs: `n'}"  _newline(1) ///
"{res:max[p(t>=`k'|u)]: `pval'}" 

ret scalar pval=`pval'
ret scalar tsobs=`k'
ret scalar gam=`gam'
ret scalar del=`del'
ret scalar dmp=`n'
ret scalar p=`p'
ret scalar dev=`dev'
ret scalar apval=`apval'

} //end McNemar

//Wilcoxon Signed Rank Test
if "`wsignedrank'"=="wsignedrank"{

//begin quietly:
quietly{

//for clarity in code:
local resp="`varlist'"


//convert Gamma to gamma, Delta to delta:
local ugam=ln(`gam')
local udel=ln(`del')


marksample touse 
markout `touse' `treat' `str' 

//check that strata contain only pairs:
egen __tv=count(`treat') if `touse'==1, by(`str')
summ __tv
if `r(max)'>2 | `r(min)'< 2{
noisily di "{error: strata must exactly two units for pairsimsens}"
drop __tv
exit 198
}
drop __tv

gen double __tv0=`resp' if `treat'==1 & `touse'==1
replace __tv0=-1*`resp' if `treat'==0 & `touse'==1
egen double __tcdif=sum(__tv0)  if `touse'==1, by(`str')
//__tcdif: for each pair, treated response minus control response 

//for use of hlestimate option only:
//----------------------------------
summ __tcdif, detail
local tau_l0=`r(min)'
local tau_r0=`r(max)'
//-----------------------------------

gen double __abstcdif=abs(__tcdif) if `touse'==1
gen double __tv1=1
replace __tv1=. if __abstcdif==float(0)
gen double __tv2=`treat' if `touse'==1
replace __tv2=. if __tv2==0 & `touse'==1

markout `touse' `treat' `str' __tv1 __tv2
//Now removed f/ sample all tied pairs, & keeps the treated obs in non-tied strata

drop __tv0
drop __tv1
drop __tv2

egen double __rawrank=rank(__abstcdif) if `touse'==1

summ `treat' if `touse'==1
local I=`r(sum)'
gen double __adjrank=(2*__rawrank)/`I' if `touse'==1
//__adjrank is adjusted rank.

summ __rawrank if __tcdif>0 & `touse'==1
local tsobs=`r(sum)'
//per gkr98, use __rawrank here, not __adjrank

gen double __pi_i=1/(1+exp(abs(`ugam')*-1)) if `touse'==1

gen double __theta_i=1/(1+exp(-1*abs(`udel')*__adjrank)) if `touse'==1

gen double __p_i=__theta_i*__pi_i + (1-__theta_i)*(1-__pi_i) if `touse'==1
//this gives p(treated has higher resp|confounding), under null, for each i

local p_i=__pi_i*`udel'/(`udel'+1)
//this gives p(treated has higher resp|confounding), under null 
//for pair with adjrank=1.

egen double __mu=sum(__p_i*__rawrank) if `touse'==1
//per gkr98, use __rawrank here, not __adjrank

summ __mu
local mu=`r(max)'
//__mu only takes on one value, which `r(max)' gives.

egen double __sig2=sum(__p_i*(1-__p_i)*__rawrank^2) if `touse'==1
//per gkr98, use __rawrank here, not __adjrank

summ __sig2
local sig2=`r(max)'
//__sig2 only takes on one value, which `r(max)' gives.

local dev=(`tsobs'-`mu')/sqrt(`sig2')
local pval=1-normal(`dev')

//capture so returned matrix not created if exceeds max matsize
capture mkmat strat __adjrank __theta_i __pi_i __p_i if `touse'==1, matrix(retmat) nomiss

//calculate H-L estimate:
if "`hlestimate'"=="hlestimate"{

//define HL estimate at bound, hat_tau, as (tau_a+tau_b)/2
//tau_a := f(tau_a) <= `mu' & f(tau_a+eps)>`mu' 
//tab_b := f(tau_b) >= `mu' & f(tau_b-eps)<`mu'

//set initial values of tau_l and tau_r:
local tau_l=`tau_l0'
local tau_r=`tau_r0'
local j=0
//d is indicator of whether tau_a has been found:
local d=0
//first calculate tau_a:
while `d' !=9{
local j=`j'+1

// j indicates run of H-L solver; exit at 1000, indicate failure:
if `j'==1000{
local j=1000 
continue, break
}

if `d'==0 | `d'==-1{
wsrts, intau(`tau_l') resp(`resp') treat(`treat') str(`str')
//wsrts is a subroutine of pairsimsens--see below
local ftau_l=`r(hltsobs)'
}
if `d'==0 | `d'==1{
wsrts, intau(`tau_r') resp(`resp') treat(`treat') str(`str')
local ftau_r=`r(hltsobs)'
}

local xw=.5
local tau_m=`xw'*`tau_r'+(1-`xw')*`tau_l'
wsrts, intau(`tau_m') resp(`resp') treat(`treat') str(`str')
local ftau_m=`r(hltsobs)'
local tau_mme=`tau_m'-.0000001
wsrts, intau(`tau_mme') resp(`resp') treat(`treat') str(`str')
local ftau_mme=`r(hltsobs)'

if `ftau_m'<= `mu' & `ftau_mme'>`mu'{
local tau_a=`tau_m'
local d=9
}
if `ftau_m'<= `mu' & `ftau_mme'<=`mu'{
local tau_r=`tau_m'
local d=1
}
if `ftau_m'>`mu'{
local tau_l=`tau_m'
local d=-1
}

} //end calcuation of tau_a

local tau_l=`tau_l0'
local tau_r=`tau_r0'
local d=0
local j=0
while `d' !=9{
local j=`j'+1

if `j'==1000{
local j=1000 
continue, break
}

if `d'==0 | `d'==-1{
wsrts, intau(`tau_l') resp(`resp') treat(`treat') str(`str')
local ftau_l=`r(hltsobs)'
} 
if `d'==0 | `d'==1{
wsrts, intau(`tau_r') resp(`resp') treat(`treat') str(`str')
local ftau_r=`r(hltsobs)'
}

local xw=.5
local tau_m=`xw'*`tau_r'+(1-`xw')*`tau_l'
wsrts, intau(`tau_m') resp(`resp') treat(`treat') str(`str')
local ftau_m=`r(hltsobs)'
local tau_mpe=`tau_m'+.0000001
wsrts, intau(`tau_mpe') resp(`resp') treat(`treat') str(`str')
local ftau_mpe=`r(hltsobs)'

if `ftau_m'>= `mu' & `ftau_mpe'<`mu'{
local tau_b=`tau_m'
local d=9
}
if `ftau_m'>= `mu' & `ftau_mpe'>=`mu'{
local tau_l=`tau_m'
local d=1
}
if `ftau_m'<`mu'{
local tau_r=`tau_m'
local d=-1
}
} //end calculation of tau_b

//captured in case tau_a and tau_b not found:
capture local hle=(`tau_a'+`tau_b')/2

//needed b/c round(`x') when " `x' " does not exist returns 0:
if `j' !=1000{
local hlr=round(`hle',.001)
}

} //end hlestimate loop.

ret scalar pval=`pval'
ret scalar tsobs=`tsobs'
ret scalar gam=`gam'
ret scalar del=`del'
ret scalar dev=`dev'
ret scalar mu=`mu'
ret scalar sig2=`sig2'
if "`hlestimate'"=="hlestimate"{
//captured in case H-L estimate not found:
capture ret scalar hle=`hle'
capture ret scalar hlr=`hlr'
}
//captured b/c returned matrix not created if exceeds max matsize:
capture ret matrix retmat = retmat

//end quietly
}

if "`hlestimate'"=="hlestimate"{
di  _newline(1) "{result:{ul on}SIMULTANEOUS SENSITIVITY ANALYSIS FOR WILCOXON S-R TEST{ul off}}" _newline(2) ///
"{res:Gamma: `gam'}"  _newline(1) ///
"{res:Delta: `del'}"  _newline(1) ///
"{res:Expectation: `mu'}" _newline(1) ///
"{res:Variance: `sig2'}" _newline(1) ///
"{res:Deviate: `dev'}" _newline(1) ///
"{res:max[p(t>=`tsobs'|u)]: `pval'}"
if `j'!=1000{
di "{res:min[H-L Point Estimate]: `hlr'}"
}
if `j'==1000{
di "{res:Warning: Hodges-Lehmann Estimate Not Found}"
}
}

if "`hlestimate'"!="hlestimate"{
di  _newline(1) "{result:{ul on}SIMULTANEOUS SENSITIVITY ANALYSIS FOR WILCOXON S-R TEST{ul off}}" _newline(2) ///
"{res:Gamma: `gam'}"  _newline(1) ///
"{res:Delta: `del'}"  _newline(1) ///
"{res:Expectation: `mu'}" _newline(1) ///
"{res:Variance: `sig2'}" _newline(1) ///
"{res:Deviate: `dev'}" _newline(1) ///
"{res:max[p(t>=`tsobs'|u)]: `pval'}" _newline(1)
}

//restore original dataset:
quietly use "`mainfile'",clear

//end wilcoxon:
}

end


cap program drop wsrts

program define wsrts, rclass
version 9
//wsrts calcuates ts after proposed tau_a(b) is subtracted from treated responses

syntax [anything], Intau(real) Resp(varname numeric) Treat(varname numeric) Str(varname numeric)

marksample touse 
markout `touse' `treat' `str' `resp'
//gen double __tv0=`resp' if `treat'==1 & `touse'==1
//replace __tv0=-1*`resp' if `treat'==0 & `touse'==1

gen double __hltcdif=__tcdif-`intau' if `touse'==1
gen double __hlabstcdif=abs(__hltcdif) if `touse'==1
gen double __tv1=1
replace __tv1=. if __abstcdif==float(0)

gen double __tv2=`treat' if `touse'==1
replace __tv2=. if __tv2==0 & `touse'==1

markout `touse' `treat' `str' `resp' __tv1 __tv2
//Now removed f/ sample all tied pairs, & keeps the treated obs in non-tied strata
drop __tv1
drop __tv2

egen double __hlrawrank=rank(__hlabstcdif) if `touse'==1

summ `treat' if `touse'==1
local hlI=`r(sum)'
gen double __hladjrank=__hlrawrank if `touse'==1

summ __hladjrank if __hltcdif>0 & `touse'==1
local hltsobs=`r(sum)'
noisily di `r(sum)'

ret scalar hltsobs=`hltsobs'

drop __hlabstcdif __hltcdif  __hlrawrank __hladjrank

end
