*this replicates Tables 4-5 in Gastwirth, Krieger, and Rosenbaum (1998)
*open gkr98-tab4.dta

local nlist="1 3 5 `c(maxfloat)'"
//nlist is values of Gamma and Delta
local i=1
foreach a in `nlist'{
foreach b in `nlist'{
//suppress output from pairsimsens:
qui pairsimsens resp, treat(treat) s(strat) g(`a') d(`b') wsi hle


//for each combination of Gamma and Delta, 
//store bound on deviate, p, and H-L est:
local dev`i'=`r(dev)'
local pval`i'=`r(pval)'
capture local hle`i'=`r(hlr)'
local i=`i'+1
}
}

//save filename for later re-loading:
local mainfile=c(filename)


//create dataset that contains p-values for each Gamma and Delta:
clear
gen double Gamma=. 
gen double Delta=.
gen dev=.
gen pval=.
gen hle=.
set obs `i'

local i=1
foreach a in `nlist'{
foreach b in `nlist'{
qui replace Gamma=`a' in `i'
qui replace Delta=`b' in `i' 
if `a' !=`c(maxfloat)' | `b' !=`c(maxfloat)'{ 
capture qui replace hle= `hle`i'' in `i'
qui replace dev= `dev`i'' in `i'
qui replace pval= `pval`i'' in `i'
}
local i=`i'+1
}
}

//make tables:
table Gamma Delta, contents(mean dev) 
table Gamma Delta, contents(mean pval) 
table Gamma Delta, contents(mean hle)


//restore original dataset:
use "`mainfile'", clear
