#!/bin/sh

# Request elevated privileges
[ "$(whoami)" != "root" ] && exec sudo "$0" "$@"

# Check if not run as root
if [ "$(id -u)" != "0" ]; then

	# Display message
	echo
	echo 'Root privileges required.'
	echo

# Otherwise
else

	# Set if using OctoPi
	if [ -f /etc/init.d/octoprint ]; then
		usingOctoPi=true
	else
		usingOctoPi=false
	fi
	
	# Check if not using OctoPi
	if ! $usingOctoPi
	then
	
		# Stop OctoPrint
		killall -w octoprint
		
		# Uninstall M33 Fio
		while echo 'y' | sudo -u $SUDO_USER pip uninstall OctoPrint-M3DFio
		do
			:
		done
		while echo 'y' | sudo -u $SUDO_USER pip uninstall OctoPrint-M33Fio
		do
			:
		done
		
		# Uninstall OctoPrint
		while echo 'y' | sudo -u $SUDO_USER pip uninstall OctoPrint
		do
			:
		done
		rm -rf '/home/'"$SUDO_USER"'/.octoprint'
	
		# Uninstall OctoPrint and M33 Fio dependencies
		while echo 'y' | sudo -u $SUDO_USER pip uninstall regex
		do
			:
		done
		while echo 'y' | sudo -u $SUDO_USER pip uninstall pillow
		do
			:
		done
		
		if [ -f /etc/debian_version ]; then
			while ! apt-get -y remove python python-pip python-dev libyaml-dev build-essential python-pygame libjpeg-dev zlib1g-dev git
			do
				:
			done
		elif [ -f /etc/fedora-release ]; then
			while ! dnf -y remove python python-pip python-devel libyaml-devel make automake gcc gcc-c++ kernel-devel pygame libjpeg-turbo-devel zlib-devel git
			do
				:
			done
		fi
	
	# Otherwise
	else
	
		# Uninstall M33 Fio
		while echo 'y' | sudo -u pi /home/pi/oprint/bin/pip uninstall OctoPrint-M3DFio
		do
			:
		done
		while echo 'y' | sudo -u pi /home/pi/oprint/bin/pip uninstall OctoPrint-M33Fio
		do
			:
		done
	fi

	# Remove printer udev rules
	rm /etc/udev/rules.d/90-micro-3d-local.rules
	rm /etc/udev/rules.d/92-m3d-pro-local.rules
	rm /etc/udev/rules.d/93-micro+-local.rules
	
	# Remove heatbed udev rule
	rm /etc/udev/rules.d/91-micro-3d-heatbed-local.rules
	
	# Reload udev rules
	udevadm control --reload-rules
	udevadm trigger
	
	# Check if not using OctoPi
	if ! $usingOctoPi
	then
	
		# Remove OctoPrint from list of startup commands
		sed -i '/octoprint/d' /etc/rc.local
		
		# Remove URL link on desktop
		rm '/usr/share/icons/octoprint.png'
		rm '/home/'"$SUDO_USER"'/Desktop/OctoPrint.desktop'
		
		# Display message
		echo 'OctoPrint and M33 Fio have been successfully uninstalled'
		echo
	
	# Otherwise
	else
	
		# Display message
		echo
		echo 'M33 Fio has been successfully uninstalled.'
		echo
	fi
fi
