include(vcpkg_common_functions)
set(SOURCE_PATH ${CURRENT_BUILDTREES_DIR}/src/carnd-term2-libs)

vcpkg_download_distfile(ARCHIVE
    URLS "https://raw.githubusercontent.com/drganjoo/term2-setup/master/carnd-term2-libs.zip"
    FILENAME "carnd-term2-libs.zip"
    SHA512 008a904f38f359efd5bb691788a13f79f217adf64c14c076ca0a8c73c2e783460f785058cae4aa1c411731461b8a9f3dc4d0fa384923e71ce66766d7b529de08
)
vcpkg_extract_source_archive(${ARCHIVE})

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS_DEBUG
        -DINSTALL_HEADERS=OFF
)

vcpkg_install_cmake()

file(COPY ${SOURCE_PATH}/LICENSE DESTINATION ${CURRENT_PACKAGES_DIR}/share/carnd-term2-libs)
file(RENAME ${CURRENT_PACKAGES_DIR}/share/carnd-term2-libs/LICENSE ${CURRENT_PACKAGES_DIR}/share/carnd-term2-libs/copyright)

vcpkg_copy_pdbs()