<?php
/**
 * ファイル名: archive.php
 * 説明: アーカイブページテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<?php get_header(); ?>

<!-- ========== アーカイブページ ========== -->
<main class="archive-content">
    
    <!-- アーカイブヘッダー -->
    <section class="archive-header">
        <div class="archive-header-container">
            <?php if (is_category()) : ?>
                <span class="archive-label">Category</span>
                <h1 class="archive-title"><?php single_cat_title(); ?></h1>
                <?php if (category_description()) : ?>
                    <p class="archive-description"><?php echo category_description(); ?></p>
                <?php endif; ?>
            
            <?php elseif (is_tag()) : ?>
                <span class="archive-label">Tag</span>
                <h1 class="archive-title"><?php single_tag_title(); ?></h1>
                <?php if (tag_description()) : ?>
                    <p class="archive-description"><?php echo tag_description(); ?></p>
                <?php endif; ?>
            
            <?php elseif (is_author()) : ?>
                <span class="archive-label">Author</span>
                <h1 class="archive-title"><?php the_author(); ?></h1>
                <?php if (get_the_author_meta('description')) : ?>
                    <p class="archive-description"><?php echo get_the_author_meta('description'); ?></p>
                <?php endif; ?>
            
            <?php elseif (is_date()) : ?>
                <span class="archive-label">Date</span>
                <h1 class="archive-title">
                    <?php
                    if (is_day()) :
                        echo get_the_date('Y年m月d日');
                    elseif (is_month()) :
                        echo get_the_date('Y年m月');
                    elseif (is_year()) :
                        echo get_the_date('Y年');
                    endif;
                    ?>
                </h1>
            
            <?php else : ?>
                <span class="archive-label">Archive</span>
                <h1 class="archive-title">投稿一覧</h1>
            <?php endif; ?>
        </div>
    </section>

    <!-- 記事一覧 -->
    <section class="archive-posts">
        <div class="archive-container">
            
            <?php if (have_posts()) : ?>
            
            <div class="posts-grid">
                <?php while (have_posts()) : the_post(); ?>
                
                <article id="post-<?php the_ID(); ?>" <?php post_class('post-card'); ?>>
                    
                    <!-- アイキャッチ画像 -->
                    <?php if (has_post_thumbnail()) : ?>
                    <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                        <?php the_post_thumbnail('medium'); ?>
                    </a>
                    <?php else : ?>
                    <a href="<?php the_permalink(); ?>" class="post-thumbnail post-thumbnail-placeholder">
                        <i class="fas fa-image"></i>
                    </a>
                    <?php endif; ?>
                    
                    <div class="post-content">
                        
                        <!-- カテゴリー -->
                        <?php
                        $categories = get_the_category();
                        if (!empty($categories)) :
                        ?>
                        <div class="post-categories">
                            <a href="<?php echo get_category_link($categories[0]->term_id); ?>" class="post-category">
                                <?php echo esc_html($categories[0]->name); ?>
                            </a>
                        </div>
                        <?php endif; ?>
                        
                        <!-- タイトル -->
                        <h2 class="post-title">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_title(); ?>
                            </a>
                        </h2>
                        
                        <!-- 抜粋 -->
                        <?php if (has_excerpt()) : ?>
                        <p class="post-excerpt"><?php echo get_the_excerpt(); ?></p>
                        <?php endif; ?>
                        
                        <!-- メタ情報 -->
                        <div class="post-meta">
                            <time class="post-date" datetime="<?php echo get_the_date('c'); ?>">
                                <i class="far fa-calendar"></i>
                                <?php echo get_the_date('Y.m.d'); ?>
                            </time>
                        </div>
                        
                    </div>
                </article>
                
                <?php endwhile; ?>
            </div>

            <!-- ページネーション -->
            <div class="archive-pagination">
                <?php
                the_posts_pagination(array(
                    'mid_size' => 2,
                    'prev_text' => '<i class="fas fa-chevron-left"></i> 前へ',
                    'next_text' => '次へ <i class="fas fa-chevron-right"></i>',
                ));
                ?>
            </div>

            <?php else : ?>
            
            <!-- 記事がない場合 -->
            <div class="no-posts">
                <div class="no-posts-icon">
                    <i class="fas fa-inbox"></i>
                </div>
                <h2 class="no-posts-title">記事が見つかりません</h2>
                <p class="no-posts-description">
                    このカテゴリー/タグにはまだ記事がありません。
                </p>
                <a href="<?php echo home_url(); ?>" class="no-posts-button">
                    <i class="fas fa-home"></i>
                    トップページへ
                </a>
            </div>

            <?php endif; ?>
            
        </div>
    </section>

</main>

<?php get_footer(); ?>