<?php
/**
 * ファイル名: footer.php
 * 説明: サイトフッターテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<!-- ========== フッター ========== -->
<footer class="modern-footer">
    <div class="footer-container">
        <div class="footer-grid">
            <!-- ブランド情報 -->
            <div class="footer-brand">
                <div class="footer-logo">
                    <div class="logo-icon">B</div>
                    <span class="logo-text">BRAND</span>
                </div>
                <p class="footer-description">
                    洗練されたデザインと<br>
                    最高のユーザー体験を提供します。
                </p>
            </div>

            <!-- メニュー -->
            <div class="footer-section">
                <h4>Menu</h4>
                <ul class="footer-links">
                    <li><a href="#about">About</a></li>
                    <li><a href="#services">Services</a></li>
                    <li><a href="#contact">Contact</a></li>
                </ul>
            </div>

            <!-- SNS -->
            <div class="footer-section">
                <h4>Social</h4>
                <ul class="footer-links">
                    <li><a href="https://instagram.com" target="_blank" rel="noopener noreferrer">Instagram</a></li>
                    <li><a href="https://x.com" target="_blank" rel="noopener noreferrer">X (Twitter)</a></li>
                </ul>
            </div>

            <!-- お問い合わせ -->
            <div class="footer-section">
                <h4>Contact</h4>
                <ul class="footer-links">
                    <li><a href="mailto:info@example.com">info@example.com</a></li>
                    <li><a href="tel:+810000000000">00-0000-0000</a></li>
                </ul>
            </div>
        </div>

        <!-- コピーライト -->
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> BRAND. All rights reserved.</p>
        </div>
    </div>
</footer>

<script>
// スクロール時のヘッダー変化
const header = document.getElementById('modernHeader');

window.addEventListener('scroll', () => {
    if (window.scrollY > 10) {
        header.classList.add('scrolled');
    } else {
        header.classList.remove('scrolled');
    }
});

// モバイルメニュー
const mobileMenuBtn = document.getElementById('mobileMenuBtn');
const mobileMenu = document.getElementById('mobileMenu');

mobileMenuBtn.addEventListener('click', () => {
    mobileMenuBtn.classList.toggle('active');
    mobileMenu.classList.toggle('active');
    document.body.style.overflow = mobileMenu.classList.contains('active') ? 'hidden' : '';
});

// メニューリンククリック時に閉じる
const mobileMenuLinks = mobileMenu.querySelectorAll('.menu-link');
mobileMenuLinks.forEach(link => {
    link.addEventListener('click', () => {
        mobileMenuBtn.classList.remove('active');
        mobileMenu.classList.remove('active');
        document.body.style.overflow = '';
    });
});
</script>

<?php wp_footer(); ?>
</body>
</html>