<?php
/**
 * ファイル名: front-page.php
 * 説明: フロントページテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>
<?php get_header(); ?>

<!-- ========== メインコンテンツ ========== -->
<main class="main-content">
    
    <!-- ヒーローセクション -->
    <section class="hero-section">
        <div class="hero-container">
            <h1 class="hero-title">Clean & Modern Design</h1>
            <p class="hero-description">
                洗練されたデザインと最高のユーザー体験を。<br>
                あなたのビジネスを次のレベルへ。
            </p>
            <div class="hero-buttons">
                <a href="#contact" class="btn-primary">お問い合わせ</a>
                <a href="#about" class="btn-secondary">詳しく見る</a>
            </div>
        </div>
    </section>

    <!-- Aboutセクション -->
    <section id="about" class="about-section">
        <div class="section-container">
            <div class="section-header">
                <span class="section-label">About</span>
                <h2 class="section-title">私たちについて</h2>
            </div>
            <div class="about-content">
                <p>
                    私たちは、最新のテクノロジーとデザインの力で、<br>
                    お客様のビジネスを成功へと導きます。
                </p>
                <p>
                    洗練されたデザインと使いやすさを両立させた<br>
                    最高のソリューションを提供します。
                </p>
            </div>
        </div>
    </section>

    <!-- Servicesセクション -->
    <section id="services" class="services-section">
        <div class="section-container">
            <div class="section-header">
                <span class="section-label">Services</span>
                <h2 class="section-title">サービス</h2>
            </div>
            <div class="services-grid">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <h3>Web Development</h3>
                    <p>モダンで高速なWebサイトを制作します。</p>
                </div>
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>App Development</h3>
                    <p>使いやすいモバイルアプリを開発します。</p>
                </div>
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-paint-brush"></i>
                    </div>
                    <h3>UI/UX Design</h3>
                    <p>美しく直感的なデザインを提供します。</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Contactセクション -->
    <section id="contact" class="contact-section">
        <div class="section-container">
            <div class="section-header">
                <span class="section-label">Contact</span>
                <h2 class="section-title">お問い合わせ</h2>
            </div>
            <div class="contact-content">
                <p>
                    プロジェクトのご相談や、ご質問など<br>
                    お気軽にお問い合わせください。
                </p>
                <a href="mailto:info@example.com" class="contact-button">
                    <i class="fas fa-envelope"></i>
                    info@example.com
                </a>
            </div>
        </div>
    </section>

</main>

<?php get_footer(); ?>