<?php
/**
 * ファイル名: header.php
 * 説明: サイトヘッダーテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- ========== ヘッダー ========== -->
<header class="modern-header" id="modernHeader">
    <div class="header-container">
        <!-- ロゴ -->
        <a href="<?php echo home_url(); ?>" class="header-logo">
            <div class="logo-icon">B</div>
            <span class="logo-text">BRAND</span>
        </a>

        <!-- デスクトップナビゲーション -->
        <div class="header-right">
            <!-- メニュー -->
            <nav>
                <ul class="header-menu">
                    <li class="menu-item">
                        <a href="#about" class="menu-link">About</a>
                    </li>
                    <li class="menu-item">
                        <a href="#services" class="menu-link">Services</a>
                    </li>
                    <li class="menu-item">
                        <a href="#contact" class="menu-link">Contact</a>
                    </li>
                </ul>
            </nav>

            <!-- SNSアイコン -->
            <div class="header-social">
                <a href="https://instagram.com" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="Instagram">
                    <i class="fab fa-instagram"></i>
                </a>
                <a href="https://x.com" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter)">
                    <i class="fab fa-twitter"></i>
                </a>
            </div>
        </div>

        <!-- モバイルメニューボタン -->
        <button class="mobile-menu-btn" id="mobileMenuBtn" aria-label="メニュー">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </div>
</header>

<!-- ========== モバイルメニュー ========== -->
<div class="mobile-menu" id="mobileMenu">
    <nav>
        <ul class="header-menu">
            <li class="menu-item">
                <a href="#about" class="menu-link">About</a>
            </li>
            <li class="menu-item">
                <a href="#services" class="menu-link">Services</a>
            </li>
            <li class="menu-item">
                <a href="#contact" class="menu-link">Contact</a>
            </li>
        </ul>
    </nav>

    <div class="header-social">
        <a href="https://instagram.com" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="Instagram">
            <i class="fab fa-instagram"></i>
        </a>
        <a href="https://x.com" class="social-link" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter)">
            <i class="fab fa-x-twitter"></i>
        </a>
    </div>
</div>