<?php
/**
 * ファイル名: 404.php
 * 説明: 404エラーページテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<?php get_header(); ?>

<!-- ========== 404エラーページ ========== -->
<main class="error-404-content">
    
    <section class="error-404-section">
        <div class="error-404-container">
            
            <!-- 404アイコン -->
            <div class="error-404-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>

            <!-- 404番号 -->
            <h1 class="error-404-number">404</h1>

            <!-- メッセージ -->
            <h2 class="error-404-title">ページが見つかりません</h2>
            <p class="error-404-description">
                お探しのページは削除されたか、<br>
                URLが変更された可能性があります。
            </p>

            <!-- ボタン -->
            <div class="error-404-buttons">
                <a href="<?php echo home_url(); ?>" class="error-404-btn-primary">
                    <i class="fas fa-home"></i>
                    トップページへ
                </a>
                <button class="error-404-btn-secondary" onclick="history.back()">
                    <i class="fas fa-arrow-left"></i>
                    前のページへ戻る
                </button>
            </div>

            <!-- 検索フォーム -->
            <div class="error-404-search">
                <h3>お探しの情報を検索</h3>
                <?php get_search_form(); ?>
            </div>

            <!-- 人気ページ（オプション） -->
            <?php
            // 最新の投稿を3件取得
            $recent_posts = new WP_Query(array(
                'posts_per_page' => 3,
                'post_status' => 'publish'
            ));
            
            if ($recent_posts->have_posts()) :
            ?>
            <div class="error-404-links">
                <h3>最近の投稿</h3>
                <ul>
                    <?php while ($recent_posts->have_posts()) : $recent_posts->the_post(); ?>
                    <li>
                        <a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </li>
                    <?php endwhile; wp_reset_postdata(); ?>
                </ul>
            </div>
            <?php endif; ?>

        </div>
    </section>

</main>

<?php get_footer(); ?>