<?php
/**
 * ファイル名: index.php
 * 説明: メインテンプレート・アーカイブ表示
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<?php get_header(); ?>


<?php if (have_posts()) : ?>
    
    <div class="posts-list">
        <?php while (have_posts()) : the_post(); ?>
            
            <article id="post-<?php the_ID(); ?>" <?php post_class('post-item'); ?>>
                <header class="entry-header">
                    <h2 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h2>
                    <div class="entry-meta">
                        <time datetime="<?php echo get_the_date('c'); ?>">
                            <?php echo get_the_date(); ?>
                        </time>
                    </div>
                </header>
                
                <div class="entry-summary">
                    <?php the_excerpt(); ?>
                </div>
                
                <a href="<?php the_permalink(); ?>" class="read-more">続きを読む →</a>
            </article>
            
        <?php endwhile; ?>
    </div>
    
    <div class="pagination">
        <?php
        the_posts_pagination(array(
            'mid_size' => 2,
            'prev_text' => '← 前へ',
            'next_text' => '次へ →',
        ));
        ?>
    </div>
    
<?php else : ?>
    
    <div class="no-posts">
        <h2>投稿が見つかりませんでした</h2>
        <p>申し訳ございません。該当する投稿が見つかりませんでした。</p>
    </div>
    
<?php endif; ?>

<style>
/* Posts List */
.posts-list {
    margin-bottom: 60px;
}

.post-item {
    padding: 40px 0;
    border-bottom: 1px solid #e0e0e0;
}

.post-item:first-child {
    padding-top: 0;
}

/* Entry Header */
.entry-title {
    font-size: 28px;
    margin-bottom: 10px;
}

.entry-title a {
    color: #333;
    text-decoration: none;
    transition: color 0.2s ease;
}

.entry-title a:hover {
    color: #0066cc;
}

.entry-meta {
    color: #666;
    font-size: 14px;
    margin-bottom: 20px;
}

/* Entry Content */
.entry-summary {
    margin-bottom: 20px;
    line-height: 1.8;
    color: #555;
}

.read-more {
    display: inline-block;
    color: #0066cc;
    font-weight: 500;
    text-decoration: none;
}

.read-more:hover {
    text-decoration: underline;
}

/* Pagination */
.pagination {
    text-align: center;
    margin: 40px 0;
}

.pagination .nav-links {
    display: flex;
    justify-content: center;
    gap: 10px;
    flex-wrap: wrap;
}

.pagination a,
.pagination span {
    padding: 8px 16px;
    border: 1px solid #e0e0e0;
    border-radius: 4px;
    text-decoration: none;
    color: #333;
    transition: all 0.2s ease;
}

.pagination a:hover {
    background: #f5f5f5;
    border-color: #0066cc;
}

.pagination .current {
    background: #0066cc;
    color: white;
    border-color: #0066cc;
}

/* No Posts */
.no-posts {
    text-align: center;
    padding: 60px 20px;
}

.no-posts h2 {
    font-size: 24px;
    margin-bottom: 15px;
    color: #333;
}

.no-posts p {
    color: #666;
}

/* Responsive */
@media (max-width: 768px) {
    .posts-list {
        margin-bottom: 40px;
    }
    
    .post-item {
        padding: 30px 0;
    }
    
    .entry-title {
        font-size: 22px;
    }
    
    .pagination .nav-links {
        gap: 5px;
    }
    
    .pagination a,
    .pagination span {
        padding: 6px 12px;
        font-size: 14px;
    }
}
</style>

<?php get_footer(); ?>