<?php
/**
 * ファイル名: page.php
 * 説明: 固定ページテンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<?php get_header(); ?>

<!-- ========== 固定ページ ========== -->
<main class="page-content">
    
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    
    <!-- ページヘッダー -->
    <section class="page-header">
        <div class="page-header-container">
            <h1 class="page-title"><?php the_title(); ?></h1>
            <?php if (get_the_excerpt()) : ?>
                <p class="page-excerpt"><?php echo get_the_excerpt(); ?></p>
            <?php endif; ?>
        </div>
    </section>

    <!-- ページコンテンツ -->
    <section class="page-main">
        <div class="page-container">
            <article class="page-article">
                <div class="page-body">
                    <?php the_content(); ?>
                </div>
                
                <?php
                // ページネーション（複数ページの場合）
                wp_link_pages(array(
                    'before' => '<div class="page-links"><span class="page-links-title">ページ:</span>',
                    'after'  => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ));
                ?>
            </article>
        </div>
    </section>

    <?php endwhile; endif; ?>

</main>

<?php get_footer(); ?>