<?php
/**
 * ファイル名: single.php
 * 説明: 個別投稿テンプレート
 * 
 * @package Etransform
 * @author Etransform
 * @version 1.0.0
 * @license GPL v2 or later
 */
?>

<?php get_header(); ?>

<!-- ========== ブログ記事ページ ========== -->
<main class="single-content">
    
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    
    <!-- 記事ヘッダー -->
    <article id="post-<?php the_ID(); ?>" <?php post_class('single-article'); ?>>
        
        <header class="single-header">
            <div class="single-header-container">
                
                <!-- カテゴリー -->
                <?php
                $categories = get_the_category();
                if (!empty($categories)) :
                ?>
                <div class="single-categories">
                    <?php foreach ($categories as $category) : ?>
                        <a href="<?php echo get_category_link($category->term_id); ?>" class="single-category">
                            <?php echo esc_html($category->name); ?>
                        </a>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                
                <!-- タイトル -->
                <h1 class="single-title"><?php the_title(); ?></h1>
                
                <!-- メタ情報 -->
                <div class="single-meta">
                    <time class="single-date" datetime="<?php echo get_the_date('c'); ?>">
                        <i class="far fa-calendar"></i>
                        <?php echo get_the_date('Y年m月d日'); ?>
                    </time>
                    <?php if (get_the_modified_date('Y-m-d') !== get_the_date('Y-m-d')) : ?>
                    <time class="single-updated" datetime="<?php echo get_the_modified_date('c'); ?>">
                        <i class="far fa-edit"></i>
                        更新: <?php echo get_the_modified_date('Y年m月d日'); ?>
                    </time>
                    <?php endif; ?>
                </div>
                
            </div>
        </header>

        <!-- アイキャッチ画像 -->
        <?php if (has_post_thumbnail()) : ?>
        <div class="single-thumbnail">
            <?php the_post_thumbnail('large'); ?>
        </div>
        <?php endif; ?>

        <!-- 記事本文 -->
        <div class="single-body-wrapper">
            <div class="single-container">
                <div class="single-body">
                    <?php the_content(); ?>
                </div>

                <!-- ページネーション -->
                <?php
                wp_link_pages(array(
                    'before' => '<div class="single-page-links"><span class="page-links-title">ページ:</span>',
                    'after'  => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ));
                ?>

                <!-- タグ -->
                <?php
                $tags = get_the_tags();
                if ($tags) :
                ?>
                <div class="single-tags">
                    <div class="single-tags-label">
                        <i class="fas fa-tags"></i>
                        タグ
                    </div>
                    <div class="single-tags-list">
                        <?php foreach ($tags as $tag) : ?>
                            <a href="<?php echo get_tag_link($tag->term_id); ?>" class="single-tag">
                                <?php echo esc_html($tag->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>

        <!-- 著者情報 -->
        <div class="single-author">
            <div class="single-container">
                <div class="author-box">
                    <div class="author-avatar">
                        <?php echo get_avatar(get_the_author_meta('ID'), 80); ?>
                    </div>
                    <div class="author-info">
                        <h3 class="author-name"><?php the_author(); ?></h3>
                        <?php if (get_the_author_meta('description')) : ?>
                        <p class="author-description">
                            <?php echo esc_html(get_the_author_meta('description')); ?>
                        </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- 前後の記事ナビゲーション -->
        <nav class="single-navigation">
            <div class="single-container">
                <div class="post-navigation">
                    <?php
                    $prev_post = get_previous_post();
                    $next_post = get_next_post();
                    ?>
                    
                    <?php if ($prev_post) : ?>
                    <div class="nav-item nav-prev">
                        <span class="nav-label">
                            <i class="fas fa-chevron-left"></i>
                            前の記事
                        </span>
                        <a href="<?php echo get_permalink($prev_post->ID); ?>" class="nav-link">
                            <?php echo esc_html($prev_post->post_title); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($next_post) : ?>
                    <div class="nav-item nav-next">
                        <span class="nav-label">
                            次の記事
                            <i class="fas fa-chevron-right"></i>
                        </span>
                        <a href="<?php echo get_permalink($next_post->ID); ?>" class="nav-link">
                            <?php echo esc_html($next_post->post_title); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </nav>

    </article>

    <?php endwhile; endif; ?>

</main>

<?php get_footer(); ?>