/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugin.elasticfence.AuthRestFilter;
import org.elasticsearch.plugin.elasticfence.data.UserDataBridge;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class AuthRestHandler
extends BaseRestHandler {
    @Inject
    public AuthRestHandler(Settings settings, RestController restController, Client client) {
        super(settings, restController, client);
        restController.registerHandler(RestRequest.Method.GET, "/_httpuserauth", (RestHandler)this);
        AuthRestFilter filter = new AuthRestFilter(client, settings);
        restController.registerFilter((RestFilter)filter);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        String mode = request.param("mode");
        if (mode == null) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "No Method"));
            return;
        }
        UserDataBridge userDataBridge = new UserDataBridge(client);
        if (!userDataBridge.isInitialized()) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "http user auth initializing..."));
            return;
        }
        if (mode.equals("list")) {
            try {
                String userListJSON = userDataBridge.listUser();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, userListJSON));
            }
            catch (Exception ex) {
                EFLogger.error("failed to create index: ", ex);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to list all users"));
            }
            return;
        }
        if (mode.equals("adduser")) {
            String userName = request.param("username");
            String password = request.param("password");
            try {
                boolean res = userDataBridge.createUser(userName, password);
                if (res) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "User created : " + userName));
                } else {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CONFLICT, "User already exists : " + userName));
                }
                return;
            }
            catch (Exception ex) {
                EFLogger.error("failed to create index: ", ex);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to create index : " + userName));
                return;
            }
        }
        if (mode.equals("addindex")) {
            String userName = request.param("username");
            String indexName = request.param("index");
            try {
                boolean res = userDataBridge.addAuthIndex(userName, indexName);
                if (res) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "added auth index: " + userName));
                } else {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to add auth index: " + userName));
                }
            }
            catch (Exception ex) {
                EFLogger.error("failed to add auth index: ", ex);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to add auth index : " + userName));
                return;
            }
            return;
        }
        if (mode.equals("updateindex")) {
            String userName = request.param("username");
            String indexName = request.param("index");
            try {
                boolean res = userDataBridge.updateAuthIndex(userName, indexName);
                if (res) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "added auth index: " + userName));
                } else {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to add auth index: " + userName));
                }
            }
            catch (Exception ex) {
                EFLogger.error("failed to add auth index: ", ex);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to add auth index : " + userName));
                return;
            }
            return;
        }
        if (mode.equals("passwd")) {
            String newPassword;
            String oldPassword;
            String userName = request.param("username");
            boolean res = userDataBridge.changePassword(userName, oldPassword = request.param("old_password"), newPassword = request.param("new_password"));
            if (res) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "Password changed : " + userName));
            } else {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "Failed to change Password: " + userName));
            }
            return;
        }
        if (mode.equals("deleteuser")) {
            String userName = request.param("username");
            boolean res = userDataBridge.deleteUser(userName);
            if (res) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "deleted user: " + userName));
            } else {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "failed to delete user: " + userName));
            }
            return;
        }
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "Failed"));
    }
}

