/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence.data;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.elasticsearch.common.xcontent.XContentFactory;

public class UserData {
    private String username;
    private String encPassword;
    private Set<String> indexFilters;
    private String created;

    private UserData() {
    }

    public UserData(String userName, String rawPassword) {
        this.setUsername(userName);
        this.setPassword(rawPassword);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        this.setCreated(sdf.format(new Date()));
        Set indices = Sets.newConcurrentHashSet();
        this.setFilters(indices);
    }

    public UserData(String userName, String rawPassword, Set<String> filters) {
        this.setUsername(userName);
        this.setPassword(rawPassword);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        this.setCreated(sdf.format(new Date()));
        if (filters == null) {
            filters = Sets.newConcurrentHashSet();
        }
        this.setFilters(filters);
    }

    public UserData(String userName, String rawPassword, String ... filters) {
        this.setUsername(userName);
        this.setPassword(rawPassword);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        this.setCreated(sdf.format(new Date()));
        if (filters == null) {
            Set filterSet = Sets.newConcurrentHashSet(Arrays.asList(filters));
            this.setFilters(filterSet);
        } else {
            Set filterSet = Sets.newConcurrentHashSet();
            this.setFilters(filterSet);
        }
    }

    public static UserData restoreFromESData(String username, String encPassword, String created, Set<String> indexFilters) {
        UserData user = new UserData();
        user.username = username;
        user.encPassword = encPassword;
        user.created = created;
        user.indexFilters = indexFilters;
        return user;
    }

    public static UserData restoreFromESData(String username, String encPassword, String ... indexFilters) {
        UserData user = new UserData();
        user.username = username;
        user.encPassword = encPassword;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
        user.created = sdf.format(new Date());
        user.indexFilters = Sets.newConcurrentHashSet(Arrays.asList(indexFilters));
        return user;
    }

    public static String encPassword(String rawPassword) {
        return DigestUtils.sha256Hex((String)rawPassword);
    }

    public Set<String> getIndexFilters() {
        return this.indexFilters;
    }

    public void setFilters(Set<String> indexFilters) {
        this.indexFilters = indexFilters;
    }

    public String getPassword() {
        return this.encPassword;
    }

    public void setPassword(String password) {
        this.encPassword = UserData.encPassword(password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public boolean isValidPassword(String rawPassword) {
        return this.encPassword.equals(UserData.encPassword(rawPassword));
    }

    public String toJSON() {
        if (this.created == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
            this.created = sdf.format(new Date());
        }
        try {
            return XContentFactory.jsonBuilder().startObject().field("username", this.username).field("password", this.encPassword).field("indices", this.indexFilters).field("created", this.created).endObject().string();
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

