/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence;

import java.net.InetSocketAddress;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.plugin.elasticfence.IPAuthenticator;
import org.elasticsearch.plugin.elasticfence.UserAuthenticator;
import org.elasticsearch.plugin.elasticfence.data.UserDataBridge;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.plugin.elasticfence.parser.RequestParser;
import org.elasticsearch.plugin.elasticfence.tool.RequestAnalyzer;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class AuthRestFilter
extends RestFilter {
    Client client;
    Settings settings;

    public AuthRestFilter(Client client, Settings settings) {
        this.settings = settings;
        this.client = client;
    }

    public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) throws Exception {
        block11: {
            try {
                UserDataBridge userDataBridge;
                String ipaddr = ((InetSocketAddress)request.getRemoteAddress()).getAddress().getHostAddress();
                IPAuthenticator ipAuthenticator = new IPAuthenticator();
                if (ipAuthenticator.isWhitelisted(ipaddr)) {
                    filterChain.continueProcessing(request, channel);
                    return;
                }
                if (ipAuthenticator.isBlacklisted(ipaddr)) {
                    EFLogger.error("Request from IP is blacklisted: " + ipaddr);
                    BytesRestResponse resp = new BytesRestResponse(RestStatus.FORBIDDEN, "Forbidden IP");
                    channel.sendResponse((RestResponse)resp);
                    return;
                }
                RequestAnalyzer requestAnalyzer = new RequestAnalyzer(request);
                String username = requestAnalyzer.getUsername();
                String password = requestAnalyzer.getPassword();
                if (username == null || password == null) {
                    BytesRestResponse resp = new BytesRestResponse(RestStatus.UNAUTHORIZED, "Needs Basic Auth");
                    resp.addHeader("WWW-Authenticate", "Basic realm=\"Http User Auth Plugin\"");
                    channel.sendResponse((RestResponse)resp);
                    EFLogger.info("auth failed: " + request.path());
                    return;
                }
                if (!username.equals("root") && !(userDataBridge = new UserDataBridge(this.client)).isInitialized()) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "http user auth initializing..."));
                    return;
                }
                EFLogger.debug("request.path(): " + request.path());
                UserAuthenticator userAuth = new UserAuthenticator(username, password);
                RequestParser parser = new RequestParser(request, this.settings);
                if (userAuth.isValidUser()) {
                    boolean isAccessible = false;
                    isAccessible = userAuth.isAccessibleIndices(parser);
                    if (isAccessible) {
                        try {
                            filterChain.continueProcessing(request, channel);
                        }
                        catch (IndexNotFoundException infe) {
                            EFLogger.debug("index not found: " + request.path());
                        }
                        catch (Exception ex) {
                            EFLogger.error("exception occurred: " + request.path(), ex);
                        }
                        return;
                    }
                    EFLogger.debug("forbidden path: " + request.path());
                    BytesRestResponse resp = new BytesRestResponse(RestStatus.FORBIDDEN, "Forbidden path");
                    channel.sendResponse((RestResponse)resp);
                    break block11;
                }
                BytesRestResponse resp = new BytesRestResponse(RestStatus.UNAUTHORIZED, "Needs Basic Auth");
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Http User Auth Plugin\"");
                channel.sendResponse((RestResponse)resp);
                EFLogger.info("Invalid User: " + request.path());
            }
            catch (Exception ex) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ""));
                EFLogger.error("", ex);
            }
        }
    }
}

