/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence;

import java.util.Arrays;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugin.elasticfence.AuthRestHandler;
import org.elasticsearch.plugin.elasticfence.IPAuthenticator;
import org.elasticsearch.plugin.elasticfence.UserAuthenticator;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;

public class ElasticfencePlugin
extends Plugin {
    private final Settings settings;

    public ElasticfencePlugin(Settings settings) {
        this.settings = settings;
        EFLogger.info("loading elasticfence plugin...");
    }

    public String description() {
        return "Elasticfence plugin";
    }

    public String name() {
        return "Elasticfence";
    }

    public void onModule(RestModule module) {
        String isPluginDisabled = this.getSettingString("disabled");
        if (isPluginDisabled != null && isPluginDisabled.equals("true")) {
            EFLogger.warn("Elasticfence plugin is disabled");
        } else {
            String rootPassword = this.getSettingString("root.password");
            if (rootPassword != null && !rootPassword.equals("")) {
                UserAuthenticator.setRootPassword(rootPassword);
                UserAuthenticator.loadRootUserDataCacheOnStart();
            }
            Object[] whitelist = this.getSettingArray("whitelist", new String[]{"127.0.0.1"});
            Object[] blacklist = this.getSettingArray("blacklist", new String[0]);
            if (whitelist != null) {
                IPAuthenticator.setWhitelist((String[])whitelist);
                EFLogger.warn("elasticfence plugin IP whitelist enabled " + Arrays.toString(whitelist));
            }
            if (blacklist != null) {
                IPAuthenticator.setBlacklist((String[])blacklist);
                EFLogger.warn("elasticfence plugin IP blacklist enabled " + Arrays.toString(blacklist));
            }
            module.addRestAction(AuthRestHandler.class);
            EFLogger.info("elasticfence plugin is enabled");
        }
    }

    private String getSettingString(String key) {
        String flag = this.settings.get("elasticfence." + key);
        EFLogger.info("elasticfence." + key + ": " + flag);
        if (flag == null) {
            flag = this.settings.get("http.user.auth." + key);
            EFLogger.info("http.user.auth." + key + ": " + flag);
            EFLogger.warn("\"http.user.auth." + key + "\" is deprecated. Please replace with \"elasticfence." + key + "\"");
        }
        return flag;
    }

    private String[] getSettingArray(String key, String[] defaultValue) {
        String[] flag = this.settings.getAsArray("elasticfence." + key);
        if (flag == null || flag.length == 0) {
            flag = this.settings.getAsArray("http.user.auth." + key);
            EFLogger.warn("\"http.user.auth." + key + "\" is deprecated. Please replace with \"elasticfence." + key + "\"");
        }
        if (flag == null || flag.length == 0) {
            return defaultValue;
        }
        return flag;
    }
}

