/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.plugin.elasticfence.UserAuthenticator;
import org.elasticsearch.plugin.elasticfence.data.UserData;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.search.SearchHit;

public class UserDataBridge {
    private static final String HTTP_USER_AUTH_INDEX = ".http_user_auth";
    private static final String HTTP_USER_AUTH_TYPE = "user";
    private static boolean isInitialized = false;
    private Client client;

    public UserDataBridge(Client client) {
        this.client = client;
        if (!isInitialized && !this.createIndexIfEmpty()) {
            EFLogger.error("failed to create index: .http_user_auth");
        }
    }

    public boolean isInitialized() {
        if (!isInitialized) {
            this.reloadUserDataCache();
        }
        return isInitialized;
    }

    public String listUser() {
        String response = "[";
        List<UserData> allUserData = this.getAllUserData();
        for (UserData userData : allUserData) {
            response = String.valueOf(response) + userData.toJSON() + ",";
        }
        if (allUserData.size() > 0) {
            response = response.substring(0, response.length() - 1);
        }
        response = String.valueOf(response) + "]";
        return response;
    }

    public boolean createUser(String userName, String password) {
        if (userName == null || userName.equals("")) {
            return false;
        }
        if ((userName = userName.toLowerCase()).equals("root")) {
            return false;
        }
        UserData user = this.getUser(userName);
        if (user != null) {
            EFLogger.error("username " + userName + " is already registered");
            return false;
        }
        user = new UserData(userName, password);
        this.putUser(user);
        return true;
    }

    public boolean addAuthIndex(String userName, String indexName) {
        String[] indexNames;
        if (userName == null || userName.equals("") || indexName == null || indexName.equals("")) {
            return false;
        }
        userName = userName.toLowerCase();
        indexName = indexName.toLowerCase();
        if (userName.equals("root")) {
            return false;
        }
        UserData user = this.getUser(userName);
        if (user == null) {
            return false;
        }
        Set<String> indexFilters = user.getIndexFilters();
        String[] stringArray = indexNames = indexName.split(",");
        int n = indexNames.length;
        int n2 = 0;
        while (n2 < n) {
            String index = stringArray[n2];
            if ((index = index.trim()) != null && !index.equals("")) {
                if (index.charAt(0) != '/') {
                    index = "/" + index;
                }
                if (!index.equals("/*")) {
                    indexFilters.add(index);
                }
            }
            ++n2;
        }
        user.setFilters(indexFilters);
        return this.putUser(user);
    }

    public boolean updateAuthIndex(String userName, String indexName) {
        String[] indexNames;
        if (userName == null || userName.equals("") || indexName == null || indexName.equals("")) {
            return false;
        }
        userName = userName.toLowerCase();
        indexName = indexName.toLowerCase();
        if (userName.equals("root")) {
            return false;
        }
        UserData user = this.getUser(userName);
        if (user == null) {
            return false;
        }
        CopyOnWriteArraySet indexFilters = Sets.newCopyOnWriteArraySet();
        String[] stringArray = indexNames = indexName.split(",");
        int n = indexNames.length;
        int n2 = 0;
        while (n2 < n) {
            String index = stringArray[n2];
            if ((index = index.trim()) != null && !index.equals("")) {
                if (index.charAt(0) != '/') {
                    index = "/" + index;
                }
                if (!index.equals("/*")) {
                    indexFilters.add(index);
                }
            }
            ++n2;
        }
        user.setFilters(indexFilters);
        return this.putUser(user);
    }

    public boolean removeAuth(String userName, String password, String indexName) {
        if (userName == null || userName.equals("") || indexName == null || indexName.equals("")) {
            return false;
        }
        userName = userName.toLowerCase();
        indexName = indexName.toLowerCase();
        if (userName.equals("root")) {
            return false;
        }
        UserData user = this.getUser(userName);
        if (user == null) {
            return false;
        }
        if (user.isValidPassword(password)) {
            Set<String> indices = user.getIndexFilters();
            if (indexName.charAt(0) != '/') {
                indexName = "/" + indexName;
            }
            if (indices.contains(indexName)) {
                indices.remove(indexName);
                this.putUser(user);
                return true;
            }
        }
        return false;
    }

    public boolean changePassword(String userName, String oldPassword, String newPassword) {
        UserData user = this.getUser(userName);
        if (user == null) {
            return false;
        }
        if (user.isValidPassword(oldPassword)) {
            user.setPassword(newPassword);
            this.putUser(user);
            return true;
        }
        return false;
    }

    private boolean putUser(UserData user) {
        String created = "";
        if (user.getCreated() == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
            created = sdf.format(new Date());
        } else {
            created = user.getCreated();
        }
        try {
            this.client.prepareIndex(HTTP_USER_AUTH_INDEX, HTTP_USER_AUTH_TYPE, user.getUsername()).setSource(XContentFactory.jsonBuilder().startObject().field("username", user.getUsername()).field("password", user.getPassword()).field("indices", user.getIndexFilters()).field("created", created).endObject()).setRefresh(true).execute().get();
            this.reloadUserDataCache();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            EFLogger.error("InterruptedException | ExecutionException", e);
        }
        catch (ElasticsearchException e) {
            EFLogger.error("ElasticsearchException", (Exception)((Object)e));
        }
        catch (IOException e) {
            EFLogger.error("IOException", e);
        }
        return false;
    }

    private UserData getUser(String userName) {
        GetResponse response = null;
        try {
            response = (GetResponse)((GetRequestBuilder)this.client.prepareGet(HTTP_USER_AUTH_INDEX, HTTP_USER_AUTH_TYPE, userName).setOperationThreaded(false)).execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            EFLogger.error("InterruptedException | ExecutionException", e);
        }
        if (response != null && response.isExists()) {
            return this.getUserDataFromESSource(response.getSource());
        }
        return null;
    }

    public boolean deleteUser(String userName) {
        DeleteResponse response = null;
        try {
            response = (DeleteResponse)this.client.prepareDelete(HTTP_USER_AUTH_INDEX, HTTP_USER_AUTH_TYPE, userName).setRefresh(true).execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            EFLogger.error("InterruptedException | ExecutionException", e);
        }
        if (response != null && response.isFound()) {
            this.reloadUserDataCache();
            return true;
        }
        return false;
    }

    private boolean createIndexIfEmpty() {
        IndicesExistsResponse res = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{HTTP_USER_AUTH_INDEX}).execute().actionGet();
        if (res.isExists()) {
            return true;
        }
        CreateIndexRequest request = new CreateIndexRequest(HTTP_USER_AUTH_INDEX);
        CreateIndexResponse resp = (CreateIndexResponse)this.client.admin().indices().create(request).actionGet();
        if (resp.isAcknowledged()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void reloadUserDataCache() {
        List<UserData> userDataList = this.getAllUserData();
        if (userDataList == null) {
            return;
        }
        UserAuthenticator.reloadUserDataCache(userDataList);
        isInitialized = true;
    }

    private List<UserData> getAllUserData() {
        try {
            SearchResponse res = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{HTTP_USER_AUTH_INDEX}).setTypes(new String[]{HTTP_USER_AUTH_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(100).execute().get();
            if (res.getFailedShards() == 0 && res.getHits() != null && res.getHits().hits() != null) {
                CopyOnWriteArrayList userDataList = Lists.newCopyOnWriteArrayList();
                SearchHit[] hits = res.getHits().hits();
                int i = 0;
                while (i < hits.length) {
                    SearchHit hit = hits[i];
                    userDataList.add(this.getUserDataFromESSource(hit.getSource()));
                    ++i;
                }
                return userDataList;
            }
            EFLogger.error("Failed to get data from some shards");
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            EFLogger.error("InterruptedException | ExecutionException", e);
        }
        catch (Exception ex) {
            EFLogger.error("failed to load all user info", ex);
        }
        return null;
    }

    private UserData getUserDataFromESSource(Map<String, Object> source) {
        Set indices;
        String userName = (String)source.get("username");
        String password = (String)source.get("password");
        String created = (String)source.get("created");
        if (source.containsKey("indices")) {
            List indicesList = (List)source.get("indices");
            indices = Sets.newConcurrentHashSet((Iterable)indicesList);
        } else {
            indices = Sets.newConcurrentHashSet();
        }
        return UserData.restoreFromESData(userName, password, created, indices);
    }
}

