/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.plugin.elasticfence.data.UserData;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.plugin.elasticfence.parser.RequestParser;

public class UserAuthenticator {
    private static String rootPassword = "";
    private static Map<String, UserData> users = Maps.newConcurrentMap();
    private UserData user;

    public UserAuthenticator(String username, String rawPassword) {
        if (users.containsKey(username) && users.get(username).isValidPassword(rawPassword)) {
            this.user = users.get(username);
        }
    }

    public boolean isValidUser() {
        return this.user != null;
    }

    public boolean isAccessibleIndices(RequestParser parser) {
        if (this.user == null) {
            return false;
        }
        if (this.user.getUsername().equals("root")) {
            return true;
        }
        Set<String> filters = this.user.getIndexFilters();
        String apiName = parser.getApiName();
        List<String> indices = parser.getIndicesInPath();
        if (indices.contains("/*")) {
            return false;
        }
        switch (apiName) {
            case "_msearch": {
                try {
                    indices = parser.getIndicesFromMsearchRequestBody();
                    return this.checkIndicesWithFilters(indices, filters);
                }
                catch (Exception e) {
                    EFLogger.error("", e);
                    return false;
                }
            }
            case "_mget": {
                try {
                    indices = parser.getIndicesFromMgetRequestBody();
                    return this.checkIndicesWithFilters(indices, filters);
                }
                catch (Exception e) {
                    EFLogger.error("", e);
                    return false;
                }
            }
            case "_bulk": {
                try {
                    indices = parser.getIndicesFromBulkRequestBody();
                    return this.checkIndicesWithFilters(indices, filters);
                }
                catch (Exception e) {
                    EFLogger.error("", e);
                    return false;
                }
            }
        }
        if (this.isKibanaRequest(parser.getPath()) && this.isAccessibleUserToKibana(filters)) {
            return true;
        }
        if (indices.contains("/") && !apiName.equals("")) {
            return false;
        }
        return this.checkIndicesWithFilters(indices, filters);
    }

    private boolean checkIndicesWithFilters(List<String> indices, Set<String> filters) {
        for (String index : indices) {
            boolean passed = false;
            for (String filter : filters) {
                if (!this.ifFilterCoversIndex(index, filter)) continue;
                passed = true;
                break;
            }
            if (passed) continue;
            return false;
        }
        return true;
    }

    private boolean isKibanaRequest(String requestPath) {
        String index = UserAuthenticator.normalizeUrlPath(requestPath);
        return requestPath.equals("/") || requestPath.equals("/_nodes") || index.equals("/.kibana") || requestPath.equals("/_cluster/health/.kibana");
    }

    private boolean isAccessibleUserToKibana(Set<String> filters) {
        return filters.contains("/.kibana");
    }

    public boolean execAuth(String path) {
        if (this.user == null) {
            return false;
        }
        if (this.user.getUsername().equals("root")) {
            return true;
        }
        if (path.equals("/*")) {
            return false;
        }
        String index = UserAuthenticator.normalizeUrlPath(path);
        for (String filter : this.user.getIndexFilters()) {
            if (!this.ifFilterCoversIndex(index, filter)) continue;
            return true;
        }
        return false;
    }

    public static void loadRootUserDataCacheOnStart() {
        EFLogger.debug("loadRootUserDataCacheOnStart");
        users.put("root", UserData.restoreFromESData("root", rootPassword, "/*"));
    }

    public static void reloadUserDataCache(List<UserData> userDataList) {
        ConcurrentMap users = Maps.newConcurrentMap();
        if (userDataList != null) {
            for (UserData userData : userDataList) {
                users.put(userData.getUsername(), userData);
            }
        }
        users.put("root", UserData.restoreFromESData("root", rootPassword, "/*"));
        UserAuthenticator.users = users;
    }

    public static void setRootPassword(String rootPassword) {
        if (rootPassword == null) {
            rootPassword = "";
        }
        UserAuthenticator.rootPassword = UserData.encPassword(rootPassword);
    }

    public static String getRootPassword() {
        if (rootPassword == null) {
            return "";
        }
        return rootPassword;
    }

    private boolean ifFilterCoversIndex(String index, String filter) {
        if (index.startsWith("/")) {
            index = index.substring(1);
        }
        if (filter.startsWith("/")) {
            filter = filter.substring(1);
        }
        if (index.equals(filter)) {
            return true;
        }
        if (index.equals("") || filter.equals("")) {
            return filter.equals("") && index.equals("");
        }
        if (!filter.contains("*")) {
            if (index.equals("*")) {
                return true;
            }
            return index.equals(filter);
        }
        if (index.contains("*")) {
            return index.equals(filter);
        }
        String regexStr = "";
        if (!filter.startsWith("*")) {
            regexStr = "^";
        }
        String[] splitStrArr = filter.split("\\*");
        int i = 0;
        while (i < splitStrArr.length) {
            regexStr = i < splitStrArr.length - 1 ? (splitStrArr[i].equals("") ? String.valueOf(regexStr) + ".*?" : String.valueOf(regexStr) + Pattern.quote(splitStrArr[i]) + ".*?") : String.valueOf(regexStr) + Pattern.quote(splitStrArr[i]);
            ++i;
        }
        regexStr = filter.endsWith("*") ? String.valueOf(regexStr) + ".*?$" : String.valueOf(regexStr) + "$";
        Pattern p = Pattern.compile(regexStr);
        Matcher m = p.matcher(index);
        return m.find();
    }

    private static String normalizeUrlPath(String path) {
        if (path.equals("") || path.charAt(0) != '/') {
            path = "/" + path;
        }
        try {
            URI uri = URI.create(path);
            uri = uri.normalize();
            path = uri.toString();
        }
        catch (IllegalArgumentException ex) {
            EFLogger.error("Illegal path: " + path);
            return null;
        }
        catch (Exception ex) {
            EFLogger.error("invalid path: " + path);
            return null;
        }
        if (path.equals("")) {
            return "/";
        }
        if (path.equals("/")) {
            return "/";
        }
        String[] pathInfo = path.split("/");
        String index = "";
        String[] stringArray = pathInfo;
        int n = pathInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (!str.equals("")) {
                index = str;
                break;
            }
            ++n2;
        }
        if (index.startsWith("_")) {
            return "/";
        }
        return "/" + index;
    }
}

