/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.elasticfence.parser;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.plugin.elasticfence.logger.EFLogger;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;

public class RequestParser {
    private RestRequest request;
    private Settings settings;
    private boolean isInitialized = false;
    private String apiName;
    private String path;
    private String indexInPath;
    private List<String> indicesInPath;
    private String normalizedPath;

    public RequestParser(RestRequest request, Settings settings) {
        this.path = request.path();
        this.request = request;
        this.settings = settings;
    }

    private void initialize() {
        if (!this.isInitialized) {
            this.normalizedPath = RequestParser.normalizePath(this.request.path());
            this.indexInPath = RequestParser.extractIndexFromPath(this.normalizedPath);
            this.indicesInPath = RequestParser.extractIndicesFromPath(this.normalizedPath);
            this.apiName = RequestParser.extractApiNameFrom(this.normalizedPath);
            this.isInitialized = true;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getApiName() {
        this.initialize();
        return this.apiName;
    }

    public List<String> getIndicesInPath() {
        this.initialize();
        return this.indicesInPath;
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getIndicesFromBulkRequestBody() throws Exception {
        allowExplicitIndex = this.settings.getAsBoolean("rest.action.multi.allow_explicit_index", Boolean.valueOf(true));
        data = RestActions.getRestContent((RestRequest)this.request);
        indices = new ArrayList<String>();
        xContent = XContentFactory.xContent((BytesReference)data);
        from = 0;
        length = data.length();
        marker = xContent.streamSeparator();
        while ((nextMarker = RequestParser.findNextMarker(marker, from, data, length)) != -1) {
            var9_9 = null;
            var10_11 = null;
            try {
                parser = xContent.createParser(data.slice(from, nextMarker - from));
                from = nextMarker + 1;
                token = parser.nextToken();
                if (token != null) ** GOTO lbl21
                if (parser == null) continue;
                parser.close();
                continue;
lbl21:
                // 1 sources

                if (!RequestParser.$assertionsDisabled && token != XContentParser.Token.START_OBJECT) {
                    throw new AssertionError();
                }
                token = parser.nextToken();
                if (!RequestParser.$assertionsDisabled && token != XContentParser.Token.FIELD_NAME) {
                    throw new AssertionError();
                }
                action = parser.currentName();
                index = this.indexInPath;
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue() || !"_index".equals(currentFieldName)) continue;
                        if (!allowExplicitIndex) {
                            throw new IllegalArgumentException("explicit index in bulk is not allowed");
                        }
                        index = "/" + parser.text();
                        if (indices.contains(index)) continue;
                        indices.add(index);
                    }
                }
                if ("delete".equals(action)) continue;
                nextMarker = RequestParser.findNextMarker(marker, from, data, length);
                if (nextMarker != -1) ** GOTO lbl50
                if (parser == null) break;
                parser.close();
                try {
                    break;
lbl50:
                    // 1 sources

                    from = nextMarker + 1;
                }
                catch (Throwable var9_10) {
                    throw var9_10;
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            catch (Throwable var10_12) {
                if (var9_9 == null) {
                    var9_9 = var10_12;
                } else if (var9_9 != var10_12) {
                    var9_9.addSuppressed(var10_12);
                }
                throw var9_9;
            }
        }
        return indices;
    }

    public List<String> getIndicesFromMgetRequestBody() throws Exception {
        boolean allowExplicitIndex = this.settings.getAsBoolean("rest.action.multi.allow_explicit_index", Boolean.valueOf(true));
        ArrayList<String> indices = new ArrayList<String>();
        BytesReference data = RestActions.getRestContent((RestRequest)this.request);
        Throwable throwable = null;
        Object var5_6 = null;
        try (XContentParser parser = XContentFactory.xContent((BytesReference)data).createParser(data);){
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY || !"docs".equals(currentFieldName)) continue;
                indices.addAll(this.parseDocuments(parser, this.indexInPath, allowExplicitIndex));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return indices;
    }

    private List<String> parseDocuments(XContentParser parser, @Nullable String defaultIndex, boolean allowExplicitIndex) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        ArrayList<String> indices = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("docs array element should include an object");
            }
            String index = defaultIndex;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue() || !"_index".equals(currentFieldName)) continue;
                if (!allowExplicitIndex) {
                    throw new IllegalArgumentException("explicit index in multi get is not allowed");
                }
                index = "/" + parser.text();
                if (indices.contains(index)) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    public List<String> getIndicesFromMsearchRequestBody() throws Exception {
        this.initialize();
        boolean allowExplicitIndex = this.settings.getAsBoolean("rest.action.multi.allow_explicit_index", Boolean.valueOf(true));
        List<String> indexList = this.parseMsearchRequestBody(RestActions.getRestContent((RestRequest)this.request), allowExplicitIndex);
        return indexList;
    }

    private List<String> parseMsearchRequestBody(BytesReference data, boolean allowExplicitIndex) throws Exception {
        int nextMarker;
        ArrayList<String> indexList = new ArrayList<String>();
        XContent xContent = XContentFactory.xContent((BytesReference)data);
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = RequestParser.findNextMarker(marker, from, data, length)) != -1) {
            if (nextMarker == 0) {
                from = nextMarker + 1;
                continue;
            }
            IndicesOptions defaultOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
            if (nextMarker - from > 0) {
                Throwable throwable = null;
                Object var11_12 = null;
                try (XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));){
                    Map source = parser.map();
                    for (Map.Entry entry : source.entrySet()) {
                        Object value = entry.getValue();
                        if (!"index".equals(entry.getKey()) && !"indices".equals(entry.getKey())) continue;
                        if (!allowExplicitIndex) {
                            throw new IllegalArgumentException("explicit index in multi percolate is not allowed");
                        }
                        String[] stringArray = XContentMapValues.nodeStringArrayValue(value);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String index = stringArray[n2];
                            if (!indexList.contains(index = "/" + index)) {
                                indexList.add(index);
                            }
                            ++n2;
                        }
                    }
                    defaultOptions = IndicesOptions.fromMap((Map)source, (IndicesOptions)defaultOptions);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if ((nextMarker = RequestParser.findNextMarker(marker, from = nextMarker + 1, data, length)) == -1) break;
            from = nextMarker + 1;
        }
        return indexList;
    }

    private static int findNextMarker(byte marker, int from, BytesReference data, int length) {
        int i = from;
        while (i < length) {
            if (data.get(i) == marker) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static List<String> extractIndicesFromPath(String normalizedPath) {
        String[] parts = normalizedPath.split("/");
        String indexStr = "";
        ArrayList indices = Lists.newArrayList();
        String[] stringArray = parts;
        if (parts.length != 0) {
            String part = stringArray[0];
            if (part.indexOf(95) == 0) {
                indices.add("/");
                return indices;
            }
            indexStr = part;
        }
        if (indexStr.indexOf(44) >= 0) {
            String[] stringArray2 = indexStr.split(",");
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String index = stringArray2[n2];
                if (!indices.contains(index = "/" + index)) {
                    indices.add(index);
                }
                ++n2;
            }
        } else {
            indices.add("/" + indexStr);
        }
        return indices;
    }

    private static String extractIndexFromPath(String normalizedPath) {
        String[] parts = normalizedPath.split("/");
        String indexStr = "";
        String[] stringArray = parts;
        if (parts.length != 0) {
            String part = stringArray[0];
            if (part.indexOf(95) == 0) {
                return "/";
            }
            indexStr = part;
        }
        return indexStr;
    }

    private static String extractApiNameFrom(String normalizedPath) {
        String[] parts;
        String[] stringArray = parts = normalizedPath.split("/");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.indexOf(95) == 0) {
                return part;
            }
            ++n2;
        }
        return "";
    }

    private static String normalizePath(String path) {
        try {
            URI uri = URI.create(path);
            uri = uri.normalize();
            path = uri.toString();
        }
        catch (IllegalArgumentException ex) {
            EFLogger.error("Illegal path: " + path);
            return "";
        }
        catch (Exception ex) {
            EFLogger.error("invalid path: " + path);
            return "";
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }
}

