# -*- coding: UTF-8 -*-
#from __future__ import division
import sys,re,os
import six
from six.moves import urllib_parse

from Cryptodome.Cipher import AES
from Cryptodome.Hash import SHA256

import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs
if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
else:
    from resources.lib.cmf2 import parseDOM

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.nephilim.toons')

PATH            = addon.getAddonInfo('path')
if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'

exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])#[0]

MAIN_URL ='https://kimcartoon.to' 

fsortv = addon.getSetting('fsortV')
fsortn = addon.getSetting('fsortN') if fsortv else 'alphabet'




UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.66 Safari/537.36'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()

def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):

    if six.PY3:    
        list_item = xbmcgui.ListItem(name)

    else:
        list_item = xbmcgui.ListItem(name, iconImage=image, thumbnailImage=image)

    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')    
    if not infoLabels:
        infoLabels={'title': name}    
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    
def home():

    add_item('', 'Alphabet', ikona, "listalph",fanart=FANART, folder=True)
    add_item('', 'Genres', ikona, "listgenres",fanart=FANART, folder=True)

    add_item('', '[COLOR lightblue]Search[/COLOR]', 'DefaultAddonsSearch.png', "search", folder=True)   
def ListGenres():
    dt="""
    <a href="https://kimcartoon.to/Genre/Action">Action</a> 
    <a href="https://kimcartoon.to/Genre/Adventure">Adventure</a> 
    <a href="https://kimcartoon.to/Genre/Biography">Biography</a> 
    <a href="https://kimcartoon.to/Genre/Comedy">Comedy</a> 
    <a href="https://kimcartoon.to/Genre/Crime">Crime</a> 
    <a href="https://kimcartoon.to/Genre/Documentary">Documentary</a> 
    <a href="https://kimcartoon.to/Genre/Drama">Drama</a> 
    <a href="https://kimcartoon.to/Genre/Epic">Epic</a> 
    <a href="https://kimcartoon.to/Genre/Family">Family</a> 
    <a href="https://kimcartoon.to/Genre/Fantasy">Fantasy</a> 
    <a href="https://kimcartoon.to/Genre/Game-Show">Game-Show</a> 
    <a href="https://kimcartoon.to/Genre/History">History</a> 
    <a href="https://kimcartoon.to/Genre/Horror">Horror</a> 
    <a href="https://kimcartoon.to/Genre/Movie">Movie</a> 
    <a href="https://kimcartoon.to/Genre/Music">Music</a> 
    <a href="https://kimcartoon.to/Genre/Musical">Musical</a> 
    <a href="https://kimcartoon.to/Genre/Mystery">Mystery</a> 
    <a href="https://kimcartoon.to/Genre/Preschool">Preschool</a> 
    <a href="https://kimcartoon.to/Genre/Romance">Romance</a> 
    <a href="https://kimcartoon.to/Genre/Sci-Fi">Sci-Fi</a> 
    <a href="https://kimcartoon.to/Genre/Short">Short</a> 
    <a href="https://kimcartoon.to/Genre/Sport">Sport</a> 
    <a href="https://kimcartoon.to/Genre/Supernatural">Supernatural</a> 
    <a href="https://kimcartoon.to/Genre/Thriller">Thriller</a> 
    <a href="https://kimcartoon.to/Genre/War">War</a>
    """
    add_item('', "[COLOR lightblue]Sorting by:[/COLOR] [B]"+fsortn+'[/B]', ikona, 'sort',fanart=FANART, folder=False)
    for href,tyt in re.findall('href="([^"]+).+?>([^<]+)',dt,re.DOTALL):

        add_item(href, tyt,ikona, 'listsubsmov',fanart=FANART, folder=True)
    xbmcplugin.endOfDirectory(addon_handle)


def ListAlphabet():
    dt="""
        href="/CartoonList">All< href="/CartoonList?c=0">#<
        href="/CartoonList?c=a">A</a>| <a href="/CartoonList?c=b">B<
        href="/CartoonList?c=c">C< href="/CartoonList?c=d">D<
        href="/CartoonList?c=e">E</a> |<a href="/CartoonList?c=f">F<
        href="/CartoonList?c=g">G< href="/CartoonList?c=h">H</a>|
        href="/CartoonList?c=i">I< href="/CartoonList?c=j">J<
        href="/CartoonList?c=k">K</a>| <a href="/CartoonList?c=l">L<
        href="/CartoonList?c=m">M< href="/CartoonList?c=n">N</a>|
        href="/CartoonList?c=o">O< href="/CartoonList?c=p">P<
        href="/CartoonList?c=q">Q</a>| <a href="/CartoonList?c=r">R<
        href="/CartoonList?c=s">S< href="/CartoonList?c=t">T</a>|
        href="/CartoonList?c=u">U< href="/CartoonList?c=v">V<
        href="/CartoonList?c=w">W</a>| <a href="/CartoonList?c=x">X<
        href="/CartoonList?c=y">Y< href="/CartoonList?c=z">Z</a>
        """
    add_item('', "[COLOR lightblue]Sorting by:[/COLOR] [B]"+fsortn+'[/B]', ikona, 'sort',fanart=FANART, folder=False)
    for href,tyt in re.findall('href="([^"]+).+?>([^<]+)',dt,re.DOTALL):
        href = MAIN_URL+href
        
        add_item(href, tyt,ikona, 'listsubsmov',fanart=FANART, folder=True)
    xbmcplugin.endOfDirectory(addon_handle)

def ListLinks(exlink):
    pagination=None
    links=getLinks(exlink)
    
    itemz=links
    items = len(links)
    if items>0:
        for f in itemz:
            modemy='playLink'
            isplay=True
            fold=False
            add_item(name=f.get('title'), url=f.get('href'), mode=modemy, image=f.get('img'), infoLabels={'title':f.get('title'), 'code':f.get('code'),'plot':f.get('plot'),'genre':f.get('genre')}, itemcount=items,folder=fold, IsPlayable=isplay)    
        
        if pagination:
            add_item(name='[COLOR blue]>> next page >>[/COLOR]', url=exlink, mode='listsubsmov', image=RESOURCES+'right.png', page=pagination,fanart=FANART, folder=True)        
    
        xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]No links for this video.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)

def getLinks(url):
    out=[]
    url=url.replace('\xc2\xa1','%C2%A1')

    html=getUrlReqOk(url)

    servers =  parseDOM(html,'select', attrs={'id': "selectServer"})[0]#select id="id" 
    zz=re.findall('value="([^"]+).*?>([^<]+)',servers,re.DOTALL)
    for href,serv in zz:
        href= PLchar(href).replace('\xc2\xa1','%C2%A1')

        href = MAIN_URL + href if href.startswith('/') else href

        tit = nazwa.replace('\xc2\xa1','!')

        tyt = PLchar(tit) +' - [I][COLOR orange]'+serv+'[/I][/COLOR]' # ok = PLchar(tit)

        out.append({'title':tyt,'href':href,'img':rys,'year':'','plot':tyt,'genre':'','code':''})    

    return out
def getKey(ab,key):
    import base64

    gg=re.findall('getSecretKey"];var (.+?)=',ab,re.DOTALL)
    check =re.findall('(function x951)',ab,re.DOTALL)
    if check:
        try:
            par1,kon = re.findall('%s \+=\s*"(.+?)"'%gg[0],ab,re.DOTALL)#[0]
        except:
            try:
                kon = re.findall('%s \+=\s*"(.+?)"'%gg[0],ab,re.DOTALL)[0]
                par1=''
            except:
                par1=''
                kon=''
        key+=par1
    
        a1,a2,a3 = re.findall('function x951\((.+?),(.+?)\)\{(.+?)\}',ab,re.DOTALL)[0]
        cdn = re.findall('%s\+"(.*?);'%a2,a3,re.DOTALL)[0].replace('"+"','').replace('"','')
    
        qq=re.findall('%s = x951\((.*?)\)'%gg[0],ab,re.DOTALL)[0]
        qq1=re.findall('"([^"]+)"',qq,re.DOTALL)[0]
        
        dobase1,dobase2=re.findall('=\["([^"]+)"\];\(function',ab,re.DOTALL)#[0]
        bb=base64.b64decode(dobase1)
        if six.PY3:
            bb= bb.decode(encoding='utf-8', errors='strict') 
       # else:
       # @    content = content
        key = qq1+bb+key+cdn+kon
    else:
        dobase2=re.findall('=\["([^"]+)"\];\(function',ab,re.DOTALL)[0]

    
    part2 = base64.b64decode(dobase2)
    if six.PY3:
        part2= part2.decode(encoding='utf-8', errors='strict') 
    dokey=re.findall('= x952\((.*?)</script>',ab,re.DOTALL)[0] 
    p1,p2 = re.findall('"(.+?)"',dokey,re.DOTALL)
    key = p1+part2+key+p2
    return key


def StreamSelectDecode(url):


    headers = {
        'User-Agent': UA,
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Content-Type': 'application/x-www-form-urlencoded',
        'X-Requested-With': 'XMLHttpRequest',
        'Origin': 'http://kimcartoon.to',
        'Connection': 'keep-alive',
        'Referer': url,
    }
    response = sess.get(url, headers=headers, verify=False)
    data = {
    'krsk': '1378'
    }
    
    response = sess.post('http://kimcartoon.to/External/RSK', headers=headers, data=data, verify=False)
    if six.PY3:
        response_content= (response.content).decode(encoding='utf-8', errors='strict') 
    else:
        response_content= response.content
    key= response_content

    response = sess.get(url, headers=headers , verify=False)
    if six.PY3:
    
        response_content= (response.content).decode(encoding='utf-8', errors='strict') 
        import codecs
        response_content = codecs.decode(response_content, "unicode_escape")
    else:
        response_content= (response.content).decode('string-escape')    
        
        
    response_content =     response_content.replace("\'",'"')
    key = getKey(response_content,key)

    if six.PY3:
    
        key= key.encode(encoding='utf-8', errors='strict') 
    
    import binascii
    import base64

    selectQuality = parseDOM(response_content,'select', attrs={'id': "selectQuality"})[0]
    sources = [(a,b)
            for a,b in re.findall('value="(.+?)".+?(\d+p)',selectQuality,re.DOTALL)
            ]

    import operator
    index, value = max(enumerate(sources), key=operator.itemgetter(1))

    ciphertext = value[0]
    _0x18dbb7 = 'a5e8d2e9c1721ae0e84ad660c472c1f3'

    ivv=binascii.unhexlify(_0x18dbb7)
    hash_object = SHA256.new(key).hexdigest()
    scraper_key=binascii.unhexlify(hash_object)
    
    def unpad(data):
        if six.PY2:
            cc= data[:-ord(data[-1])]
        else:
            cc = data[:-ord(data[len(data)-1:])]
        return cc#data[:-ord(data[-1])]
    def decrypt(encrypted, key,ivv):
        key = key[:32]
        encrypted = base64.b64decode(encrypted)
        IV = ivv
        aes = AES.new(key, AES.MODE_CBC, IV)
        return unpad(aes.decrypt(encrypted))

    az=decrypt(ciphertext, scraper_key,ivv)
    if six.PY3:
    
        az= az.decode(encoding='utf-8', errors='strict') 
    stream_url = az if az else ''
    return stream_url

def getLinksgen(url):
    html=getUrlReqOk(url)    
    html = html.replace("\'",'"')

    srcs = re.findall('myPlayer\.src\(({.*?})\)',html,re.DOTALL)[0]

    src = re.findall('src\:\s*"([^"]+)',srcs,re.DOTALL)[0]
    domain = (urllib_parse.urlparse(url)).netloc
    link = 'https://'+domain+src if src else ''

    return link

def getLux(url):
    html=getUrlReqOk(url)
    html = html.replace("\'",'"')

    iframe = parseDOM(html,'iframe', attrs={'id': "my_video.*?"},ret='src')
    if iframe:
        mainurl,slug = iframe[0].split('/v/')
        posturl = mainurl+'/api/source/' + slug
        d = (urllib_parse.urlparse(mainurl)).netloc
        r = urllib_parse.quote(url)
        data= {'d':d,'r':r}
        html=getUrlReqOk(posturl,ref=url,data=data)

        import json
        jsdata = json.loads(html)
        datas=jsdata.get('data',None)
        sources = [(a.get('label'),a.get('file'))
                    for a in datas
                            ]

        import operator
        index, value = max(enumerate(sources), key=operator.itemgetter(1))
        link = value[1]
        return link
def PlayLink(url):

    if 's=beta' in url or 's=p2p' in url:
        link = StreamSelectDecode(url)
        if 'linksgen' in link:
            link = getLinksgen(link)
        link+='|User-Agent='+UA+'&Referer='+url
    elif 's=fe' in url:
        
        link = getLux(url)
        link+='|User-Agent='+UA+'&Referer='+url
    elif 's=hx' in url:
        xbmcgui.Dialog().notification('[COLOR red][B]Error[/B][/COLOR]', "[COLOR red][B]Can't resolve hydrax stream.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
        quit()
    if link:
        play_item = xbmcgui.ListItem(path=link)

        play_item.setInfo(type="Video", infoLabels={"title": nazwa,'plot':nazwa})
        
        
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)    

def ListToPlay(exlink):
    parts=getListToPlay(exlink)

    items = len(parts)

    for f in parts:
        modemy='getLinks'
        isplay=False
        fold=True

        add_item(name=f.get('title'), url=f.get('href'), mode=modemy, image=f.get('img'), infoLabels={'plot':f.get('plot')}, itemcount=items,folder=fold, IsPlayable=isplay)    
    

    xbmcplugin.endOfDirectory(addon_handle)
    
def getListToPlay(url):
    html=getUrlReqOk(url)

    out=[]
    result = parseDOM(html,'table', attrs={'class': "listing"})[0]
    links =  parseDOM(result,'td')

    for link in links:

        tyt = parseDOM(link,'a')
        if tyt:
            tyt =tyt[0]

            href = parseDOM(link,'a', ret="href")[0]
            href = MAIN_URL + href if href.startswith('/') else href
            out.append({'title':PLchar(tyt),'href':PLchar(href),'img':rys,'plot':PLchar(tyt)})
    return out

def ListSubsMov(exlink,page):
    page = int(page) if page else 1    
    filmy,pagination=getSubsMov(exlink,page)

    itemz=filmy
    items = len(filmy)
    if items>0:
        for f in itemz:
            modemy='listtoplay'
            isplay=False
            fold=True

            add_item(name=f.get('title'), url=f.get('href'), mode=modemy, image=f.get('img'), infoLabels={'code':f.get('code'),'plot':f.get('plot'),'genre':f.get('genre')}, itemcount=items,folder=fold, IsPlayable=isplay)    
        
        if pagination:
            add_item(name='[COLOR blue]>> next page >>[/COLOR]', url=exlink, mode='listsubsmov', image=RESOURCES+'right.png', page=pagination,fanart=FANART, folder=True)        
    
    
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]No results.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
    
def getSubsMov(url,page):

    out=[]
    if not 'szukaj' in url:
        nxtpage='>&rsaquo; Next <'

        url=url+fsortv+'?page=%d' %page if not '?' in url else url+'&page=%d' %page
        
        
        html=getUrlReqOk(url)
    else:
        nxtpage='>szukaj<'
        dt=url.split('ukaj:')[-1]
        data = {'keyword':dt}

        html=getUrlReqOk('https://kimcartoon.to/Search/Cartoon',MAIN_URL,data)

    result = parseDOM(html,'div', attrs={'class': "list-cartoon"})[0]

    links = re.findall('<div class="item"(.*?)<\/div>',result,re.DOTALL)

    for link in links:
        href = parseDOM(link,'a', ret="href")[0]

        tyt = parseDOM(link,'span', attrs={'class': "title"})[0]
        imag = parseDOM(link,'img', ret="src")[0]
        href = MAIN_URL + href if href.startswith('/') else href
        imag = MAIN_URL + imag if imag.startswith('/') else imag
        
        plot = parseDOM(link,'p', attrs={'class': "description"})
        plot = plot[0] if plot else tyt.strip()
        qual = parseDOM(link,'span', attrs={'class': "hd hda"})
        qual = qual[0] if qual else ''
        genre = parseDOM(link,'span', attrs={'class': "genre"})
        genre = genre[0] if genre else ''
        year = parseDOM(link,'span', attrs={'class': "hd hdy"})
    
        year = year[0] if year else ''
    
        ftitle=tyt.strip()+' [COLOR orange][B]('+qual+')[/COLOR][/B]' if qual else tyt.strip()

        out.append({'title':PLchar(ftitle),'href':href,'img':imag,'year':year,'plot':plot,'genre':genre,'code':qual,'rodz':''})
        
        
    prevpage=False 
    nextpage=False  
    ktora=False
    
    if html.find(nxtpage)>1:
        nextpage=page+1
    
    return out,nextpage

def getUrlReqOk(url,ref='',data={}):    

    headersok = {
    'User-Agent': UA,
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Connection': 'keep-alive',
    
    'Referer': ref,}
    if data:
        content=sess.post(url, headers=headersok,data=data, verify=False).content
    else:
        content=sess.get(url, headers=headersok,verify=False).content
    if six.PY3:
        content= (content).decode(encoding='utf-8', errors='strict') 
    else:
        content = content
    return content

def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&#039;',"'")
    char = char.replace('&quot;','"').replace('&oacute;','ó').replace('&rsquo;',"'")
    char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&eacute;','e')
    return char    
def PLcharx(char):
    char=char.replace("\xb9","ą").replace("\xa5","Ą").replace("\xe6","ć").replace("\xc6","Ć")
    char=char.replace("\xea","ę").replace("\xca","Ę").replace("\xb3","ł").replace("\xa3","Ł")
    char=char.replace("\xf3","ó").replace("\xd3","Ó").replace("\x9c","ś").replace("\x8c","Ś")
    char=char.replace("\x9f","ź").replace("\xaf","Ż").replace("\xbf","ż").replace("\xac","Ź")
    char=char.replace("\xf1","ń").replace("\xd1","Ń").replace("\x8f","Ź");
    return char    
    
def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    
    
        mode = params.get('mode', None)
    
        if mode == 'sort':

            dd='sorting by:'
            value=["","/MostPopular","/LatestUpdate","/Newest"]
            label=["alphabet","popularity","Latest update","New cartoon"]

            sel = xbmcgui.Dialog().select('Select '+dd,label)
            
            if sel>-1: 
                v = value[sel] if value[sel] else ''
                n = label[sel]
            
                addon.setSetting('fsortV',v)
                addon.setSetting('fsortN',n)
            
                fsortv = addon.getSetting('fsortV')

            xbmc.executebuiltin('Container.Refresh')

        elif mode =='listalph':
            ListAlphabet()
        elif mode =="listgenres":
            ListGenres()
        
        elif mode =='listtoplay':
            ListToPlay(exlink)

        elif mode == 'playLink':
            PlayLink(exlink)
    
        elif mode == 'getLinks':
            ListLinks(exlink)
    
        elif mode == 'playVid':
            PlayVid(exlink)    
            
        elif mode == 'listsubsmov':
            ListSubsMov(exlink,page)    
        elif mode == 'listseasons':
        
            ListSeasons(exlink,nazwa)

        elif mode=='search':
            query = xbmcgui.Dialog().input(u'Search...', type=xbmcgui.INPUT_ALPHANUM)
            if query:      
                query=query.replace(' ','+')
                ListSubsMov('szukaj:'+query,1)
    
            else:
                pass
    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])