# -*- coding: utf-8 -*-

'''
    Nephilim Add-on
    Copyright (C) 2015 lambda

    -Mofidied by  __    ____  ________ __ ____  ____ _       ___   __     __  ______   ________  _______   ________
   / /   / __ \/ ____/ //_// __ \/ __ \ |     / / | / /    /  |/  /   | / ____/ / / /  _/ | / / ____/
  / /   / / / / /   / ,<  / / / / / / / | /| / /  |/ /    / /|_/ / /| |/ /   / /_/ // //  |/ / __/   
 / /___/ /_/ / /___/ /| |/ /_/ / /_/ /| |/ |/ / /|  /    / /  / / ___ / /___/ __  // // /|  / /___   
/_____/\____/\____/_/ |_/_____/\____/ |__/|__/_/ |_/____/_/  /_/_/  |_\____/_/ /_/___/_/ |_/_____/   
                                                  /_____/                                            


    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os,sys
import xbmc
import six

from resources.lib.modules import control
from resources.lib.modules import trakt
from resources.lib.modules import cache

sysaddon = sys.argv[0]
syshandle = int(sys.argv[1])

artPath = control.artPath()
addonFanart = control.addonFanart()

imdbCredentials = False if control.setting('imdb.user') == '' else True

traktCredentials = trakt.getTraktCredentialsInfo()

traktIndicators = trakt.getTraktIndicatorsInfo()

queueMenu = six.ensure_str(control.lang(32065))


class navigator:
    def root(self):
        self.addDirectoryItem('[COLOR lightseagreen]Movie[/COLOR] [COLOR khaki]Collections[/COLOR]', 'collectionsNavigator', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Mov[/COLOR][COLOR khaki]ies[/COLOR]', 'movieNavigator', 'movies.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR lightseagreen]TV[/COLOR] [COLOR khaki]Shows[/COLOR]', 'tvNavigator', 'tvshows.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Lis[/COLOR][COLOR khaki]ts[/COLOR]', 'xmlsNavigator', 'lists.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Kids[/COLOR][COLOR khaki] Lists[/COLOR]', 'kidsNavigator', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Nephilim[/COLOR] [COLOR khaki]Cartoons[/COLOR]', 'cartoonsNavigator', 'icon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Nephilim Adult', 'adultNavigator', 'adult.png', 'DefaultTVShows.png')
        if not control.setting('furk.ai') == '':
            self.addDirectoryItem('Furk.net', 'furkNavigator', 'icon.png', 'icon.png')
        self.addDirectoryItem('[COLOR lightseagreen]Too[/COLOR][COLOR khaki]ls[/COLOR]', 'toolNavigator','tools.png', 'DefaultAddonProgram.png')
        downloads = True if control.setting('downloads') == 'true' and (len(control.listDir(control.setting('movie.download.path'))[0]) > 0 or len(control.listDir(control.setting('tv.download.path'))[0]) > 0) else False
        if downloads == True:
            self.addDirectoryItem('download', 'downloadNavigator','icon.png', 'DefaultFolder.png')
        self.addDirectoryItem('[COLOR lightseagreen]Sea[/COLOR][COLOR khaki]rch[/COLOR]', 'searchNavigator','search.png', 'DefaultFolder.png')
        self.addDirectoryItem('[COLOR lightseagreen]Resolve[/COLOR][COLOR khaki]Url[/COLOR]', 'ruSettings', 'ru.png', 'DefaultFolder.png')

        self.endDirectory()
        
    def xmls(self):
        self.addDirectoryItem('[COLOR lightseagreen]Loon[/COLOR][COLOR khaki]atics[/COLOR]', 'extinfo', 'loon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('[COLOR lightseagreen]Clubhouse Sto[/COLOR][COLOR khaki]ner Lists[/COLOR]', 'lists1', 'clubhouse.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Wolf[/COLOR][COLOR khaki]girl[/COLOR]', 'wolfNavigator', 'wolfgirl.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Stoner', 'movies&url=stoner', 'lists.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR lightseagreen]Nephilim[/COLOR] [COLOR khaki]TV[/COLOR]', 'lists2', 'icon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Xml playlists 3', 'lists3', 'icon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Xml playlists 4', 'lists4', 'icon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Xml playlists 5', 'lists5', 'icon.png', 'DefaultTVShows.png')
        #self.addDirectoryItem('Xml playlists 6', 'lists6', 'icon.png', 'DefaultTVShows.png')
        
        self.endDirectory()
        
    def wolf(self):
        self.addDirectoryItem('Action', 'movies&url=wolfaction', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Comedy', 'movies&url=wolfcomedy', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Monsters', 'movies&url=wolfmonster', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Xmas', 'movies&url=wolfxmas', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Apocolypse', 'movies&url=wolfapoco', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Toons', 'movies&url=wolftoon', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Docs', 'movies&url=wolfdocs', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Vault', 'movies&url=wolfvault', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Sleepy Hallow', 'movies&url=wolfsleepy', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Paranormal', 'movies&url=wolfpara', 'icon.png', 'DefaultMovies.png')
        
        self.endDirectory()

    def collections(self):
        self.addDirectoryItem('Predator', 'movies&url=alienscoll', 'predator.png', 'DefaultMovies.png')
        self.addDirectoryItem('Underworld', 'movies&url=undercoll', 'underworld.png', 'DefaultMovies.png')
        self.addDirectoryItem('Lord of the Rings', 'movies&url=lotrcoll', 'lotr.png', 'DefaultMovies.png')
        self.addDirectoryItem('Star Wars', 'movies&url=starcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Star Trek', 'movies&url=startrekcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Blade', 'movies&url=bladecoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Adam Sandler', 'movies&url=adamcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Will Ferrel', 'movies&url=willcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Transformers', 'movies&url=transcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Saw', 'movies&url=sawcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Halloween', 'movies&url=halloweencoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Planet of the Apes', 'movies&url=apescoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Hell Boy', 'movies&url=hbcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Batman/Dark Knight', 'movies&url=batcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Back to the Future', 'movies&url=backtothefuturecoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('The Jersey Collection', 'movies&url=jerseycoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Hannibal Lecter Collection', 'movies&url=hannibalcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Mission Impossible', 'movies&url=micoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Austin Powers', 'movies&url=austincoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Hangover', 'movies&url=hangovercoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Hellraiser', 'movies&url=hellcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Madmax', 'movies&url=madmaxcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Terminator', 'movies&url=terminatorcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('X-Men', 'movies&url=xmencoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Wolverine', 'movies&url=wolverinecoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Naked Gun', 'movies&url=nakedcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Die Hard', 'movies&url=diecoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Pirates of the Caribbean', 'movies&url=piratescoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Evil Dead', 'movies&url=evildeadcoll', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Matrix', 'movies&url=matrixcoll', 'icon.png', 'DefaultMovies.png')


        self.endDirectory()

    def kids(self):
        self.addDirectoryItem('Best Kids Movies', 'movies&url=kidsbest', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Nineties Big Kids Movies', 'movies&url=bigkids', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Top 100 Family Movies', 'movies&url=family', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Retro Cartoons', 'movies&url=retro', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Nick Toons', 'movies&url=nick', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Childrens Horror', 'movies&url=childrenshorror', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Kids Adventure', 'movies&url=adventure', 'icon.png', 'DefaultMovies.png')


        self.endDirectory()
        
    def tvsport(self):
        xbmc.executebuiltin('RunAddon(plugin.video.nephilim.tv)')
        
        self.endDirectory()
        
    def tvsport1(self):
        xbmc.executebuiltin('RunAddon(plugin.video.nephilim.tvb)')
        
        self.endDirectory()
        
    
        
    def cartoon(self):
        xbmc.executebuiltin('RunAddon(plugin.video.nephilim.toons)')
        
        self.endDirectory()
        
    def cartoons(self):
        self.addDirectoryItem('Nephilim Cartoons', 'cartoonNavigator', 'toons.png', 'DefaultTVShows.png')
        
        self.endDirectory()
        
    def adult(self):
        self.addDirectoryItem('Nephilim Adult', 'nephilimdevilNavigator', 'adult.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Nephilim Adult B', 'cuminationNavigator', 'adult.png', 'DefaultTVShows.png')
        
        self.endDirectory()
        
    def nephilimdevil(self):
        xbmc.executebuiltin('RunAddon(plugin.video.nephilim.adult)')
        
        self.endDirectory()
        
    def cumination(self):
        xbmc.executebuiltin('RunAddon(plugin.video.nephilim.adultb)')
        
        self.endDirectory()
    
    def furk(self):
        self.addDirectoryItem(90001, 'furkUserFiles','icon.png', 'mytvnavigator.png')
        self.addDirectoryItem('Search', 'furkSearch', 'icon.png', 'search.png')
        self.endDirectory()

    def movies(self, lite=False):
        self.addDirectoryItem(32003, 'mymovieliteNavigator','icon.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem(32005, 'movieWidget','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32022, 'movies&url=theaters', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32017, 'movies&url=trending', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32018, 'movies&url=popular', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('IMDB Lists', 'imdblist', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32020, 'movies&url=boxoffice', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32021, 'movies&url=oscars','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32011, 'movieGenres','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32012, 'movieYears','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32013, 'moviePersons','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32014, 'movieLanguages','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32019, 'movies&url=views','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32028, 'moviePerson','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32010, 'movieSearch','icon.png', 'DefaultMovies.png')

        self.endDirectory()

    def mymovies(self, lite=False):
        self.accountCheck()

        if traktCredentials == True and imdbCredentials == True:
            self.addDirectoryItem(90050, 'movies&url=onDeck','icon.png', 'DefaultMovies.png')
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'icon.png', 'DefaultMovies.png',queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'icon.png', 'DefaultMovies.png',queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'icon.png', 'DefaultMovies.png', queue=True)

        elif traktCredentials == True:
            self.addDirectoryItem(90050, 'movies&url=onDeck','icon.png', 'DefaultMovies.png')
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'icon.png', 'DefaultMovies.png',queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'icon.png', 'DefaultMovies.png',queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))

        elif imdbCredentials == True:
            self.addDirectoryItem(32032, 'movies&url=imdbwatchlist', 'icon.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32033, 'movies&url=imdbwatchlist2', 'icon.png', 'DefaultMovies.png', queue=True)

        if traktCredentials == True:
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'icon.png', 'DefaultMovies.png', queue=True)

        elif imdbCredentials == True:
            self.addDirectoryItem(32035, 'movies&url=featured', 'icon.png', 'DefaultMovies.png', queue=True)

        if traktIndicators == True:
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'icon.png', 'DefaultMovies.png', queue=True)

        self.addDirectoryItem(32039, 'movieUserlists','icon.png', 'DefaultMovies.png')

        if lite == False:
            self.addDirectoryItem(32031, 'movieliteNavigator', 'icon.png', 'DefaultMovies.png')
            self.addDirectoryItem(32028, 'moviePerson','icon.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch','icon.png', 'DefaultMovies.png')

        self.endDirectory()

    def tvshows(self, lite=False):
        self.addDirectoryItem(32004, 'mytvliteNavigator','icon.png', 'DefaultVideoPlaylists.png')
        self.addDirectoryItem(32006, 'calendar&url=added', 'icon.png','DefaultRecentlyAddedEpisodes.png', queue=True)
        self.addDirectoryItem(32026, 'tvshows&url=premiere', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32024, 'tvshows&url=airing', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32017, 'tvshows&url=trending','icon.png', 'DefaultRecentlyAddedEpisodes.png')
        self.addDirectoryItem(32018, 'tvshows&url=popular', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32011, 'tvGenres', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32016, 'tvNetworks','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32023, 'tvshows&url=rating', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32019, 'tvshows&url=views','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32014, 'tvLanguages','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32025, 'tvshows&url=active', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32027, 'calendars', 'icon.png', 'DefaultRecentlyAddedEpisodes.png')
        self.addDirectoryItem(32028, 'tvPerson', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32010, 'tvSearch', 'icon.png', 'DefaultTVShows.png')

        self.endDirectory()

    def mytvshows(self, lite=False):
        try:
            self.accountCheck()

            if traktCredentials == True and imdbCredentials == True:
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'icon.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'icon.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
                self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'icon.png', 'DefaultTVShows.png')

            elif traktCredentials == True:
                self.addDirectoryItem(90050, 'calendar&url=onDeck', 'icon.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'icon.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'icon.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))

            elif imdbCredentials == True:
                self.addDirectoryItem(32032, 'tvshows&url=imdbwatchlist', 'icon.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32033, 'tvshows&url=imdbwatchlist2', 'icon.png', 'DefaultTVShows.png')

            if traktCredentials == True:
                self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'icon.png', 'DefaultTVShows.png')

            elif imdbCredentials == True:
                self.addDirectoryItem(32035, 'tvshows&url=trending', 'icon.png', 'DefaultMovies.png', queue=True)

            if traktIndicators == True:
                self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'icon.png', 'DefaultTVShows.png', queue=True)
                self.addDirectoryItem(32037, 'calendar&url=progress', 'icon.png','DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32038, 'calendar&url=mycalendar','icon.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)

            self.addDirectoryItem(32040, 'tvUserlists','icon.png', 'DefaultTVShows.png')

            if traktCredentials == True:
                self.addDirectoryItem(32041, 'episodeUserlists', 'icon.png', 'DefaultTVShows.png')

            if lite == False:
                self.addDirectoryItem(32031, 'tvliteNavigator', 'icon.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32028, 'tvPerson', 'icon.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32010, 'tvSearch', 'icon.png', 'DefaultTVShows.png')

            self.endDirectory()
        except:
            print("ERROR")

    def tools(self):
        self.addDirectoryItem('Authorize : Trakt', 'authTrakt','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Autorize : ResolveUrl', 'ResolveUrlTorrent','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Nephilim : Clear providers', 'clearSources','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Nephilim : Clear search history', 'clearCacheSearch','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Nephilim : Clear cache', 'clearCache','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Nephilim : Clear Meta cache', 'clearMetaCache','icon.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem('Nephilim : Clear all cache', 'clearAllCache','icon.png', 'DefaultAddonProgram.png')

        self.endDirectory()

    def library(self):
        self.addDirectoryItem(32557, 'openSettings&query=5.0', 'icon.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32558, 'updateLibrary&query=tool', 'icon.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32559, control.setting('library.movie'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem(32560, control.setting('library.tv'), 'icon.png', 'DefaultTVShows.png', isAction=False)

        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32561, 'moviesToLibrary&url=traktcollection', 'icon.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32562, 'moviesToLibrary&url=traktwatchlist', 'icon.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32563, 'tvshowsToLibrary&url=traktcollection', 'icon.png', 'DefaultTVShows.png', isFolder=False)
            self.addDirectoryItem(32564, 'tvshowsToLibrary&url=traktwatchlist', 'icon.png', 'DefaultTVShows.png', isFolder=False)

        self.endDirectory()

    def downloads(self):
        movie_downloads = control.setting('movie.download.path')
        tv_downloads = control.setting('tv.download.path')

        if len(control.listDir(movie_downloads)[0]) > 0:
            self.addDirectoryItem(32001, movie_downloads, 'icon.png', 'DefaultMovies.png', isAction=False)
        if len(control.listDir(tv_downloads)[0]) > 0:
            self.addDirectoryItem(32002, tv_downloads, 'icon.png', 'DefaultTVShows.png', isAction=False)

        self.endDirectory()

    def search(self):
        self.addDirectoryItem(32001, 'movieSearch','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvSearch', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32029, 'moviePerson','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32030, 'tvPerson', 'icon.png', 'DefaultTVShows.png')

        self.endDirectory()

    def views(self):
        try:
            control.idle()

            items = [ (six.ensure_str(control.lang(32001)), 'movies'), (six.ensure_str(control.lang(32002)), 'tvshows'), (six.ensure_str(control.lang(32054)), 'seasons'), (six.ensure_str(control.lang(32038)), 'episodes') ]

            select = control.selectDialog([i[0] for i in items], six.ensure_str(control.lang(32049)))

            if select == -1:
                return

            content = items[select][1]

            title = control.lang(32059).encode('utf-8')
            url = '%s?action=addView&content=%s' % (sys.argv[0], content)

            poster, banner, fanart = control.addonPoster(
            ), control.addonBanner(), control.addonFanart()

            item = control.item(label=title)
            item.setInfo(type='Video', infoLabels={'title': title})
            item.setArt({'icon': poster, 'thumb': poster,
                         'poster': poster, 'banner': banner})
            item.setProperty('Fanart_Image', fanart)

            control.addItem(handle=int(
                sys.argv[1]), url=url, listitem=item, isFolder=False)
            control.content(int(sys.argv[1]), content)
            control.directory(int(sys.argv[1]), cacheToDisc=True)

            from resources.lib.modules import views
            views.setView(content, {})
        except:
            return

    def accountCheck(self):
        if traktCredentials == False and imdbCredentials == False:
            control.idle()
            control.infoDialog(six.ensure_str(control.lang(32042)), sound=True, icon='WARNING')
            sys.exit()


    def infoCheck(self, version):
        try:
            control.infoDialog('', six.ensure_str(control.lang(32074)), time=5000, sound=False)
            return '1'
        except:
            return '1'

    def clearCache(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheMeta(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_meta()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheProviders(self):
        #control.idle()
#        yes = control.yesnoDialog(control.lang(32056))
#        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_providers()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheSearch(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_search()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearDebridCheck(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_debrid()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheAll(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_all()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def addDirectoryItem(self, name, query, thumb, icon, context=None, queue=False, isAction=True, isFolder=True):
        try: name = six.ensure_str(control.lang(name))
        except: pass
        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
        thumb = os.path.join(artPath, thumb) if not artPath == None else icon
        cm = []
        if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
        if not context == None: cm.append((six.ensure_str(control.lang(context[0])), 'RunPlugin(%s?action=%s)' % (sysaddon, context[1])))
        item = control.item(label=name)
        item.addContextMenuItems(cm)
        item.setArt({'icon': thumb, 'thumb': thumb})
        if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
        control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)


    def imdblist(self):

        self.addDirectoryItem('Top 100', 'movies&url=top100','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Top 250', 'movies&url=top250','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Top 1000', 'movies&url=top1000','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Rated G', 'movies&url=rated_g','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rated PG', 'movies&url=rated_pg','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rated PG13', 'movies&url=rated_pg13','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rated R', 'movies&url=rated_r','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rated NC17', 'movies&url=rated_nc17','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Best Director', 'movies&url=bestdirector','icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('National Film Board', 'movies&url=national_film_board', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('Dreamworks', 'movies&url=dreamworks_pictures', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Fox', 'movies&url=fox_pictures','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Paramount', 'movies&url=paramount_pictures', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('MGM', 'movies&url=mgm_pictures','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Universal', 'movies&url=universal_pictures', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Sony', 'movies&url=sony_pictures','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Warner Brothers', 'movies&url=warnerbrothers_pictures', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Amazon Prime', 'movies&url=amazon_prime','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Disney', 'movies&url=disney_pictures', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Family', 'movies&url=family_movies','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic', 'movies&url=classic_movies','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic Horror', 'movies&url=classic_horror','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic fantasy', 'movies&url=classic_fantasy', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic western', 'movies&url=classic_western', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic animation', 'movies&url=classic_annimation', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic war', 'movies&url=classic_war','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Classic scifi', 'movies&url=classic_scifi','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Eighties', 'movies&url=eighties','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Nineties', 'movies&url=nineties','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Noughties', 'movies&url=noughties','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Twenty Tens', 'movies&url=twentyten','icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Twenty Twenties', 'movies&url=twentytwo','icon.png', 'DefaultTVShows.png')

        self.endDirectory()


    def endDirectory(self):
        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc=True)
