# -*- coding: utf-8 -*-

'''
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''


import re,urllib,urlparse
from resources.lib.modules import cleantitle
from resources.lib.modules import client
from resources.lib.modules import control




class source:
    def __init__(self):
        self.base_link = 'http://www.vidics.ch'
        self.moviesearch_link = '/Category-Movies/Genre-Any/Letter-Any/ByPopularity/1/Search-%s.htm'
        self.tvsearch_link = '/Category-TvShows/Genre-Any/Letter-Any/ByPopularity/1/Search-%s.htm'
        self.episode_link = '-Season-%01d-Episode-%01d'


    def movie(self, imdb, title, year):
        try:
            query = self.moviesearch_link % (urllib.quote_plus(title))
            query = urlparse.urljoin(self.base_link, query)

            result = client.request(query)
            result = client.parseDOM(result, 'div', attrs = {'class': 'searchResult'})

            title = cleantitle.get(title)
            years = ['%s' % str(year), '%s' % str(int(year)+1), '%s' % str(int(year)-1)]
            result = [(client.parseDOM(i, 'a', ret='href')[0], client.parseDOM(i, 'h2', ret='title')[0], client.parseDOM(i, 'span', attrs = {'itemprop': 'copyrightYear'})) for i in result]
            result = [i for i in result if len(i[2]) > 0]
            result = [i for i in result if title == cleantitle.get(i[1])]
            result = [i[0] for i in result if any(x in i[2][0] for x in years)][0]

            try: url = re.compile('//.+?(/.+)').findall(result)[0]
            except: url = result
            url = client.replaceHTMLCodes(url)
            url = url.encode('utf-8')
            return url
        except:
            return


    def tvshow(self, imdb, tvdb, tvshowtitle, year):
        try:
            query = self.tvsearch_link % (urllib.quote_plus(tvshowtitle))
            query = urlparse.urljoin(self.base_link, query)

            result = client.request(query)
            result = client.parseDOM(result, 'div', attrs = {'class': 'searchResult'})

            tvshowtitle = cleantitle.get(tvshowtitle)
            years = ['%s' % str(year), '%s' % str(int(year)+1), '%s' % str(int(year)-1)]
            result = [(client.parseDOM(i, 'a', ret='href')[0], client.parseDOM(i, 'h2', ret='title')[0], client.parseDOM(i, 'span', attrs = {'itemprop': 'copyrightYear'})) for i in result]
            print result

            result = [i for i in result if len(i[2]) > 0]
            result = [i for i in result if tvshowtitle == cleantitle.get(i[1])]
            result = [i[0] for i in result if any(x in i[2][0] for x in years)][0]

            try: url = re.compile('//.+?(/.+)').findall(result)[0]
            except: url = result
            url = client.replaceHTMLCodes(url)
            url = url.encode('utf-8')
            print('Vidics',url)
            return url
        except:
            return


    def episode(self, url, imdb, tvdb, title, premiered, season, episode):
        if url == None: return

        url += self.episode_link % (int(season), int(episode))
        url = client.replaceHTMLCodes(url)
        url = url.encode('utf-8')
        return url


    def sources(self, url, hostDict, hostprDict):
        try:
            sources = []

            if url == None: return sources

            url = urlparse.urljoin(self.base_link, url)

            result = client.request(url)
            result = result.decode('iso-8859-1').encode('utf-8')
            links = client.parseDOM(result, 'div', attrs = {'class': 'lang'})[0]
            links = client.parseDOM(links, 'div', attrs = {'class': 'movie_link.+?'})
            print links

            fmt = [client.parseDOM(i, 'h4')[0] for i in links]
            fmt = [re.findall('\w+', i.lower()) for i in fmt]
            fmt = sum(fmt, [])

            if any(x in ['dvdscr', 'r5', 'r6'] for x in fmt): quality = 'SCR'
            elif any(x in ['camrip', 'tsrip', 'hdcam', 'hdts', 'dvdcam', 'dvdts', 'cam', 'ts'] for x in fmt): quality = 'CAM'
            else: quality = 'SD'
            count = 0
            for i in links:
                if count > 100: break
                count += 1
                try:
                    
                    host = client.parseDOM(i, 'a', attrs = {'target': '.+?'})[0]
                    host = host.strip().lower()
                    if not host in hostDict: raise Exception()
                    host = host.split('.', 1)[0]
                    #if not host in hostDict: raise Exception()
                    host = client.replaceHTMLCodes(host)
                    host = host.encode('utf-8')

                    url = client.parseDOM(i, 'a', ret='href')[0]
                    url = client.replaceHTMLCodes(url)
                    url = urlparse.urljoin(self.base_link, url)
                    url = url.encode('utf-8')

                    sources.append({'source': host, 'quality': quality, 'provider': 'Vidics', 'url': url, 'direct': False, 'debridonly': False})
                except:
                    pass

            return sources
        except:
           
            return sources


    def resolve(self, url):
        try:
            url = client.request(url, output='geturl')
            url = url.encode('utf-8')
            return url
        except:
            return
			


