# -*- coding: utf-8 -*-
import random, json
import xbmcup.app, xbmcup.system, xbmcup.net
try:
    from collections import OrderedDict
except ImportError:
    # python 2.6 or earlier, use backport
    from ordereddict import OrderedDict

class FingerPrint:
    #https://valve.github.io/fingerprintjs2/
    fingerprints = [

        #Many thanks to 7brend7 (https://github.com/7brend7/) for this:
        # {
        #     'hash'          : '46309efe7f245682cbce9cfdbab31fd8',
        #     'components'    : '[{"key":"user_agent","value":"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.110 Safari/537.36"},{"key":"language","value":"en-US"},{"key":"color_depth","value":24},{"key":"pixel_ratio","value":1},{"key":"hardware_concurrency","value":2},{"key":"resolution","value":[1680,1050]},{"key":"available_resolution","value":[1680,1014]},{"key":"timezone_offset","value":-180},{"key":"session_storage","value":1},{"key":"local_storage","value":1},{"key":"indexed_db","value":1},{"key":"open_database","value":1},{"key":"cpu_class","value":"unknown"},{"key":"navigator_platform","value":"Linux x86_64"},{"key":"do_not_track","value":"unknown"},{"key":"regular_plugins","value":["Chrome PDF Viewer::::application/pdf~pdf","Shockwave Flash::Shockwave Flash 25.0 r0::application/x-shockwave-flash~swf,application/futuresplash~spl","Widevine Content Decryption Module::Enables Widevine licenses for playback of HTML audio/video content. (version: 1.4.8.970)::application/x-ppapi-widevine-cdm~","Native Client::::application/x-nacl~,application/x-pnacl~","Chrome PDF Viewer::Portable Document Format::application/x-google-chrome-pdf~pdf"]},{"key":"canvas","value":"canvas winding:yes~canvas fp:data:image/png;base64,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"},{"key":"webgl","value":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAANjklEQVR4Xu2dTYhlRxXH7+0n4mKEgC6yGGUCI4IGDRIEJYseDCKSRUAXLrJQUMhCUCSLLJR+DVmIiGQRUHCThUICWQQXIhLoNyiSxTBpxyZpMhO7nXRCi1+jxK+ofT1173398T763ffuvVXnVP1mmdxXder/P/ObqnOr6uYZf1AABVDAiAK5kTgJEwVQAAUygEUSoAAKmFEAYJmxikBRAAUAFjmAAihgRgGAZcYqAkUBFABY5AAKoIAZBQCWGasIFAVQAGCRAyiAAmYUAFhmrCJQFEABgEUOoAAKmFEAYJmxikBRAAUAFjmAAihgRgGAZcYqAkUBFABY5AAKoIAZBQCWGasIFAVQAGCRAyiAAmYUAFhmrCJQFEABgEUOoAAKmFEAYJmxikBRAAUAFjnQuQJFka27RvM8G3XeOA0mrQDAStr+fgZfA2tLgEV+9SNxsq2SUMla39/Aj4psKIm1Uc+yyLH+pE6uZZIpOcv7H7DMsLakl3JZCLT61zulHgBWSm57GOt/pX61lmVbE4m1KcvDoYfu6SJyBQBW5Ab7Ht4cYLkwrlCE9+1GfP0BrPg8DToiV7+SADZmJRZF+KDWRNE5wIrCRj2D+J/UrySp1uclFtDS45XFSACWRdeUxuyWgxLaltSwzt3PALSUGmggLIBlwCQrITYFloxnJNC6YmVcxKlHAYClxwvzkQiwyvrVohlWPVCK8OYd9z8AgOVf82h7/E9dv2oILHd0h/yLNhv6GRgJ04+uybXqloNFvf+qKbCcSEAruVRpNWCA1Uo+fjxWYFVgAS1yaBkFANYyavHsXAXers8PuoRaZoZVN0gRntxqpADAaiQTDy1SQIB1vP9qBWC55inCLxKZ/0/RkxzoRoF/F1kxBtWKwKKe1Y0VUbfCDCtqe/0M7l9ScJdEOt4wuiqwqGf58ctyLwDLsntKYhdglfdftZ1hjYfDm0MlxioMA2ApNMVaSP+U+pXAyl0rU9YY2sywKMJbc99vvADLr95R9ibAKutXHQLL6cQdWlFmS7tBAax2+iX/67ekfjWo61cdA4sifPLZNS0AwCIpWinwj1P1q66BRRG+lTVR/hhgRWmrv0EJsMr9Vz0sCY8HQRHen5/aewJY2h1SHp8AqxgX2vuYYVGEV54AnsMDWJ4Fj6k7V78af3CizxlWrRlF+JiSZ8WxAKwVheNnWSbAGgqoyvvbPQDLSc7xncQTD2AlngBthv/3ifODPS4JqWe1MSqi3wKsiMz0PZQQwOLNoW+XdfUHsHT5YSYaV7+SYM+cH/Qxw6IIbyZFegkUYPUia/yN/q2uX52GlEdgOYEpwsefZlMjBFgJmt7FkAVYU+cHPQOLInwXRhprA2AZM0xLuEqAxfEdLQnhKQ6A5UnomLq5U++/mtzKEGCGVcrKTviYsuv8sQCsdLzubKQCrHL/lRZgAa3OrFXfEMBSb5G+AP865/xgqBlWrRBFeH2p0nlEAKtzSeNvUCmwKMLHn3p8hCIBjzsdoqtfSYPl/itNS8LxIKlndWq3usaYYamzRHdArn4lER7XrwLuw5orFNDSnUNtogNYbdRL8Ld/mahfaQQWRfh4ExNgxettLyOzAiwZPF+T7iUDwjYKsMLqb6p3V78qpH51+joZrTOsWliuozGVYYuDBViLNeKJWgGDwGJTaWTZC7AiM7TP4fx5xv1XymdYpRwU4fvMCr9tAyy/epvuzSqwgJbptDsTPMCKx8teR/JHqV9Jskzdf2VhhlULQxG+1wzx0zjA8qOz+V4iAJbzgCK88UwEWMYN9BX+H+bcf2VohkU9y1ey9NgPwOpR3JiajgVY1LNsZyXAsu2fl+jdctDtv5p1dtDaDGssGG8OvaRO550ArM4lja/BGIElLlGEN5iqAMugab5DdstB6dN95bm8ocHQTvdFUnGH1iKFlP1/gKXMEI3hRAwsNpVqTLhzYgJYxgzzHe5hfX/7rM/Ra7wPaxV9qGetolqY3wCsMLqb6TUFYPHm0Ew6cuOoHavCRHp4JB+cKLKNmGdYpbK5FOHXsithVKbXpgoww2qqVKLP/f7t8joZdyxn5pXIVrc1zLFzM39neaMqf5QqALCUGqMhrMO35P72tenzgxG9JZyW+UiO71zIRhr0J4ZpBQAWWTFXgcM7AqxBYsByq8N3UyrR+tcCYGl1RkFcb945+WBqIkvCY9Xzu4CWghScCgFgaXRFSUxv/klmV9W2hjObRaNeEo61d0X491CEV5KKJ/+QaAuIeHQocHAooMpnnx9MAljOhiLbzO+mCK8jI6somGFpckNRLAcHAKu0o5Ai/EWK8FpSE2BpcUJZHAe3T+pXSS4JT/mRv59/2LWkJ8DS4oSyON7Yq/ZfnXf8JpajOU2kz+8BWk106vsZgNW3wkbbf+NmVsx7M5hMDWvCu/wDQCt0OgOs0A4o7P9gt/rgBMCaMOdIivAfoggfMmUBVkj1lfZ9eycbDrL55wdTnWHVdl3J76UIHyp1AVYo5RX3+/qNav8VM6zZJuUfZWkYKn0BVijlFff7+vWsOO/NYOIzrNK5/GNAK0QKA6wQqivuc//FbH2w4MAzwKoMzD8OtHynMsDyrbjy/vZ/JfWrPNtghtXAqEKO73yS4zsNlOrsEYDVmZRxNHT7Fyf7r6hhNfA0l53wD1CEb6BUJ48ArE5kjKeR342q+hUzrOae5ussDZur1e5JgNVOv6h+vf+CvBlscOCZGtaU7aP8UywNffxlAFg+VDbSx/7Ps2Eu97czw2pomFxBI1PRzfxBloQNFWv9GMBqLWE8Dez9tLxOZuH5QWZYNag+A6h8Zz/A8q244v72fnJSv6KGNdOoakb1EKAKlcYAK5Tyyvrdfz5bL+ST9OPlIMA6Y9BIyupX5b+M8oeBVcjUBVgh1VfU92+fk/qVnB8EWBOmyF4rgdVm/nlApSFdAZYGFxTEsPdstiW3ax7Xr5KfYbmC+gBQKUjNMyEALG2OBIpn78cCrFMF94SBJTvRBFSPMKMKlIrndguwNLriOaZbT1f3tzd5+zcJsmi+/DzeogCoPGffct0BrOX0ivJpAdZw7ejs/VfJzLAcqFyN6ovMqCwkN8Cy4FLPMb72w+r8YGIzrApUXwZUPadXp80DrE7ltNnYa99PClgVqB4FVBazFWBZdK3DmG89la1Lc+X+q6hnWNX2hGov1VeBVYcp5LUpgOVVbn2d3Xqy/KjC1P1XUdWwXJ3Kvfn7OqDSl4HLRQSwltMruqdvfk+Wg/X+q+hmWOM3f4AqmrwFWNFYudpAbn5n9oV9xmdY1Zm/x5hRrZYVen8FsPR603tku0/I/qv6/vZIalgVqB4HVL0nT6AOAFYg4TV0uzsUYA1ODjybXRK6groD1TcBlYa86jMGgNWnusrbfnVDjuPks++/MrEkHB9MHgIq5anWWXgAqzMp7TX06rfOHng2M8Mav/V7AlDZy7p2EQOsdvqZ/fXu49X97achZQBYbntCtZfq28DKbPK1CBxgtRDP8k93HzMGrPEWBUBlOe1axw6wWktos4FXvlHd325ghlUV1L/LjMpmpnUbNcDqVk8zrb3yNQGWbBhVC6zxLQpPAiozSeUhUIDlQWRtXew8mq0P6u0MCoFVHU5+ClBpyxsN8QAsDS54jqEE1owDz0GL7uMtCj8AVJ7TwVR3AMuUXd0E+/JXZp8fDAKs8d3pgKobcyNvBWBFbvCs4b38pdnnBz0Dq7pB4WlmVAmm4MpDBlgrS2fzhzuPVNsZFn2Ovred7m5GlcleqjXZSwWsbCZRwKgBVkDxQ3S98wUB1pwDzx5mWNUWhR8xqwrhfQx9AqwYXFxiDAKsodx/dfzBVE9vCas3f88AqiWs4tEZCgCsxNLiN5+rNox6WhJWoHoOUCWWZr0NF2D1Jq2+hnceru5vnzer6mpJOBhvUXgeUOnLAtsRASzb/i0V/c5DPQNLCuq5fN79HYBqKV94uLkCAKu5VuafvPFZ+WCq1K86n2E5UB1lm+/6GTMq80mifAAAS7lBXYZ349PnH3hedkkou+VHhbz1uwCourSJts5RAGAlkh7b6yf3t7edYUnBfiRtXJX74EcXXmBWlUgKqRgmwFJhQ/9BlMAqpj+YusK2hpFsPN28awSo+neNHiYVAFiJ5MT2A1X9qsUO9hJU7/0loEokZVQOE2CptKX7oH79icUHnmfVsAZSUC/kzN/dLwKq7l2hxWUVAFjLKmbw+e37ZTtDg/ODE8AaFbJF4SKgMuh4vCEDrHi9PR7Z9n3NgeVmVEfy5u/SNWZUCaSGuSECLHOWLR/w9keyofzq3PODbouCHIrevLQNqJZXmF/4UgBg+VI6YD8vffikfjX1SXq36VOK6Zd3AFVAi+i6oQIAq6FQlh976YNZMWP7wkiWf1fdnqrLu8DKsr8pxQ6wInf72uXq/vYzBXU5nHwks6p7bwGqyO2PbngAKzpLzw7o+iW5/0rqVyWwZPm3Jm/+AFXkpkc8PIAVsbluaNffV82u5NK+zfsOmFFFbnf0wwNYkVt87WK2fj+gitzldIYHsNLxmpGigHkFAJZ5CxkACqSjAMBKx2tGigLmFQBY5i1kACiQjgIAKx2vGSkKmFcAYJm3kAGgQDoKAKx0vGakKGBegf8D8TMmtWUqgPgAAAAASUVORK5CYII=~extensions:ANGLE_instanced_arrays;EXT_blend_minmax;EXT_disjoint_timer_query;EXT_frag_depth;EXT_shader_texture_lod;EXT_sRGB;EXT_texture_filter_anisotropic;WEBKIT_EXT_texture_filter_anisotropic;OES_element_index_uint;OES_standard_derivatives;OES_texture_float;OES_texture_float_linear;OES_texture_half_float;OES_texture_half_float_linear;OES_vertex_array_object;WEBGL_compressed_texture_s3tc;WEBKIT_WEBGL_compressed_texture_s3tc;WEBGL_debug_renderer_info;WEBGL_debug_shaders;WEBGL_depth_texture;WEBKIT_WEBGL_depth_texture;WEBGL_draw_buffers;WEBGL_lose_context;WEBKIT_WEBGL_lose_context~webgl aliased line width range:[1, 8192]~webgl aliased point size range:[0, 8192]~webgl alpha bits:8~webgl antialiasing:yes~webgl blue bits:8~webgl depth bits:24~webgl green bits:8~webgl max anisotropy:16~webgl max combined texture image units:48~webgl max cube map texture size:8192~webgl max fragment uniform vectors:4096~webgl max render buffer size:8192~webgl max texture image units:16~webgl max texture size:8192~webgl max varying vectors:32~webgl max vertex attribs:16~webgl max vertex texture image units:16~webgl max vertex uniform vectors:4096~webgl max viewport dims:[8192, 8192]~webgl red bits:8~webgl renderer:WebKit WebGL~webgl shading language version:WebGL GLSL ES 1.0 (OpenGL ES GLSL ES 1.0 Chromium)~webgl stencil bits:0~webgl vendor:WebKit~webgl version:WebGL 1.0 (OpenGL ES 2.0 Chromium)~webgl unmasked vendor:X.Org~webgl unmasked renderer:Gallium 0.4 on AMD RV770 (DRM 2.46.0 / 4.8.0-45-generic, LLVM 3.8.1)~webgl vertex shader high float precision:23~webgl vertex shader high float precision rangeMin:127~webgl vertex shader high float precision rangeMax:127~webgl vertex shader medium float precision:23~webgl vertex shader medium float precision rangeMin:127~webgl vertex shader medium float precision rangeMax:127~webgl vertex shader low float precision:23~webgl vertex shader low float precision rangeMin:127~webgl vertex shader low float precision rangeMax:127~webgl fragment shader high float precision:23~webgl fragment shader high float precision rangeMin:127~webgl fragment shader high float precision rangeMax:127~webgl fragment shader medium float precision:23~webgl fragment shader medium float precision rangeMin:127~webgl fragment shader medium float precision rangeMax:127~webgl fragment shader low float precision:23~webgl fragment shader low float precision rangeMin:127~webgl fragment shader low float precision rangeMax:127~webgl vertex shader high int precision:0~webgl vertex shader high int precision rangeMin:31~webgl vertex shader high int precision rangeMax:30~webgl vertex shader medium int precision:0~webgl vertex shader medium int precision rangeMin:31~webgl vertex shader medium int precision rangeMax:30~webgl vertex shader low int precision:0~webgl vertex shader low int precision rangeMin:31~webgl vertex shader low int precision rangeMax:30~webgl fragment shader high int precision:0~webgl fragment shader high int precision rangeMin:31~webgl fragment shader high int precision rangeMax:30~webgl fragment shader medium int precision:0~webgl fragment shader medium int precision rangeMin:31~webgl fragment shader medium int precision rangeMax:30~webgl fragment shader low int precision:0~webgl fragment shader low int precision rangeMin:31~webgl fragment shader low int precision rangeMax:30"},{"key":"adblock","value":true},{"key":"has_lied_languages","value":false},{"key":"has_lied_resolution","value":false},{"key":"has_lied_os","value":false},{"key":"has_lied_browser","value":false},{"key":"touch_support","value":[0,false,false]},{"key":"js_fonts","value":["Arial","Courier","Courier New","Helvetica","Times","Times New Roman"]}]',
        #     'useragent'     : 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.110 Safari/537.36'
        # }

        # {
        #     'hash'          : '40c7d907c2a8a62117a73eba8985db4e',
        #     'components'    : '[{"key":"user_agent","value":"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36"},{"key":"language","value":"ru"},{"key":"color_depth","value":24},{"key":"pixel_ratio","value":1},{"key":"hardware_concurrency","value":2},{"key":"resolution","value":[1920,1080]},{"key":"available_resolution","value":[1920,1040]},{"key":"timezone_offset","value":-180},{"key":"session_storage","value":1},{"key":"local_storage","value":1},{"key":"indexed_db","value":1},{"key":"open_database","value":1},{"key":"cpu_class","value":"unknown"},{"key":"navigator_platform","value":"Win32"},{"key":"do_not_track","value":"unknown"},{"key":"regular_plugins","value":["Widevine Content Decryption Module::Enables Widevine licenses for playback of HTML audio/video content. (version: 1.4.8.984)::application/x-ppapi-widevine-cdm~","Chrome PDF Viewer::::application/pdf~","Native Client::::application/x-nacl~,application/x-pnacl~","Chrome PDF Viewer::Portable Document Format::application/x-google-chrome-pdf~pdf"]},{"key":"canvas","value":"canvas winding:yes~canvas fp:data:image/png;base64,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"},{"key":"webgl","value":"data:image/png;base64,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~extensions:ANGLE_instanced_arrays;EXT_blend_minmax;EXT_disjoint_timer_query;EXT_frag_depth;EXT_shader_texture_lod;EXT_sRGB;EXT_texture_filter_anisotropic;WEBKIT_EXT_texture_filter_anisotropic;OES_element_index_uint;OES_standard_derivatives;OES_texture_float;OES_texture_float_linear;OES_texture_half_float;OES_texture_half_float_linear;OES_vertex_array_object;WEBGL_compressed_texture_s3tc;WEBKIT_WEBGL_compressed_texture_s3tc;WEBGL_debug_renderer_info;WEBGL_debug_shaders;WEBGL_depth_texture;WEBKIT_WEBGL_depth_texture;WEBGL_draw_buffers;WEBGL_lose_context;WEBKIT_WEBGL_lose_context~webgl aliased line width range:[1, 1]~webgl aliased point size range:[1, 1024]~webgl alpha bits:8~webgl antialiasing:yes~webgl blue bits:8~webgl depth bits:24~webgl green bits:8~webgl max anisotropy:16~webgl max combined texture image units:32~webgl max cube map texture size:8192~webgl max fragment uniform vectors:1024~webgl max render buffer size:8192~webgl max texture image units:16~webgl max texture size:8192~webgl max varying vectors:14~webgl max vertex attribs:16~webgl max vertex texture image units:16~webgl max vertex uniform vectors:4096~webgl max viewport dims:[8192, 8192]~webgl red bits:8~webgl renderer:WebKit WebGL~webgl shading language version:WebGL GLSL ES 1.0 (OpenGL ES GLSL ES 1.0 Chromium)~webgl stencil bits:0~webgl vendor:WebKit~webgl version:WebGL 1.0 (OpenGL ES 2.0 Chromium)~webgl unmasked vendor:Google Inc.~webgl unmasked renderer:ANGLE (NVIDIA GeForce 9400 GT Direct3D11 vs_4_0 ps_4_0)~webgl vertex shader high float precision:23~webgl vertex shader high float precision rangeMin:127~webgl vertex shader high float precision rangeMax:127~webgl vertex shader medium float precision:23~webgl vertex shader medium float precision rangeMin:127~webgl vertex shader medium float precision rangeMax:127~webgl vertex shader low float precision:23~webgl vertex shader low float precision rangeMin:127~webgl vertex shader low float precision rangeMax:127~webgl fragment shader high float precision:23~webgl fragment shader high float precision rangeMin:127~webgl fragment shader high float precision rangeMax:127~webgl fragment shader medium float precision:23~webgl fragment shader medium float precision rangeMin:127~webgl fragment shader medium float precision rangeMax:127~webgl fragment shader low float precision:23~webgl fragment shader low float precision rangeMin:127~webgl fragment shader low float precision rangeMax:127~webgl vertex shader high int precision:0~webgl vertex shader high int precision rangeMin:31~webgl vertex shader high int precision rangeMax:30~webgl vertex shader medium int precision:0~webgl vertex shader medium int precision rangeMin:31~webgl vertex shader medium int precision rangeMax:30~webgl vertex shader low int precision:0~webgl vertex shader low int precision rangeMin:31~webgl vertex shader low int precision rangeMax:30~webgl fragment shader high int precision:0~webgl fragment shader high int precision rangeMin:31~webgl fragment shader high int precision rangeMax:30~webgl fragment shader medium int precision:0~webgl fragment shader medium int precision rangeMin:31~webgl fragment shader medium int precision rangeMax:30~webgl fragment shader low int precision:0~webgl fragment shader low int precision rangeMin:31~webgl fragment shader low int precision rangeMax:30"},{"key":"adblock","value":false},{"key":"has_lied_languages","value":false},{"key":"has_lied_resolution","value":false},{"key":"has_lied_os","value":false},{"key":"has_lied_browser","value":false},{"key":"touch_support","value":[0,false,false]},{"key":"js_fonts","value":["Arial","Arial Black","Arial Narrow","Arial Unicode MS","Book Antiqua","Bookman Old Style","Calibri","Cambria","Cambria Math","Century","Century Gothic","Century Schoolbook","Comic Sans MS","Consolas","Courier","Courier New","Garamond","Georgia","Helvetica","Helvetica Neue","Impact","Lucida Bright","Lucida Calligraphy","Lucida Console","Lucida Fax","Lucida Handwriting","Lucida Sans","Lucida Sans Typewriter","Lucida Sans Unicode","Microsoft Sans Serif","Monotype Corsiva","MS Gothic","MS PGothic","MS Reference Sans Serif","MS Sans Serif","MS Serif","MYRIAD PRO","Palatino Linotype","Segoe Print","Segoe Script","Segoe UI","Segoe UI Light","Segoe UI Semibold","Segoe UI Symbol","Tahoma","Times","Times New Roman","Trebuchet MS","Verdana","Wingdings","Wingdings 2","Wingdings 3"]}]',
        #     'useragent'     : 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36'
        # }
    ]


    def getFingerprint(self):
        file = xbmcup.system.fs('sandbox://fingerprint.json')
        f = open(file, 'rb')
        content = ''
        for line in f.readlines():
            content += line
        f.close()
        rand = json.loads(content, 'utf-8')

        # return {}
        # rand = random.choice(self.fingerprints)
        rand['components'] = self.createDict(rand['hash'], rand['components'])
        return rand


    def createDict(self, hash, components):
        data = OrderedDict()
        cplist = json.loads(components, 'utf-8')
        data['result'] = hash
        index = 0
        #Many thanks to 7brend7 for this: https://github.com/7brend7/repository.evgen_dev.xbmc-addons/blob/master/source/plugin.video.tree.tv.dev/core/http.py ^^
        for item in cplist:
            data['components['+str(index)+'][key]'] = str(item['key'])
            if isinstance(item['value'], list):
                data['components['+str(index)+'][value][]'] = item['value']
            else:
                data['components['+str(index)+'][value]'] = str(item['value'])
            index += 1
        return data.items()

